/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;

public class IdempotencyUtil {
    private static final Log LOG = LogFactory.getLog(IdempotencyUtil.class);
    private static final int MAX_TIMEOUT = 7776000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doIdempotency(HttpServletRequest req, OpenApiData openApiData, Supplier<Void> supplier) {
        String apiUrl;
        OpenApiDataService openApiDataService;
        boolean isRepeatExecute;
        Pair<String, Integer> idKeyHeader = IdempotencyUtil.getIdempotencyHeader(req);
        String idKeyFromHeader = "";
        int timeout = 0;
        if (idKeyHeader != null) {
            idKeyFromHeader = (String)idKeyHeader.getKey();
            timeout = (Integer)idKeyHeader.getValue();
        }
        if (StringUtil.isNotEmpty((String)idKeyFromHeader) && timeout == 0 && (isRepeatExecute = (openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService()).checkIdempotency(apiUrl = ApiDataUtil.getApiUrl((HttpServletRequest)req), idKeyFromHeader))) {
            throw new OpenApiException(ApiErrorCode.Data_Repeat_Execute, ApiErrorCode.Data_Repeat_Execute.toString(), new Object[0]);
        }
        DLock lock = null;
        try {
            String idKeyStr = "";
            boolean existDBIdKey = false;
            if (StringUtil.isNotEmpty((String)idKeyFromHeader) && timeout > 0) {
                idKeyStr = openApiData.getApiId() + "_" + idKeyFromHeader;
                String lockKey = RequestContext.get().getAccountId() + "_checkDbIdempotency_" + idKeyStr;
                lock = DLock.create((String)lockKey, (String)("IdempotencyUtil.checkDbIdempotency-" + idKeyStr));
                if (!lock.tryLock(5000L)) {
                    throw new OpenApiException(ApiErrorCode.Data_Repeat_Execute, ApiErrorCode.Data_Repeat_Execute.toString(), new Object[0]);
                }
                existDBIdKey = IdempotencyUtil.checkDbIdempotencyExists(idKeyStr, timeout);
                if (existDBIdKey) {
                    throw new OpenApiException(ApiErrorCode.Data_Repeat_Execute, ApiErrorCode.Data_Repeat_Execute.toString(), new Object[0]);
                }
            }
            try {
                IdempotencyUtil.checkApiOptionRepeatRequest(req, openApiData);
            }
            catch (Throwable e) {
                if (e instanceof OpenApiException && ApiErrorCode.Data_Repeat_Execute.getStatusCode().equals(((OpenApiException)e).getCode())) {
                    IdempotencyUtil.saveIdempotencyKeyToDb(idKeyStr, timeout, false);
                }
                if (e instanceof RuntimeException) {
                    throw e;
                }
                throw new RuntimeException(e);
            }
            supplier.get();
            IdempotencyUtil.saveIdempotencyKeyToDb(idKeyStr, timeout, false);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static Pair<String, Integer> getIdempotencyHeader(HttpServletRequest req) {
        if (IdempotencyUtil.isHeaderHasElement(req.getHeaderNames(), "Idempotency-Key")) {
            String idempotencyKey = req.getHeader("Idempotency-Key");
            if (StringUtil.isEmpty((String)idempotencyKey) || idempotencyKey.length() > 48) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u5e42\u7b49\u503c %1$s \u7684\u957f\u5ea6\u8303\u56f4\u4e3a [1, %2$d]", (String)"KCFServlet_0", (String)"bos-open-kcf", (Object[])new Object[0]), "Idempotency-Key", 48), new Object[0]);
            }
            if (IdempotencyUtil.isHeaderHasElement(req.getHeaderNames(), "Idempotency-Timeout")) {
                Integer timeout;
                String idempotencyTimeOut = req.getHeader("Idempotency-Timeout");
                try {
                    timeout = (Integer)ObjectConverter.convert((Object)idempotencyTimeOut, Integer.class, (boolean)true);
                }
                catch (Exception e) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u5e42\u7b49\u8d85\u65f6\u65f6\u95f4 %1$s \u7684\u8303\u56f4\u4e3a [1, %2$d] \u79d2", (String)"KCFServlet_1", (String)"bos-open-kcf", (Object[])new Object[0]), "Idempotency-Timeout", 7776000), new Object[0]);
                }
                if (timeout == null || timeout <= 0 || timeout > 7776000) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u5e42\u7b49\u8d85\u65f6\u65f6\u95f4 %1$s \u7684\u8303\u56f4\u4e3a [1, %2$d] \u79d2", (String)"KCFServlet_1", (String)"bos-open-kcf", (Object[])new Object[0]), "Idempotency-Timeout", 7776000), new Object[0]);
                }
                return new Pair((Object)idempotencyKey, (Object)timeout);
            }
            return new Pair((Object)idempotencyKey, (Object)0);
        }
        return null;
    }

    private static void checkApiOptionRepeatRequest(HttpServletRequest req, OpenApiData openApiData) {
        if (openApiData != null && openApiData.isCheckRepeatReq()) {
            boolean isRepeatExecute = false;
            try {
                String apiUrl = ApiDataUtil.getApiUrl((HttpServletRequest)req);
                OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
                isRepeatExecute = openApiDataService.checkIdempotency(apiUrl, (InputStream)req.getInputStream(), req.getQueryString());
            }
            catch (Throwable e) {
                LOG.error("checkIdempotency.checkRepeatReq", e);
                throw new RuntimeException(e);
            }
            if (isRepeatExecute) {
                throw new OpenApiException(ApiErrorCode.Data_Repeat_Execute, ApiErrorCode.Data_Repeat_Execute.toString(), new Object[0]);
            }
        }
    }

    private static void saveIdempotencyKeyToDb(String idKey, Integer timeout, boolean existDBIdKey) {
        if (!existDBIdKey && StringUtil.isNotEmpty((String)idKey) && timeout > 0) {
            IdempotencyUtil.saveIdempotencyKeyToDb(idKey, timeout);
        }
    }

    private static boolean checkDbIdempotencyExists(String idKey, Integer timeout) {
        String sql = "select timeoutdate from t_openapi_idempotency where idkey = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":idkey", 12, (Object)idKey)};
        Timestamp timeoutDate = (Timestamp)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> rs.next() ? rs.getTimestamp("timeoutdate") : null);
        if (timeoutDate == null) {
            return false;
        }
        if (timeoutDate.getTime() > System.currentTimeMillis()) {
            return true;
        }
        IdempotencyUtil.clearExpireDbIdempotencyKey(idKey);
        return false;
    }

    private static void saveIdempotencyKeyToDb(String idempotencyKey, Integer timeout) {
        String sql = "insert into t_openapi_idempotency(idkey, timeoutdate) values (?, ?)";
        Object[] params = new SqlParameter[]{new SqlParameter(":idkey", 12, (Object)idempotencyKey), new SqlParameter(":timeoutdate", 91, (Object)DateUtil.getDateAdd((Date)new Date(), (int)13, (int)timeout))};
        if (!DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5e42\u7b49\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f", (String)"KCFServlet_2", (String)"bos-open-kcf", (Object[])new Object[0]), new Object[0]);
        }
    }

    public static void clearExpireDbIdempotencyKey(String idKey) {
        String idKeyWhere = StringUtil.isEmpty((String)idKey) ? "" : " idkey = ? and ";
        String sql = "delete from t_openapi_idempotency where " + idKeyWhere + " timeoutdate < ?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(2);
        if (StringUtil.isNotEmpty((String)idKey)) {
            params.add(new SqlParameter(":idkey", 12, (Object)idKey));
        }
        params.add(new SqlParameter(":timeoutdate", 91, (Object)new Date()));
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray());
    }

    private static boolean isHeaderHasElement(Enumeration<String> headerNames, String headerName) {
        if (headerNames == null || StringUtil.isEmpty((String)headerName)) {
            return false;
        }
        while (headerNames.hasMoreElements()) {
            if (!headerName.equals(headerNames.nextElement())) continue;
            return true;
        }
        return false;
    }
}

