/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;
import kd.bos.service.authorize.model.ApiCommonResult;

public class OpenApiExceptionUtil {
    private static Log log = LogFactory.getLog(OpenApiExceptionUtil.class);
    private static final String CRLF = "\r\n\t";
    private static final int CauseDepth = 50;
    public static final String LIMIT_FLOW_MESSAGE = "Too many request, Flow Limit is exceed.";

    public static String getExceptionMessage(Throwable ex, String pluginInstanceId) {
        if (ex == null) {
            return "";
        }
        int count = 0;
        while (ex instanceof InvocationTargetException && count++ < 50) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        count = 0;
        while (ex.getCause() != null && count++ < 50 && (!(ex instanceof OpenApiException) || StringUtil.isEmpty((String)ex.getMessage()))) {
            ex = ex.getCause();
        }
        String errMsg = OpenApiExceptionUtil.getCascadeMessage(ex);
        return errMsg + OpenApiExceptionUtil.getExceptionStackInfo(ex, pluginInstanceId);
    }

    public static String getExceptionMessage(Throwable ex) {
        return OpenApiExceptionUtil.getExceptionMessage(ex, "");
    }

    public static String getExceptionStackInfo(Throwable ex, String pluginInstanceId) {
        String result;
        if (ex == null) {
            return "";
        }
        int count = 0;
        while (ex.getCause() != null && count++ < 50) {
            ex = ex.getCause();
        }
        StringBuilder sb = new StringBuilder();
        if (RequestContext.get() != null) {
            sb.append(",TraceId\uff1a").append(RequestContext.get().getTraceId());
        }
        if (OpenApiExceptionUtil.isShowStackTrace()) {
            sb.append(CRLF).append("WebInstance\uff1a").append(Instance.getInstanceId()).append(CRLF);
            if (StringUtil.isNotEmpty((String)pluginInstanceId)) {
                sb.append("PluginInstance:").append(pluginInstanceId).append(CRLF);
            }
            sb.append("Time:").append(DataUtil.datetimeToString((Date)new Date())).append(CRLF);
            sb.append("====Stack====").append(CRLF);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            sb.append(sw.getBuffer().toString());
            String msg = sb.toString().replace(CRLF, "   \n");
            int pos = msg.indexOf("(OpenApiServlet.java");
            result = pos > 0 ? msg.substring(0, pos) : msg;
        } else {
            result = sb.toString();
        }
        return result;
    }

    public static String getCascadeMessage(Throwable err) {
        StringBuilder s = new StringBuilder();
        HashSet<Throwable> visited = new HashSet<Throwable>();
        int count = 0;
        for (Throwable e = err; e != null && visited.add(e) && count++ < 50; e = e.getCause()) {
            if (e.getMessage() == null && (e instanceof UndeclaredThrowableException || e instanceof InvocationTargetException)) continue;
            String message = e.getMessage();
            if (message != null && s.indexOf(message) < 0) {
                if (s.length() > 0) {
                    s.append(",Reason:");
                }
                s.append(message);
                continue;
            }
            if (!StringUtil.isEmpty((String)message)) continue;
            s.append(e.toString());
        }
        return s.toString();
    }

    public static OpenApiResult handleException(Throwable exception) {
        return OpenApiExceptionUtil.handleException(exception, OpenApiContext.getResponse());
    }

    public static OpenApiResult handleException(Throwable exception, HttpServletResponse resp) {
        String errMsg = OpenApiExceptionUtil.getExceptionMessage(exception);
        int httpCode = HttpStatus.OK.getStatusCode();
        boolean isArmoEx = OpenApiExceptionUtil.isException(exception, "ArmorException");
        OpenApiResult result = OpenApiContext.getResult();
        if (exception instanceof OpenApiException) {
            int errHttpStatus;
            String errorCode = ((OpenApiException)exception).getCode();
            if (StringUtil.isEmpty((String)errorCode)) {
                errorCode = ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode();
            }
            if ((errHttpStatus = ((OpenApiException)exception).getHttpStatus()) != 200) {
                httpCode = errHttpStatus;
            }
            result.fail(errMsg, errorCode);
        } else if (exception instanceof KDException) {
            String errorCode = ((KDException)exception).getErrorCode().getCode();
            result.fail(errMsg, errorCode);
        } else if (isArmoEx) {
            httpCode = HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode();
            String errorCode = String.valueOf(HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode());
            result.fail(LIMIT_FLOW_MESSAGE, errorCode);
        } else {
            log.error("OpenAPI-" + errMsg, exception);
            httpCode = HttpStatus.BAD_REQUEST.getStatusCode();
            String errorCode = ApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode();
            result.fail(errMsg, String.valueOf(errorCode));
        }
        if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
            ApiStreamUtil.sendStatus(httpCode, resp);
        }
        return result;
    }

    public static boolean isException(Throwable e, String exceptionName) {
        return e.getClass().getCanonicalName().contains(exceptionName);
    }

    private static boolean isShowStackTrace() {
        String showStackTrace = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_openlog_showstack", "false");
        return "true".equals(showStackTrace);
    }

    public static ApiCommonResult handleAuthException(Throwable exception, HttpServletResponse response, ApiCommonResult result) {
        String errMsgLog = OpenApiExceptionUtil.getExceptionMessage(exception);
        String errMsg = OpenApiExceptionUtil.getCascadeMessage(exception);
        if (RequestContext.get() != null) {
            errMsg = errMsg + ",TraceId\uff1a" + RequestContext.get().getTraceId();
        }
        errMsgLog = errMsgLog + OpenApiExceptionUtil.getExceptionStackInfoNoContext(exception, "", RequestContext.get().getTraceId());
        OpenApiAuthContext.getContext().addParamExt("errMsgLog", errMsgLog);
        int httpCode = HttpStatus.OK.getStatusCode();
        boolean isArmoEx = OpenApiExceptionUtil.isException(exception, "ArmorException");
        if (exception instanceof OpenApiException) {
            String errorCode = ((OpenApiException)exception).getCode();
            if (StringUtil.isEmpty((String)errorCode)) {
                errorCode = ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode();
            }
            result.fail(errMsg, errorCode);
        } else if (exception instanceof KDException) {
            String errorCode = ((KDException)exception).getErrorCode().getCode();
            result.fail(errMsg, errorCode);
        } else if (isArmoEx) {
            httpCode = HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode();
            String errorCode = String.valueOf(HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode());
            result.fail(LIMIT_FLOW_MESSAGE, errorCode);
        } else {
            log.error("OpenAPI-" + errMsg, exception);
            httpCode = HttpStatus.BAD_REQUEST.getStatusCode();
            String errorCode = ApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode();
            result.fail(errMsg, String.valueOf(errorCode));
        }
        if (response.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
            response.setStatus(httpCode);
        }
        return result;
    }

    public static String getExceptionStackInfoNoContext(Throwable ex, String pluginInstanceId, String traceId) {
        String result;
        if (ex == null) {
            return "";
        }
        int count = 0;
        while (ex.getCause() != null && count++ < 50) {
            ex = ex.getCause();
        }
        StringBuilder sb = new StringBuilder();
        if (OpenApiExceptionUtil.isShowStackTrace()) {
            sb.append(",TraceId\uff1a").append(traceId);
            sb.append(CRLF).append("WebInstance\uff1a").append(Instance.getInstanceId()).append(CRLF);
            if (StringUtil.isNotEmpty((String)pluginInstanceId)) {
                sb.append("PluginInstance:").append(pluginInstanceId).append(CRLF);
            }
            sb.append("Time:").append(DataUtil.datetimeToString((Date)new Date())).append(CRLF);
            sb.append("====Stack====").append(CRLF);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            sb.append(sw.getBuffer().toString());
            String msg = sb.toString().replace(CRLF, "   \n");
            int pos = msg.indexOf("(OpenApiServlet.java");
            result = pos > 0 ? msg.substring(0, pos) : msg;
        } else {
            result = sb.toString();
        }
        return result;
    }
}

