/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;

public class WsdlUtil {
    private static Log log = LogFactory.getLog(WsdlUtil.class);
    private static final String CONTENT_TYPE = "text/xml";
    private static final String WSDL2 = "wsdl2";
    private static final String WSDL1 = "wsdl";
    private static final String SOAP_11 = "soap11";
    private static final String SOAP_12 = "soap12";
    private static final String SPLIT_AND = "&";
    private static final String SPLIT_EQ = "=";

    public static boolean isWsdl(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        if (!HttpMethod.GET.getName().equals(req.getMethod())) {
            return false;
        }
        String query = req.getQueryString();
        List<String> queryKeys = WsdlUtil.getAllKeys(query);
        for (String key : queryKeys) {
            if (!WSDL2.equalsIgnoreCase(key) && !WSDL1.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWsdlRequest(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String query = req.getQueryString();
        List<String> queryKeys = WsdlUtil.getAllKeys(query);
        for (String key : queryKeys) {
            if (!WSDL2.equalsIgnoreCase(key) && !WSDL1.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public static void makeWsdl(HttpServletRequest req, HttpServletResponse res, OpenApiData openApiData) {
        ServiceApiData serviceApiData = new ServiceApiData();
        serviceApiData.setClassName(openApiData.getClassName());
        serviceApiData.setMethodName(openApiData.getMethodName());
        serviceApiData.setNamespace(openApiData.getNamespace());
        serviceApiData.setApiId(openApiData.getApiId());
        serviceApiData.setAppId(openApiData.getAppId());
        serviceApiData.setApiServiceType(openApiData.getApiServiceType().name());
        serviceApiData.setHttpMethod(openApiData.getHttpMethod().getName());
        serviceApiData.setApiDefType(openApiData.getApiDefType() != null ? openApiData.getApiDefType().getCode() : null);
        serviceApiData.setApiOperationType(openApiData.getApiOperationType());
        serviceApiData.setWsMethodName(openApiData.getWsMethodName());
        serviceApiData.setOutParaWithoutStatus(openApiData.isOutParaWithoutStatus());
        String query = req.getQueryString();
        String soap = SOAP_11;
        List<String> queryKeys = WsdlUtil.getAllKeys(query);
        for (String key : queryKeys) {
            if (WSDL2.equalsIgnoreCase(key)) {
                soap = SOAP_12;
                break;
            }
            if (!WSDL1.equalsIgnoreCase(key)) continue;
            soap = SOAP_11;
            break;
        }
        String out = OpenApiServiceManager.getWsdlAction().execute(serviceApiData, soap);
        ServletOutputStream outputStream = null;
        try {
            outputStream = res.getOutputStream();
            res.setContentType(CONTENT_TYPE);
            outputStream.write(out.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "makeWsdl exception:" + e.getMessage(), new Object[0]);
        }
        finally {
            IOUtil.closeQuietly((Closeable)outputStream);
        }
    }

    private static List<String> getAllKeys(String query) {
        ArrayList<String> keylist = new ArrayList<String>();
        if (query == null) {
            return keylist;
        }
        String[] params = query.split(SPLIT_AND);
        if (params.length > 0) {
            for (String param : params) {
                String[] key = param.split(SPLIT_EQ);
                if (key.length <= 0) continue;
                keylist.add(key[0]);
            }
        }
        return keylist;
    }
}

