> 二开业务微服务调用

#### 基本用法：

```js
MS.invokeService(factoryQualifiedPrefix, appId, serviceName, methodName, params);
```

#### 参数说明：

| 参数                   | 说明                                                         | 类型   | 必填 |
| ---------------------- | ------------------------------------------------------------ | ------ | ---- |
| factoryQualifiedPrefix | Factory类限定前缀，如：服务工厂`isv.ti.bo.ServiceFactory`<br>的` factoryQualifiedPrefix`为`isv.ti.bo` | 字符串 | √    |
| appId                  | 应用Id                                                       | 字符串 | √    |
| serviceName            | 注册的服务名称                                               | 字符串 | √    |
| methodName             | 调用服务方法                                                 | 字符串 | √    |
| params                 | 方法入参                                                     | 数组   | √    |

#### 结果说明：

调用服务方法返回值


#### 代码示例：

```js
MS.invokeService("kd.isc.iscb.platform.core.isv", "iscb", "TestService", "sayHello", ["hello, world"]);
```

#### 输出结果：

```js
kd.isc.iscb.platform.core.isv.TestServiceImpl : say hello, world
```

