> API调用，适用于请求地址以 **/V2** 开头的所有API

#### 基本用法：

```java
OpenApiResult result = OpenApiSdkUtil.invoke(String apiUrl, Map<String, Object> requestData, Map<String, String> header);
```

#### 参数说明：

| 参数        | 说明     | 类型                | 必填 |
| ----------- | -------- | ------------------- | ---- |
| apiUrl      | 请求地址 | String              | √    |
| requestData | 请求参数 | Map<String, Object> | √    |
| header      | 请求头   | Map<String, String> |      |

#### 结果说明：

> OpenApiResult

| 参数      | 说明                            | 类型     |
| --------- | ------------------------------- | -------- |
| status    | 状态：true - 成功, false - 失败 | boolean  |
| errorCode | 错误代码                        | String   |
| message   | 错误信息                        | String   |
| data      | 响应数据                        | 任意类型 |


#### 代码示例：

```java
String apiUrl = "/v2/xxxxx";

Map<String, Object> requestData = new HashMap<>();
requestData.put("pageSize",10);
requestData.put("pageNo",1);

Map<String, Object> data = new HashMap<>();
data.put("number", "xxx");
requestData.put("data",data);

Map<String, String> header = new HashMap<>();
header.put("xxx", "xxx");

OpenApiResult result = OpenApiSdkUtil.invoke(apiUrl, requestData, header);
```

