/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.consumer;

import com.alibaba.fastjson.JSON;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.model.ExtHandleMsg;
import kd.bos.bd.log.util.EsUtils;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class PermLogDiffConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(PermLogDiffConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        ExtHandleMsg extHandleMsg = null;
        if (!(body instanceof ExtHandleMsg)) {
            logger.warn("PermLogDiffConsumer.onMessage, \u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u63d0\u9192\u751f\u6210\u65e5\u5fd7\u5dee\u5f02!");
            acker.discard(messageId);
            return;
        }
        extHandleMsg = (ExtHandleMsg)body;
        String logType = extHandleMsg.getLogType();
        Integer num = extHandleMsg.getNum();
        if (StringUtils.isEmpty((String)logType) || null == num || num.equals(0)) {
            logger.warn("PermLogDiffConsumer.onMessage, param invalid, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            acker.discard(messageId);
            return;
        }
        boolean checkLogType = EnumBDLogType.checkLogType((String)logType);
        if (!checkLogType) {
            logger.warn("PermLogDiffConsumer.onMessage, \u65e5\u5fd7\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u975e\u6cd5!");
            acker.discard(messageId);
            return;
        }
        String logTypeDesc = EnumBDLogType.getDescriByType((String)logType);
        Tuple deployEs = EsUtils.hasDeployedEs((String)logType);
        if (((Boolean)deployEs.item1).booleanValue()) {
            try {
                GenDiffService.genDiff2Es(extHandleMsg, (String)deployEs.item2);
            }
            catch (Exception e) {
                logger.warn("PermLogDiffConsumer.onMessage, [{}], \u4ea7\u751f\u65e5\u5fd7\u5dee\u5f02\uff0c\u5e76\u5b58\u50a8 es \u5f02\u5e38!", (Object)logTypeDesc, (Object)e);
                acker.deny(messageId);
                return;
            }
        }
        try {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)logType);
            if (null == logObj) {
                logger.warn("PermLogDiffConsumer.onMessage, [{}], \u4ea7\u751f\u65e5\u5fd7\u5dee\u5f02\uff0c\u8868\u5355:{} \u4e0d\u5b58\u5728", (Object)logTypeDesc, (Object)logType);
                acker.discard(messageId);
                return;
            }
        }
        catch (Exception e) {
            logger.warn("PermLogDiffConsumer.onMessage, [{}], \u4ea7\u751f\u65e5\u5fd7\u5dee\u5f02\uff0c\u8868\u5355:{} \u5143\u6570\u636e\u4e0d\u5b58\u5728", new Object[]{logTypeDesc, logType, e});
            acker.discard(messageId);
            return;
        }
        try {
            boolean ack = GenDiffService.genDiff2DB(extHandleMsg);
            if (ack) {
                acker.ack(messageId);
                return;
            }
            acker.discard(messageId);
            return;
        }
        catch (Exception e) {
            logger.warn("PermLogDiffConsumer.onMessage, [{}], \u4ea7\u751f\u65e5\u5fd7\u5dee\u5f02\uff0c \u6570\u636e\u5e93 \u5f02\u5e38!", (Object)logTypeDesc, (Object)e);
            acker.discard(messageId);
            return;
        }
    }
}

