/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogAdmOrg;
import kd.bos.permission.log.model.LogAdmOrgUser;
import kd.bos.permission.log.model.LogApp;
import kd.bos.permission.log.model.LogBusiUnit;
import kd.bos.permission.log.model.LogFuncPerm;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrg;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class AdminGroupPermSaveLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(AdminGroupPermSaveLogDiffHandler.class);

    @Override
    public void delChildTab(String fidStr) {
        PermLogService.delChildTab("t_perm_log_diff_funcperm", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_busiunit", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_admorg", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_admorgusr", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_app", fidStr);
        PermLogService.delChildTab("t_perm_log_user", fidStr);
    }

    @Override
    @Deprecated
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            boolean existsDiff = this.saveDiffDetailDirect(fid, diffMap);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper influenUserIdSetMapper = new ObjectMapper();
            List influenUserIdSet = (List)influenUserIdSetMapper.readValue(influenUserIdSetMapper.writeValueAsString(diffMap.get("influenUserIdSet")), influenUserIdSetMapper.getTypeFactory().constructParametricType(List.class, new Class[]{String.class}));
            Set influenUser = null == influenUserIdSet || influenUserIdSet.isEmpty() ? Collections.EMPTY_SET : influenUserIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            List userList = UserHelper.getUserListBySet((Set)influenUser, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_admingroup", uncompress, fid);
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private boolean saveDiffDetailDirect(Long fid, Map<String, Object> diffMap) {
        try {
            HashMap<String, String> selectField = new HashMap<String, String>(8);
            selectField.put("fbusi_type", "fbusi_type");
            Map<String, String> results = PermLogService.selectSingleFromPermLog(selectField, fid);
            if (null == results || results.isEmpty()) {
                return false;
            }
            String langStr = (String)diffMap.get("langStr");
            Map allCloudMap = AppHelper.getAllCloudMap();
            Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
            Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
            Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
            Map orgMap = OrgHelper.getAllOrgMap();
            ObjectMapper baseInfoDB_preMapper = new ObjectMapper();
            AdmGroup baseInfoDB_pre = (AdmGroup)baseInfoDB_preMapper.readValue(baseInfoDB_preMapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), AdmGroup.class);
            ObjectMapper baseInfoDB_afterMapper = new ObjectMapper();
            AdmGroup baseInfoDB_after = (AdmGroup)baseInfoDB_afterMapper.readValue(baseInfoDB_afterMapper.writeValueAsString(diffMap.get("baseInfoDB_after")), AdmGroup.class);
            boolean baseInfoDiff = this.saveDiffDetail_baseInfo(baseInfoDB_pre, baseInfoDB_after);
            boolean funpermDiff = this.saveDiffDetail_funcPerm(fid, diffMap, allCloudMap, allAppIdNameMap, entityNameMap, allPermitemMap);
            boolean bizunitDiff = this.saveDiffDetail_busiUnit(fid, diffMap, orgMap);
            boolean orgDiff = this.saveDiffDetail_admOrg(fid, diffMap, orgMap);
            boolean orgadduserDiff = this.saveDiffDetail_admOrgUser(fid, diffMap, langStr);
            boolean appDiff = this.saveDiffDetail_app(fid, diffMap, allCloudMap, allAppIdNameMap);
            return baseInfoDiff || funpermDiff || bizunitDiff || orgDiff || orgadduserDiff || appDiff;
        }
        catch (Exception ex) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetailDirect error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_baseInfo(AdmGroup baseInfoDB_pre, AdmGroup baseInfoDB_after) {
        return !Objects.equals(baseInfoDB_pre, baseInfoDB_after);
    }

    private boolean saveDiffDetail_app(Long fid, Map<String, Object> diffMap, Map<String, DynamicObject> allCloudMap, Map<String, String> allAppIdNameMap) {
        try {
            ArrayList list = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delAdmGrpApp")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpApp.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addAdmGrpApp")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpApp.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateAdmGrpApp")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpApp.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getAppRange();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appId = x.getAppId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    LogApp one = new LogApp();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName((String)allAppIdNameMap.get(appId));
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appId = x.getAppId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    LogApp one = new LogApp();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName((String)allAppIdNameMap.get(appId));
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appId = x.getAppId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    LogApp one = new LogApp();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName((String)allAppIdNameMap.get(appId));
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (null == list || list.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_app");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogApp one = (LogApp)list.get(i);
                obj = new Object[]{ids[i], fid, StrUtil.nullAbleStr((String)one.getCloudId()), StrUtil.nullAbleStr((String)one.getCloudName()), StrUtil.nullAbleStr((String)one.getAppId()), StrUtil.nullAbleStr((String)one.getAppName()), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetail_app error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_admOrgUser(Long fid, Map<String, Object> diffMap, String langStr) {
        try {
            ArrayList list = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delAdmGrpOrgAddUser")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrgAddUser.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addAdmGrpOrgAddUser")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrgAddUser.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateAdmGrpOrgAddUser")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrgAddUser.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            HashSet userIdSet = new HashSet(8);
            userIdSet.addAll(delList.stream().map(AdmGrpOrgAddUser::getUserId).collect(Collectors.toSet()));
            userIdSet.addAll(addList.stream().map(AdmGrpOrgAddUser::getUserId).collect(Collectors.toSet()));
            userIdSet.addAll(updateList.stream().map(AdmGrpOrgAddUser::getUserId).collect(Collectors.toSet()));
            Map userInfoMapByIds = UserHelper.getUserInfoMapByIds(userIdSet, (String)langStr);
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getGoverOrgRangeAddUser();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    LogAdmOrgUser one = new LogAdmOrgUser();
                    Long userId = x.getUserId();
                    one.setUserId(userId);
                    User user = (User)userInfoMapByIds.get(userId);
                    if (null != user) {
                        one.setTrueName(user.getFtruename());
                        one.setUserNumber(user.getFusername());
                        one.setUserName(user.getFusername());
                        one.setPhone(user.getFphone());
                        one.setEmail(user.getFemail());
                    }
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    LogAdmOrgUser one = new LogAdmOrgUser();
                    Long userId = x.getUserId();
                    one.setUserId(userId);
                    User user = (User)userInfoMapByIds.get(userId);
                    if (null != user) {
                        one.setTrueName(user.getFtruename());
                        one.setUserNumber(user.getFusername());
                        one.setUserName(user.getFusername());
                        one.setPhone(user.getFphone());
                        one.setEmail(user.getFemail());
                    }
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    LogAdmOrgUser one = new LogAdmOrgUser();
                    Long userId = x.getUserId();
                    one.setUserId(userId);
                    User user = (User)userInfoMapByIds.get(userId);
                    if (null != user) {
                        one.setTrueName(user.getFtruename());
                        one.setUserNumber(user.getFusername());
                        one.setUserName(user.getFusername());
                        one.setPhone(user.getFphone());
                        one.setEmail(user.getFemail());
                    }
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (null == list || list.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_admorgusr");
            sb.append("(fid, fperm_logid, fuser_id, fname, fnumber, fuser_name, fphone, femail, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogAdmOrgUser one = (LogAdmOrgUser)list.get(i);
                String trueName = StrUtil.nullAbleStr((String)one.getTrueName());
                String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
                String userName = StrUtil.nullAbleStr((String)one.getUserName());
                String phone = StrUtil.nullAbleStr((String)one.getPhone());
                String email = StrUtil.nullAbleStr((String)one.getEmail());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getUserId(), trueName, userNumber, userName, phone, email, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetail_admOrgUser error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_admOrg(Long fid, Map<String, Object> diffMap, Map<Long, Org> orgMap) {
        try {
            ArrayList list = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delAdmGrpOrg")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrg.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addAdmGrpOrg")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrg.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateAdmGrpOrg")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpOrg.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getBusiUnitRange();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String admOrgNumber = "";
                    String admOrgName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        admOrgNumber = org.getOrgNumber();
                        admOrgName = org.getOrgName();
                    }
                    LogAdmOrg one = new LogAdmOrg(orgId, admOrgNumber, admOrgName);
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String admOrgNumber = "";
                    String admOrgName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        admOrgNumber = org.getOrgNumber();
                        admOrgName = org.getOrgName();
                    }
                    LogAdmOrg one = new LogAdmOrg(orgId, admOrgNumber, admOrgName);
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String admOrgNumber = "";
                    String admOrgName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        admOrgNumber = org.getOrgNumber();
                        admOrgName = org.getOrgName();
                    }
                    LogAdmOrg one = new LogAdmOrg(orgId, admOrgNumber, admOrgName);
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (null == list || list.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_admorg");
            sb.append("(fid, fperm_logid, fadmorg_id, fadmorg_number, fadmorg_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogAdmOrg one = (LogAdmOrg)list.get(i);
                String admOrgNumber = StrUtil.nullAbleStr((String)one.getAdmOrgNumber());
                String admOrgName = StrUtil.nullAbleStr((String)one.getAdmOrgName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getAdmOrgId(), admOrgNumber, admOrgName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetail_admOrg error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_busiUnit(Long fid, Map<String, Object> diffMap, Map<Long, Org> orgMap) {
        try {
            ArrayList list = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delAdmGrpBizUnit")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpBizUnit.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addAdmGrpBizUnit")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpBizUnit.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateAdmGrpBizUnit")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpBizUnit.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getBusiUnitRange();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String busiUnitNumber = "";
                    String busiUnitName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        busiUnitNumber = org.getOrgNumber();
                        busiUnitName = org.getOrgName();
                    }
                    LogBusiUnit one = new LogBusiUnit(orgId, busiUnitNumber, busiUnitName);
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String busiUnitNumber = "";
                    String busiUnitName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        busiUnitNumber = org.getOrgNumber();
                        busiUnitName = org.getOrgName();
                    }
                    LogBusiUnit one = new LogBusiUnit(orgId, busiUnitNumber, busiUnitName);
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String busiUnitNumber = "";
                    String busiUnitName = "";
                    Long orgId = x.getOrgId();
                    Org org = (Org)orgMap.get(orgId);
                    if (null != org) {
                        busiUnitNumber = org.getOrgNumber();
                        busiUnitName = org.getOrgName();
                    }
                    LogBusiUnit one = new LogBusiUnit(orgId, busiUnitNumber, busiUnitName);
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (null == list || list.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_busiunit");
            sb.append("(fid, fperm_logid, fbusiunit_id, fbusiunit_number, fbusiunit_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogBusiUnit one = (LogBusiUnit)list.get(i);
                String busiUnitNumber = StrUtil.nullAbleStr((String)one.getBusiUnitNumber());
                String busiUnitName = StrUtil.nullAbleStr((String)one.getBusiUnitName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getBusiUnitId(), busiUnitNumber, busiUnitName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetail_busiUnit error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_funcPerm(Long fid, Map<String, Object> diffMap, Map<String, DynamicObject> allCloudMap, Map<String, String> allAppIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap) {
        try {
            ArrayList list = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delAdmGrpFunperm")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpFunperm.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addAdmGrpFunperm")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpFunperm.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateAdmGrpFunperm")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AdmGrpFunperm.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getFuncPerm();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appName = "";
                    String entityName = "";
                    String permItemName = "";
                    String appId = x.getAppId();
                    String entityId = x.getEntNum();
                    String permItemId = x.getPermItemId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = StringUtils.isEmpty((String)((String)allAppIdNameMap.get(appId))) ? x.getAppNum() : (String)allAppIdNameMap.get(appId);
                    entityName = StringUtils.isEmpty((String)((String)entityNameMap.get(entityId))) ? x.getEntNum() : (String)entityNameMap.get(entityId);
                    permItemName = StringUtils.isEmpty((String)((String)allPermitemMap.get(permItemId))) ? x.getPermItemNum() : (String)allPermitemMap.get(permItemId);
                    LogFuncPerm one = new LogFuncPerm();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    one.setPermItemId(permItemId);
                    one.setPermItemName(permItemName);
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appName = "";
                    String entityName = "";
                    String permItemName = "";
                    String appId = x.getAppId();
                    String entityId = x.getEntNum();
                    String permItemId = x.getPermItemId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = StringUtils.isEmpty((String)((String)allAppIdNameMap.get(appId))) ? x.getAppNum() : (String)allAppIdNameMap.get(appId);
                    entityName = StringUtils.isEmpty((String)((String)entityNameMap.get(entityId))) ? x.getEntNum() : (String)entityNameMap.get(entityId);
                    permItemName = StringUtils.isEmpty((String)((String)allPermitemMap.get(permItemId))) ? x.getPermItemNum() : (String)allPermitemMap.get(permItemId);
                    LogFuncPerm one = new LogFuncPerm();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    one.setPermItemId(permItemId);
                    one.setPermItemName(permItemName);
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String cloudId = "";
                    String cloudName = "";
                    String appName = "";
                    String entityName = "";
                    String permItemName = "";
                    String appId = x.getAppId();
                    String entityId = x.getEntNum();
                    String permItemId = x.getPermItemId();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = StringUtils.isEmpty((String)((String)allAppIdNameMap.get(appId))) ? x.getAppNum() : (String)allAppIdNameMap.get(appId);
                    entityName = StringUtils.isEmpty((String)((String)entityNameMap.get(entityId))) ? x.getEntNum() : (String)entityNameMap.get(entityId);
                    permItemName = StringUtils.isEmpty((String)((String)allPermitemMap.get(permItemId))) ? x.getPermItemNum() : (String)allPermitemMap.get(permItemId);
                    LogFuncPerm one = new LogFuncPerm();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    one.setPermItemId(permItemId);
                    one.setPermItemName(permItemName);
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    list.add(one);
                });
            }
            if (null == list || list.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_funcperm");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogFuncPerm one = (LogFuncPerm)list.get(i);
                obj = new Object[]{ids[i], fid, StrUtil.nullAbleStr((String)one.getCloudId()), StrUtil.nullAbleStr((String)one.getCloudName()), StrUtil.nullAbleStr((String)one.getAppId()), StrUtil.nullAbleStr((String)one.getAppName()), StrUtil.nullAbleStr((String)one.getEntityId()), StrUtil.nullAbleStr((String)one.getEntityName()), StrUtil.nullAbleStr((String)one.getPermItemId()), StrUtil.nullAbleStr((String)one.getPermItemName()), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("AdminGroupPermSaveLogDiffHandler.saveDiffDetail_funcPerm error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

