/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.BizRoleUser;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogUser;
import kd.bos.permission.log.service.GenDiffService;

public class BusiRoleAssignUserLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(BusiRoleAssignUserLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BizRoleUser.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BizRoleUser.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            HashSet<Long> userIdSet = new HashSet<Long>(8);
            for (BizRoleUser bizRoleUser : delList) {
                userIdSet.add(bizRoleUser.getFuserid());
            }
            for (BizRoleUser bizRoleUser : addList) {
                userIdSet.add(bizRoleUser.getFuserid());
            }
            Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, (String)langStr);
            this.saveDiffDetail(fid, delList, addList, userInfoMap);
            this.saveInfluenceUser(fid, userInfoMap.values().stream().collect(Collectors.toList()));
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_bizroleuser", uncompress, fid);
        }
        catch (Exception e) {
            log.error("BusiRoleAssignUserLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<BizRoleUser> delList, List<BizRoleUser> addList, Map<Long, User> userInfoMap) {
        try {
            EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
            String userConst = ConstantsHelper.getUser();
            String delDesc = ConstantsHelper.getDel();
            String delOpDesc = delDesc + userConst;
            String addDesc = ConstantsHelper.getAdd();
            String addOpDesc = addDesc + userConst;
            List del = delList.stream().map(bizru -> this.trans2LogUser((BizRoleUser)bizru, userInfoMap, delEnum, delDesc, delOpDesc)).collect(Collectors.toList());
            List add = addList.stream().map(bizru -> this.trans2LogUser((BizRoleUser)bizru, userInfoMap, addEnum, addDesc, addOpDesc)).collect(Collectors.toList());
            del.addAll(add);
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_user");
            sb.append("(fid, fperm_logid, fuser_id, fuser_name, fuser_number, fuser_username, fphone, femail, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogUser one = (LogUser)del.get(i);
                obj = new Object[]{ids[i], fid, one.getUserId(), StrUtil.nullAbleStr((String)one.getTrueName()), StrUtil.nullAbleStr((String)one.getUserNumber()), StrUtil.nullAbleStr((String)one.getUserName()), StrUtil.nullAbleStr((String)one.getPhone()), StrUtil.nullAbleStr((String)one.getEmail()), one.getFstarttime(), one.getFendtime(), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
        }
        catch (Exception e) {
            log.error("BusiRoleAssignUserLogDiffHandler.saveDiffDetail error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private LogUser trans2LogUser(BizRoleUser bizru, Map<Long, User> userInfoMap, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc) {
        LogUser logUser = new LogUser();
        Long fuserid = bizru.getFuserid();
        logUser.setUserId(fuserid);
        User user = userInfoMap.get(fuserid);
        if (null != user) {
            logUser.setUserNumber(user.getFnumber());
            logUser.setUserName(user.getFtruename());
            logUser.setTrueName(user.getFusername());
            logUser.setPhone(user.getFphone());
            logUser.setEmail(user.getFemail());
        }
        logUser.setFstarttime(bizru.getFstarttime());
        logUser.setFendtime(bizru.getFendtime());
        logUser.setDataChangeType(dataChangeType);
        logUser.setDataChangeTypeDesc(dataChangeTypeDesc);
        logUser.setOpDesc(opDesc);
        return logUser;
    }
}

