/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.enums.EnumsEnable;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogCommonRole;
import kd.bos.permission.log.model.LogDimRange;
import kd.bos.permission.log.model.LogPermBc;
import kd.bos.permission.log.model.LogPermDis;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.busirole.BusiRoleBcFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.busirole.BusiRoleDimObj;
import kd.bos.permission.model.perm.busirole.BusiRoleDisFuncPerm;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BusiRoleLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(BusiRoleLogDiffHandler.class);

    @Override
    @Deprecated
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            boolean existsDiff = this.saveDiffDetailDirect(fid, diffMap);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper influenUserIdSetMapper = new ObjectMapper();
            List influenUserIdSet = (List)influenUserIdSetMapper.readValue(influenUserIdSetMapper.writeValueAsString(diffMap.get("influenUserIdSet")), influenUserIdSetMapper.getTypeFactory().constructParametricType(List.class, new Class[]{String.class}));
            Set influenUser = null == influenUserIdSet || influenUserIdSet.isEmpty() ? Collections.EMPTY_SET : influenUserIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            List userList = UserHelper.getUserListBySet((Set)influenUser, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_busirole", uncompress, fid);
        }
        catch (Exception e) {
            log.warn("BusiRoleLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private boolean saveDiffDetailDirect(Long fid, Map<String, Object> diffMap) {
        try {
            HashMap<String, String> selectField = new HashMap<String, String>(8);
            selectField.put("fbusi_type", "fbusi_type");
            Map<String, String> results = PermLogService.selectSingleFromPermLog(selectField, fid);
            if (null == results || results.isEmpty()) {
                return false;
            }
            String langStr = (String)diffMap.get("langStr");
            Map appIdNameMap = AppHelper.getAllAppIdNameMap();
            Map entityNameMap = FormHelper.getEntityNameMap(null, (String)langStr);
            Map cloudMap = AppHelper.getCloudMap(null);
            Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
            ObjectMapper baseInfoDB_preMapper = new ObjectMapper();
            BusiRole baseInfoDB_pre = (BusiRole)baseInfoDB_preMapper.readValue(baseInfoDB_preMapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), BusiRole.class);
            ObjectMapper baseInfoDB_afterMapper = new ObjectMapper();
            BusiRole baseInfoDB_after = (BusiRole)baseInfoDB_afterMapper.readValue(baseInfoDB_afterMapper.writeValueAsString(diffMap.get("baseInfoDB_after")), BusiRole.class);
            boolean baseInfoDiff = this.saveDiffDetail_baseInfo(fid, baseInfoDB_pre, baseInfoDB_after);
            boolean comRoleDiff = this.saveDiffDetail_comRole(fid, diffMap);
            boolean dimObjDiff = this.saveDiffDetail_dimObj(fid, diffMap);
            boolean bcFuncPermDiff = this.saveDiffDetail_bcFuncPermDiff(fid, diffMap, cloudMap, appIdNameMap, entityNameMap, allPermitemMap);
            boolean disFuncPermDiff = this.saveDiffDetail_disFuncPermDiff(fid, diffMap, cloudMap, appIdNameMap, entityNameMap, allPermitemMap);
            return baseInfoDiff || comRoleDiff || dimObjDiff || bcFuncPermDiff || disFuncPermDiff;
        }
        catch (Exception ex) {
            log.warn("BusiRoleLogDiffHandler.saveDiffDetailDirect error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_disFuncPermDiff(Long fid, Map<String, Object> diffMap, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap) throws Exception {
        try {
            ArrayList all = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delDisFuncPerm")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDisFuncPerm.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addDisFuncPerm")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDisFuncPerm.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateDisFuncPerm")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDisFuncPerm.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getForbidPerm();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermDis one = new LogPermDis();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermDis one = new LogPermDis();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermDis one = new LogPermDis();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (null == all || all.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_disperm");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = all.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogPermDis one = (LogPermDis)all.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String permItemId = StrUtil.nullAbleStr((String)one.getPermItemId());
                String permItemName = StrUtil.nullAbleStr((String)one.getPermItemName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, permItemId, permItemName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("BusiRoleLogDiffHandler.saveDiffDetail_disFuncPermDiff error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_bcFuncPermDiff(Long fid, Map<String, Object> diffMap, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap) throws Exception {
        try {
            ArrayList all = new ArrayList(10);
            ObjectMapper delMapper = new ObjectMapper();
            List delList = (List)delMapper.readValue(delMapper.writeValueAsString(diffMap.get("delBcFuncPerm")), delMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleBcFuncPerm.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addMapper = new ObjectMapper();
            List addList = (List)addMapper.readValue(addMapper.writeValueAsString(diffMap.get("addBcFuncPerm")), addMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleBcFuncPerm.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateMapper = new ObjectMapper();
            List updateList = (List)updateMapper.readValue(updateMapper.writeValueAsString(diffMap.get("updateBcFuncPerm")), updateMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleBcFuncPerm.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getBcPerm();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermBc one = new LogPermBc();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermBc one = new LogPermBc();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    LogPermBc one = new LogPermBc();
                    one.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        one.setCloudId(cloud.getString("bizcloud.id"));
                        one.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    one.setEntityId(entityNumber);
                    one.setEntityName((String)entityNameMap.get(entityNumber));
                    one.setPermItemId(permItemId);
                    one.setPermItemName((String)allPermitemMap.get(permItemId));
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (null == all || all.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_bcperm");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = all.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogPermBc one = (LogPermBc)all.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String permItemId = StrUtil.nullAbleStr((String)one.getPermItemId());
                String permItemName = StrUtil.nullAbleStr((String)one.getPermItemName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, permItemId, permItemName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("BusiRoleLogDiffHandler.saveDiffDetail_bcFuncPermDiff error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_dimObj(Long fid, Map<String, Object> diffMap) {
        try {
            ArrayList all = new ArrayList(10);
            ObjectMapper delDimObjMapper = new ObjectMapper();
            List delList = (List)delDimObjMapper.readValue(delDimObjMapper.writeValueAsString(diffMap.get("delDimObj")), delDimObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDimObj.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addDimObjMapper = new ObjectMapper();
            List addList = (List)addDimObjMapper.readValue(addDimObjMapper.writeValueAsString(diffMap.get("addDimObj")), addDimObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDimObj.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateDimObjMapper = new ObjectMapper();
            List updateList = (List)updateDimObjMapper.readValue(updateDimObjMapper.writeValueAsString(diffMap.get("updateDimObj")), updateDimObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleDimObj.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String includeDesc = ConstantsHelper.getInclude();
            String notIncludeDesc = ConstantsHelper.getNotInclude();
            HashMap dimTypeDimIdSetMap = new HashMap(8);
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> dimTypeDimIdSetMap.computeIfAbsent(x.getDimTypeSmall(), k -> new HashSet(8)).add(x.getDimId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> dimTypeDimIdSetMap.computeIfAbsent(x.getDimTypeSmall(), k -> new HashSet(8)).add(x.getDimId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> dimTypeDimIdSetMap.computeIfAbsent(x.getDimTypeSmall(), k -> new HashSet(8)).add(x.getDimId()));
            }
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)RequestContext.get().getLang().name());
            HashMap<String, String> dimTypeNameMap = new HashMap<String, String>(8);
            HashMap<String, Map> dimTypeDimIdDimSetMap = new HashMap<String, Map>(8);
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                String key = (String)dimTypeDimIdSet.getKey();
                Set ldrdimIdSet = (Set)dimTypeDimIdSet.getValue();
                Map dimIdDimSetMap = IsoDimHelper.getDimSetMap(ldrdimIdSet.stream().map(String::valueOf).collect(Collectors.toSet()), (String)"id", (String)key);
                dimTypeDimIdDimSetMap.computeIfAbsent(key, k -> new HashMap(8)).putAll(dimIdDimSetMap);
                Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
                if (null == dimTypeMap || dimTypeMap.isEmpty()) continue;
                String dimTypeName = (String)dimTypeMap.get("fname");
                dimTypeNameMap.put(key, dimTypeName);
            }
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    Dim dim;
                    Set dims;
                    Boolean includeSub = x.getIncludeSub();
                    String dimTypeSmall = x.getDimTypeSmall();
                    Long dimId = x.getDimId();
                    String dimTypeDesc = (String)dimTypeNameMap.get(dimTypeSmall);
                    LogDimRange one = new LogDimRange();
                    Map dimIdDimSetMap = (Map)dimTypeDimIdDimSetMap.get(dimTypeSmall);
                    if (null != dimIdDimSetMap && !dimIdDimSetMap.isEmpty() && null != (dims = (Set)dimIdDimSetMap.get(String.valueOf(dimId))) && !dims.isEmpty() && null != (dim = (Dim)dims.stream().findFirst().orElse(null))) {
                        one.setDimNumber(dim.getDimNumber());
                        one.setDimName(dim.getDimName());
                    }
                    one.setDimId(dimId);
                    one.setIncludesuborg(includeSub != false ? "1" : "0");
                    one.setIncludesuborgDesc(includeSub != false ? includeDesc : notIncludeDesc);
                    one.setDimType(dimTypeSmall);
                    one.setDimTypeDesc(dimTypeDesc);
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + dimTypeDesc);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    Dim dim;
                    Set dims;
                    Boolean includeSub = x.getIncludeSub();
                    String dimTypeSmall = x.getDimTypeSmall();
                    Long dimId = x.getDimId();
                    String dimTypeDesc = (String)dimTypeNameMap.get(dimTypeSmall);
                    LogDimRange one = new LogDimRange();
                    Map dimIdDimSetMap = (Map)dimTypeDimIdDimSetMap.get(dimTypeSmall);
                    if (null != dimIdDimSetMap && !dimIdDimSetMap.isEmpty() && null != (dims = (Set)dimIdDimSetMap.get(String.valueOf(dimId))) && !dims.isEmpty() && null != (dim = (Dim)dims.stream().findFirst().orElse(null))) {
                        one.setDimNumber(dim.getDimNumber());
                        one.setDimName(dim.getDimName());
                    }
                    one.setDimId(dimId);
                    one.setIncludesuborg(includeSub != false ? "1" : "0");
                    one.setIncludesuborgDesc(includeSub != false ? includeDesc : notIncludeDesc);
                    one.setDimType(dimTypeSmall);
                    one.setDimTypeDesc(dimTypeDesc);
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + dimTypeDesc);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    Dim dim;
                    Set dims;
                    Boolean includeSub = x.getIncludeSub();
                    String dimTypeSmall = x.getDimTypeSmall();
                    Long dimId = x.getDimId();
                    String dimTypeDesc = (String)dimTypeNameMap.get(dimTypeSmall);
                    LogDimRange one = new LogDimRange();
                    Map dimIdDimSetMap = (Map)dimTypeDimIdDimSetMap.get(dimTypeSmall);
                    if (null != dimIdDimSetMap && !dimIdDimSetMap.isEmpty() && null != (dims = (Set)dimIdDimSetMap.get(String.valueOf(dimId))) && !dims.isEmpty() && null != (dim = (Dim)dims.stream().findFirst().orElse(null))) {
                        one.setDimNumber(dim.getDimNumber());
                        one.setDimName(dim.getDimName());
                    }
                    one.setDimId(dimId);
                    one.setIncludesuborg(includeSub != false ? "1" : "0");
                    one.setIncludesuborgDesc(includeSub != false ? includeDesc : notIncludeDesc);
                    one.setDimType(dimTypeSmall);
                    one.setDimTypeDesc(dimTypeDesc);
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + dimTypeDesc);
                    all.add(one);
                });
            }
            if (null == all || all.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_dimrange");
            sb.append("(fid, fperm_logid, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc, fdimtypedesc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = all.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogDimRange one = (LogDimRange)all.get(i);
                Long dimId = one.getDimId();
                String dimNumber = StrUtil.nullAbleStr((String)one.getDimNumber());
                String dimName = StrUtil.nullAbleStr((String)one.getDimName());
                String includesuborg = StrUtil.nullAbleStr((String)one.getIncludesuborg());
                String includesuborgDesc = StrUtil.nullAbleStr((String)one.getIncludesuborgDesc());
                String dimType = StrUtil.nullAbleStr((String)one.getDimType());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                String dimTypeDesc = StrUtil.nullAbleStr((String)one.getDimTypeDesc());
                obj = new Object[]{ids[i], fid, dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc(), dimTypeDesc};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.warn("BusiRoleLogDiffHandler.saveDiffDetail_dimObj error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_comRole(Long fid, Map<String, Object> diffMap) {
        try {
            ArrayList all = new ArrayList(10);
            ObjectMapper delComRoleMapper = new ObjectMapper();
            List delList = (List)delComRoleMapper.readValue(delComRoleMapper.writeValueAsString(diffMap.get("delComRole")), delComRoleMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleComRole.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addComRoleMapper = new ObjectMapper();
            List addList = (List)addComRoleMapper.readValue(addComRoleMapper.writeValueAsString(diffMap.get("addComRole")), addComRoleMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleComRole.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateComRoleMapper = new ObjectMapper();
            List updateList = (List)updateComRoleMapper.readValue(updateComRoleMapper.writeValueAsString(diffMap.get("updateComRole")), updateComRoleMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BusiRoleComRole.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getCommonRole();
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                delList.stream().forEach(x -> {
                    LogCommonRole one = new LogCommonRole();
                    one.setRoleId(x.getComRoleId());
                    one.setRoleNumber(x.getComRoleNumber());
                    one.setRoleName(x.getComRoleName());
                    String comRoleEnable = x.getComRoleEnable();
                    one.setEnableDesc(StringUtils.isEmpty((String)comRoleEnable) || Objects.equals("0", comRoleEnable) ? EnumsEnable.DISABLE.getDesc() : EnumsEnable.ENABLE.getDesc());
                    one.setEnable(comRoleEnable);
                    one.setDataChangeType(delDCTEnum);
                    one.setDataChangeTypeDesc(delDescConst);
                    one.setOpDesc(delDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                addList.stream().forEach(x -> {
                    LogCommonRole one = new LogCommonRole();
                    one.setRoleId(x.getComRoleId());
                    one.setRoleNumber(x.getComRoleNumber());
                    one.setRoleName(x.getComRoleName());
                    String comRoleEnable = x.getComRoleEnable();
                    one.setEnableDesc(StringUtils.isEmpty((String)comRoleEnable) || Objects.equals("0", comRoleEnable) ? EnumsEnable.DISABLE.getDesc() : EnumsEnable.ENABLE.getDesc());
                    one.setEnable(comRoleEnable);
                    one.setDataChangeType(addDCTEnum);
                    one.setDataChangeTypeDesc(addDescConst);
                    one.setOpDesc(addDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                updateList.stream().forEach(x -> {
                    LogCommonRole one = new LogCommonRole();
                    one.setRoleId(x.getComRoleId());
                    one.setRoleNumber(x.getComRoleNumber());
                    one.setRoleName(x.getComRoleName());
                    String comRoleEnable = x.getComRoleEnable();
                    one.setEnableDesc(StringUtils.isEmpty((String)comRoleEnable) || Objects.equals("0", comRoleEnable) ? EnumsEnable.DISABLE.getDesc() : EnumsEnable.ENABLE.getDesc());
                    one.setEnable(comRoleEnable);
                    one.setDataChangeType(updateDCTEnum);
                    one.setDataChangeTypeDesc(updateDescConst);
                    one.setOpDesc(updateDescConst + opDesc_);
                    all.add(one);
                });
            }
            if (null == all || all.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_commrole");
            sb.append("(fid, fperm_logid, frole_number, frole_name, fenable, fop_enable_desc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = all.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogCommonRole one = (LogCommonRole)all.get(i);
                String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
                String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
                String enable = StrUtil.nullAbleStr((String)one.getEnable());
                String enableDesc = StrUtil.nullAbleStr((String)one.getEnableDesc());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, roleNumber, roleName, enable, enableDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("BusiRoleLogDiffHandler.saveDiffDetail_comRole error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_baseInfo(Long fid, BusiRole baseInfoDB_pre, BusiRole baseInfoDB_after) {
        return !Objects.equals(baseInfoDB_pre, baseInfoDB_after);
    }
}

