/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.BizRoleUg;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;

public class BusiRoleUgLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(BusiRoleUgLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BizRoleUg.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{BizRoleUg.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            HashSet<Long> ugIdSet = new HashSet<Long>(8);
            HashSet<Long> busiRoleIdSet = new HashSet<Long>(8);
            for (BizRoleUg bizRoleUser : delList) {
                ugIdSet.add(bizRoleUser.getUsrGrpId());
                busiRoleIdSet.add(bizRoleUser.getBusiRoleId());
            }
            for (BizRoleUg bizRoleUser : addList) {
                ugIdSet.add(bizRoleUser.getUsrGrpId());
                busiRoleIdSet.add(bizRoleUser.getBusiRoleId());
            }
            Map usrGrpInfoMap = UserGroupHelper.getUsrGrpInfoMapByIds(ugIdSet);
            Map roleMap = PermBusiRoleHelper.getRoleMap(new ArrayList(busiRoleIdSet), (String)langStr);
            this.saveDiffDetail(fid, delList, addList, usrGrpInfoMap, roleMap);
            Set changeUserIds = UserGroupHelper.getUserListBySet(ugIdSet);
            this.saveInfluenceUser(fid, UserHelper.getUserListBySet((Set)changeUserIds, (String)langStr));
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_usrgrpbusirole", uncompress, fid);
        }
        catch (Exception e) {
            log.error("BusiRoleUgLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<BizRoleUg> delList, List<BizRoleUg> addList, Map<Long, UsrGrpUser> usrGrpInfoMap, Map<Long, Map<String, Object>> roleMap) {
        try {
            EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
            String descConst = ConstantsHelper.getUserGroupBusiRoleRelate();
            String delDesc = ConstantsHelper.getDel();
            String delOpDesc = delDesc + descConst;
            String addDesc = ConstantsHelper.getAdd();
            String addOpDesc = addDesc + descConst;
            List del = delList.stream().map(bru -> this.full((BizRoleUg)bru, usrGrpInfoMap, roleMap, delEnum, delDesc, delOpDesc)).collect(Collectors.toList());
            List add = addList.stream().map(bru -> this.full((BizRoleUg)bru, usrGrpInfoMap, roleMap, addEnum, addDesc, addOpDesc)).collect(Collectors.toList());
            del.addAll(add);
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_ugbizrole");
            sb.append("(fid, fperm_logid, fusrgrp_id, fusrgrp_name, fusrgrp_number, fusrgrpstdid, fusrgrpstd_desc, fbusirole_id, fbusirole_number, fbusirole_name, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                BizRoleUg one = (BizRoleUg)del.get(i);
                obj = new Object[]{ids[i], fid, one.getUsrGrpId(), StrUtil.nullAbleStr((String)one.getUsrGrpName()), StrUtil.nullAbleStr((String)one.getUsrGrpNumber()), one.getUsrGrpStdId(), StrUtil.nullAbleStr((String)one.getUsrGrpStdDesc()), one.getBusiRoleId(), StrUtil.nullAbleStr((String)one.getBusiRoleNumber()), StrUtil.nullAbleStr((String)one.getBusiRoleName()), one.getStartTime(), one.getEndTime(), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
        }
        catch (Exception e) {
            log.error("BusiRoleUgLogDiffHandler.saveDiffDetail error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private BizRoleUg full(BizRoleUg bru, Map<Long, UsrGrpUser> usrGrpInfoMap, Map<Long, Map<String, Object>> roleMap, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc) {
        Map<String, Object> roleInfoMap;
        Long ugId = bru.getUsrGrpId();
        UsrGrpUser usrGrpUser = usrGrpInfoMap.get(ugId);
        if (null != usrGrpUser) {
            bru.setUsrGrpName(usrGrpUser.getUsrGrpName());
            bru.setUsrGrpNumber(usrGrpUser.getUsrGrpNumber());
            bru.setUsrGrpStdId(usrGrpUser.getUsrGrpStdId());
            bru.setUsrGrpStdDesc(usrGrpUser.getUsrGrpStdDesc());
        }
        if (null != (roleInfoMap = roleMap.get(bru.getBusiRoleId())) && !roleInfoMap.isEmpty()) {
            bru.setBusiRoleName((String)roleInfoMap.get("fname"));
            bru.setBusiRoleNumber((String)roleInfoMap.get("fnumber"));
        }
        bru.setDataChangeType(dataChangeType);
        bru.setDataChangeTypeDesc(dataChangeTypeDesc);
        bru.setOpDesc(opDesc);
        return bru;
    }
}

