/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogDimUser;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.util.StringUtils;

public class CommonRoleAssignOrgUserLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(CommonRoleAssignOrgUserLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateObjMapper = new ObjectMapper();
            List updateList = (List)updateObjMapper.readValue(updateObjMapper.writeValueAsString(diffMap.get("update")), updateObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            Set<Long> delUserIdSet = delList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            Set addUserIdSet = addList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            Set updateUserIdSet = updateList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            delUserIdSet.addAll(addUserIdSet);
            delUserIdSet.addAll(updateUserIdSet);
            this.saveDiffDetail(fid, delList, addList, updateList, delUserIdSet, langStr);
            List userList = UserHelper.getUserListBySet(delUserIdSet, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_userrole_multype", uncompress, fid);
        }
        catch (Exception e) {
            log.error("CommonRoleAssignOrgUserLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<PermUserRole> delList, List<PermUserRole> addList, List<PermUserRole> updateList, Set<Long> changedUserIdSet, String langStr) {
        HashMap<String, Set> dimTypeDimIdMap = new HashMap<String, Set>(8);
        for (PermUserRole pur2 : delList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        for (PermUserRole pur2 : addList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        for (PermUserRole pur2 : updateList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        if (null == dimTypeDimIdMap || dimTypeDimIdMap.isEmpty()) {
            return;
        }
        ArrayList<LogDimUser> list = new ArrayList<LogDimUser>(10);
        Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)langStr);
        Map userInfoMap = UserHelper.getUserInfoMapByIds(changedUserIdSet, (String)langStr);
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String delDesc = ConstantsHelper.getDel();
        String addDesc = ConstantsHelper.getAdd();
        String updateDesc = ConstantsHelper.getUpdate();
        String includeDesc = ConstantsHelper.getInclude();
        String notIncludeDesc = ConstantsHelper.getNotInclude();
        for (Map.Entry dimTypeDimId : dimTypeDimIdMap.entrySet()) {
            String key = (String)dimTypeDimId.getKey();
            Set value = (Set)dimTypeDimId.getValue();
            if (null == value || value.isEmpty()) continue;
            Map dimMap = IsoDimHelper.getDimMap(new LinkedList(value), (String)key);
            Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
            String dimTypeName = (String)dimTypeMap.get("fname");
            String orgUserDesc = ConstantsHelper.getOrgUser((String)dimTypeName);
            String delOpDesc = delDesc + orgUserDesc;
            String addOpDesc = addDesc + orgUserDesc;
            String updateOpDesc = updateDesc + orgUserDesc;
            List del = delList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, (PermUserRole)pur, delEnum, delDesc, delOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List add = addList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, (PermUserRole)pur, addEnum, addDesc, addOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List update = updateList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, (PermUserRole)pur, updateEnum, updateDesc, updateOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            list.addAll(del);
            list.addAll(add);
            list.addAll(update);
        }
        LogDimUser.save2DB(list, fid);
    }

    private LogDimUser pur2ldu(Map<Long, Dim> dimMap, Map<Long, User> userInfoMap, PermUserRole pur, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc, String dimTypeName, String includeDesc, String notIncludeDesc) {
        LogDimUser ldu = new LogDimUser();
        Long fuserid = pur.getFuserid();
        ldu.setUserId(fuserid);
        User user = userInfoMap.get(fuserid);
        if (null != user) {
            ldu.setTrueName(user.getFtruename());
            ldu.setUserNumber(user.getFnumber());
            ldu.setUserName(user.getFusername());
            ldu.setPhone(user.getFphone());
            ldu.setEmail(user.getFemail());
        }
        Long dimId = pur.getForgid();
        ldu.setDimId(dimId);
        Dim dim = dimMap.get(dimId);
        if (null != dim) {
            ldu.setDimNumber(dim.getDimNumber());
            ldu.setDimName(dim.getDimName());
        }
        String fisincludesuborg = pur.getFisincludesuborg();
        ldu.setIncludesuborg(fisincludesuborg);
        String fisincludesuborgDesc = StringUtils.isEmpty((String)fisincludesuborg) ? "" : ("1".equals(fisincludesuborg) ? includeDesc : notIncludeDesc);
        ldu.setIncludesuborgDesc(fisincludesuborgDesc);
        ldu.setDimType(pur.getFdimtype());
        ldu.setDimTypeDesc(dimTypeName);
        ldu.setStarTime(pur.getFstarttime());
        ldu.setEndTime(pur.getFendtime());
        ldu.setDataChangeType(dataChangeType);
        ldu.setDataChangeTypeDesc(dataChangeTypeDesc);
        ldu.setOpDesc(opDesc);
        return ldu;
    }
}

