/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.permbase.PermItem;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogFuncPerm;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;

public class CommonRoleBatchAssignPermLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(CommonRoleBatchAssignPermLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermItem.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermItem.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            HashMap<String, String> selectField = new HashMap<String, String>(8);
            selectField.put("itemId", "fop_item_id");
            Map<String, String> results = PermLogService.selectSingleFromPermLog(selectField, fid);
            if (null == results || results.isEmpty()) {
                return;
            }
            String opItemId = results.get("itemId");
            Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(Collections.singleton(opItemId));
            Set userIds = (Set)roleUserIdSetMap.get(opItemId);
            this.saveDiffDetail(fid, delList, addList);
            List userList = UserHelper.getUserListBySet((Set)userIds, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_role", uncompress, fid);
        }
        catch (Exception e) {
            log.error("CommonRoleBatchAssignPermLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<PermItem> delList, List<PermItem> addList) {
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String constDesc = ConstantsHelper.getFuncPerm();
        String delDesc = ConstantsHelper.getDel();
        String delOpDesc = delDesc + constDesc;
        String addDesc = ConstantsHelper.getAdd();
        String addOpDesc = addDesc + constDesc;
        List<LogFuncPerm> del = delList.stream().map(permItem -> this.permItem2LogFuncPerm((PermItem)permItem, delEnum, delDesc, delOpDesc)).collect(Collectors.toList());
        List add = addList.stream().map(permItem -> this.permItem2LogFuncPerm((PermItem)permItem, addEnum, addDesc, addOpDesc)).collect(Collectors.toList());
        del.addAll(add);
        LogFuncPerm.save2DB(del, fid);
    }

    private LogFuncPerm permItem2LogFuncPerm(PermItem permItem, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc) {
        LogFuncPerm logFuncPerm = new LogFuncPerm();
        logFuncPerm.setPermItemId(permItem.getPermItemId());
        logFuncPerm.setPermItemName(permItem.getPermItemName());
        logFuncPerm.setEntityId(permItem.getEntityId());
        logFuncPerm.setEntityName(permItem.getEntityName());
        logFuncPerm.setCloudId(permItem.getCloudId());
        logFuncPerm.setCloudName(permItem.getCloudName());
        logFuncPerm.setAppId(permItem.getAppId());
        logFuncPerm.setAppName(permItem.getAppName());
        logFuncPerm.setDataChangeType(dataChangeType);
        logFuncPerm.setDataChangeTypeDesc(dataChangeTypeDesc);
        logFuncPerm.setOpDesc(opDesc);
        return logFuncPerm;
    }
}

