/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.FieldPermSchemeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogFieldPerm;
import kd.bos.permission.log.model.LogFuncPerm;
import kd.bos.permission.log.model.LogNewDataRule;
import kd.bos.permission.log.model.LogNewDataRuleProp;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class CommonRoleLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(CommonRoleLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            boolean existsDiff = this.saveDiffDetail(fid, diffMap);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper influenUserIdSetMapper = new ObjectMapper();
            List influenUserIdSet = (List)influenUserIdSetMapper.readValue(influenUserIdSetMapper.writeValueAsString(diffMap.get("influenUserIdSet")), influenUserIdSetMapper.getTypeFactory().constructParametricType(List.class, new Class[]{String.class}));
            Set influenUser = null == influenUserIdSet || influenUserIdSet.isEmpty() ? Collections.EMPTY_SET : influenUserIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            List userList = UserHelper.getUserListBySet((Set)influenUser, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_role", uncompress, fid);
        }
        catch (Exception e) {
            log.warn("CommonRoleAssignOrgUserLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private boolean saveDiffDetail(Long fid, Map<String, Object> diffMap) {
        try {
            HashMap<String, String> selectField = new HashMap<String, String>(8);
            selectField.put("fbusi_type", "fbusi_type");
            Map<String, String> results = PermLogService.selectSingleFromPermLog(selectField, fid);
            if (null == results || results.isEmpty()) {
                return false;
            }
            String langStr = (String)diffMap.get("langStr");
            Map appIdNameMap = AppHelper.getAllAppIdNameMap();
            Map entityNameMap = FormHelper.getEntityNameMap(null, (String)langStr);
            Map cloudMap = AppHelper.getCloudMap(null);
            Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
            ObjectMapper baseInfoDB_preMapper = new ObjectMapper();
            ComRole baseInfoDB_pre = (ComRole)baseInfoDB_preMapper.readValue(baseInfoDB_preMapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), ComRole.class);
            ObjectMapper baseInfoDB_afterMapper = new ObjectMapper();
            ComRole baseInfoDB_after = (ComRole)baseInfoDB_afterMapper.readValue(baseInfoDB_afterMapper.writeValueAsString(diffMap.get("baseInfoDB_after")), ComRole.class);
            boolean baseInfoDiff = this.saveDiffDetail_baseInfo(fid, baseInfoDB_pre, baseInfoDB_after);
            boolean funcPermDiff = this.saveDiffDetail_funcPerm(fid, diffMap, cloudMap, appIdNameMap, entityNameMap, allPermitemMap);
            ObjectMapper delFieldPermMapper = new ObjectMapper();
            List delFieldPerm = (List)delFieldPermMapper.readValue(delFieldPermMapper.writeValueAsString(diffMap.get("delFieldPerm")), delFieldPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{FieldPerm.class}));
            delFieldPerm = null == delFieldPerm ? new ArrayList(0) : delFieldPerm;
            ObjectMapper addFieldPermMapper = new ObjectMapper();
            List addFieldPerm = (List)addFieldPermMapper.readValue(addFieldPermMapper.writeValueAsString(diffMap.get("addFieldPerm")), addFieldPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{FieldPerm.class}));
            addFieldPerm = null == addFieldPerm ? new ArrayList(0) : addFieldPerm;
            HashMap<String, Map<String, Object>> hasLoadMap = new HashMap<String, Map<String, Object>>(8);
            boolean fieldPermDiff = this.saveDiffDetail_fieldPerm(fid, delFieldPerm, addFieldPerm, cloudMap, appIdNameMap, entityNameMap, allPermitemMap, hasLoadMap);
            ObjectMapper delFpsMapper = new ObjectMapper();
            List delFps = (List)delFpsMapper.readValue(delFpsMapper.writeValueAsString(diffMap.get("delFpsPerm")), delFpsMapper.getTypeFactory().constructParametricType(List.class, new Class[]{FieldPermScheme.class}));
            delFps = null == delFps ? new ArrayList(0) : delFps;
            ObjectMapper addFpsMapper = new ObjectMapper();
            List addFps = (List)addFpsMapper.readValue(addFpsMapper.writeValueAsString(diffMap.get("addFpsPerm")), addFpsMapper.getTypeFactory().constructParametricType(List.class, new Class[]{FieldPermScheme.class}));
            addFps = null == addFps ? new ArrayList(0) : addFps;
            boolean fpsDiff = this.saveDiffDetail_fps(fid, delFps, addFps, cloudMap, appIdNameMap, entityNameMap);
            ObjectMapper delNewDrPermMapper = new ObjectMapper();
            List delNewDrPerm = (List)delNewDrPermMapper.readValue(delNewDrPermMapper.writeValueAsString(diffMap.get("delNewDrPerm")), delNewDrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPerm.class}));
            delNewDrPerm = null == delNewDrPerm ? new ArrayList(0) : delNewDrPerm;
            ObjectMapper addNewDrPermMapper = new ObjectMapper();
            List addNewDrPerm = (List)addNewDrPermMapper.readValue(addNewDrPermMapper.writeValueAsString(diffMap.get("addNewDrPerm")), addNewDrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPerm.class}));
            addNewDrPerm = null == addNewDrPerm ? new ArrayList(0) : addNewDrPerm;
            ObjectMapper updateNewDrPermMapper = new ObjectMapper();
            List updateNewDrPerm = (List)updateNewDrPermMapper.readValue(updateNewDrPermMapper.writeValueAsString(diffMap.get("updateNewDrPerm")), updateNewDrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPerm.class}));
            updateNewDrPerm = null == updateNewDrPerm ? new ArrayList(0) : updateNewDrPerm;
            ObjectMapper delNewDrPrPermMapper = new ObjectMapper();
            List delNewDrPrPerm = (List)delNewDrPrPermMapper.readValue(delNewDrPrPermMapper.writeValueAsString(diffMap.get("delNewDrPrPerm")), delNewDrPrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPrPerm.class}));
            delNewDrPrPerm = null == delNewDrPrPerm ? new ArrayList(0) : delNewDrPrPerm;
            ObjectMapper addNewDrPrPermMapper = new ObjectMapper();
            List addNewDrPrPerm = (List)addNewDrPrPermMapper.readValue(addNewDrPrPermMapper.writeValueAsString(diffMap.get("addNewDrPrPerm")), addNewDrPrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPrPerm.class}));
            addNewDrPrPerm = null == addNewDrPrPerm ? new ArrayList(0) : addNewDrPrPerm;
            ObjectMapper updateNewDrPrPermMapper = new ObjectMapper();
            List updateNewDrPrPerm = (List)updateNewDrPrPermMapper.readValue(updateNewDrPrPermMapper.writeValueAsString(diffMap.get("updateNewDrPrPerm")), updateNewDrPrPermMapper.getTypeFactory().constructParametricType(List.class, new Class[]{NewDrPrPerm.class}));
            updateNewDrPrPerm = null == updateNewDrPrPerm ? new ArrayList(0) : updateNewDrPrPerm;
            HashSet<Long> drIdSet = new HashSet<Long>(8);
            for (NewDrPerm newDrPerm : delNewDrPerm) {
                drIdSet.add(newDrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPerm.getDataRuleName()));
            }
            for (NewDrPerm newDrPerm : addNewDrPerm) {
                drIdSet.add(newDrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPerm.getDataRuleName()));
            }
            for (NewDrPerm newDrPerm : updateNewDrPerm) {
                drIdSet.add(newDrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPerm.getDataRuleName()));
            }
            for (NewDrPrPerm newDrPrPerm : delNewDrPrPerm) {
                drIdSet.add(newDrPrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPrPerm.getDataRuleName()));
            }
            for (NewDrPrPerm newDrPrPerm : addNewDrPrPerm) {
                drIdSet.add(newDrPrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPrPerm.getDataRuleName()));
            }
            for (NewDrPrPerm newDrPrPerm : updateNewDrPrPerm) {
                drIdSet.add(newDrPrPerm.getDataRuleId());
                drIdSet.add(Long.valueOf(newDrPrPerm.getDataRuleName()));
            }
            Map dataRuleMap = DrHelper.getDataRuleMap(new ArrayList(drIdSet));
            boolean drDiff = this.saveDiffDetail_DR(fid, delNewDrPerm, addNewDrPerm, updateNewDrPerm, cloudMap, appIdNameMap, entityNameMap, allPermitemMap, dataRuleMap);
            boolean drprDiff = this.saveDiffDetail_DRProp(fid, delNewDrPrPerm, addNewDrPrPerm, updateNewDrPrPerm, cloudMap, appIdNameMap, entityNameMap, allPermitemMap, dataRuleMap, hasLoadMap);
            ObjectMapper delComRoleAdminGrpMapper = new ObjectMapper();
            List delComRoleAdminGrp = (List)delComRoleAdminGrpMapper.readValue(delComRoleAdminGrpMapper.writeValueAsString(diffMap.get("delComRoleAdminGrp")), delComRoleAdminGrpMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleAdminGrp.class}));
            delComRoleAdminGrp = null == delComRoleAdminGrp ? new ArrayList(0) : delComRoleAdminGrp;
            ObjectMapper addComRoleAdminGrpMapper = new ObjectMapper();
            List addComRoleAdminGrp = (List)addComRoleAdminGrpMapper.readValue(addComRoleAdminGrpMapper.writeValueAsString(diffMap.get("addComRoleAdminGrp")), addComRoleAdminGrpMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleAdminGrp.class}));
            addComRoleAdminGrp = null == addComRoleAdminGrp ? new ArrayList(0) : addComRoleAdminGrp;
            ObjectMapper updateComRoleAdminGrpMapper = new ObjectMapper();
            List updateComRoleAdminGrp = (List)updateComRoleAdminGrpMapper.readValue(updateComRoleAdminGrpMapper.writeValueAsString(diffMap.get("updateComRoleAdminGrp")), updateComRoleAdminGrpMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleAdminGrp.class}));
            updateComRoleAdminGrp = null == updateComRoleAdminGrp ? new ArrayList(0) : updateComRoleAdminGrp;
            HashSet<String> roleIdSet = new HashSet<String>(8);
            HashSet<String> admGrpIdSet = new HashSet<String>(8);
            if (CollectionUtils.isNotEmpty((Collection)updateComRoleAdminGrp)) {
                for (ComRoleAdminGrp adminGrp : delComRoleAdminGrp) {
                    roleIdSet.add(adminGrp.getRoleId());
                    admGrpIdSet.add(adminGrp.getAdminGroupId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateComRoleAdminGrp)) {
                for (ComRoleAdminGrp adminGrp : addComRoleAdminGrp) {
                    roleIdSet.add(adminGrp.getRoleId());
                    admGrpIdSet.add(adminGrp.getAdminGroupId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateComRoleAdminGrp)) {
                for (ComRoleAdminGrp adminGrp : updateComRoleAdminGrp) {
                    roleIdSet.add(adminGrp.getRoleId());
                    admGrpIdSet.add(adminGrp.getAdminGroupId());
                }
            }
            Map comRoleBaseMap = PermRoleHelper.getComRoleBaseMap(roleIdSet, null);
            Set collect = admGrpIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            Map admGroupInfoMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
            boolean admGrpDiff = this.saveDiffDetail_admGrp(fid, delComRoleAdminGrp, addComRoleAdminGrp, updateComRoleAdminGrp, comRoleBaseMap, admGroupInfoMap);
            return baseInfoDiff || funcPermDiff || fieldPermDiff || fpsDiff || drDiff || drprDiff || admGrpDiff;
        }
        catch (Exception ex) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_baseInfo(Long fid, ComRole baseInfoDB_pre, ComRole baseInfoDB_after) {
        return !Objects.equals(baseInfoDB_pre, baseInfoDB_after);
    }

    private boolean saveDiffDetail_admGrp(Long fid, List<ComRoleAdminGrp> delComRoleAdminGrp, List<ComRoleAdminGrp> addComRoleAdminGrp, List<ComRoleAdminGrp> updateComRoleAdminGrp, Map<String, ComRole> comRoleBaseMap, Map<Long, AdmGroup> admGroupInfoMap) {
        try {
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String useScopeRangeDesc = ConstantsHelper.getUseScopeRange();
            String yesDesc = ConstantsHelper.getYesDesc();
            String noDesc = ConstantsHelper.getNoDesc();
            List del = delComRoleAdminGrp.stream().map(x -> this.fullComRoleAdminGrp(comRoleBaseMap, admGroupInfoMap, delDescConst, useScopeRangeDesc, delDCTEnum, yesDesc, noDesc, (ComRoleAdminGrp)x)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(addComRoleAdminGrp)) {
                List add = addComRoleAdminGrp.stream().map(x -> this.fullComRoleAdminGrp(comRoleBaseMap, admGroupInfoMap, addDescConst, useScopeRangeDesc, addDCTEnum, yesDesc, noDesc, (ComRoleAdminGrp)x)).collect(Collectors.toList());
                del.addAll(add);
            }
            if (CollectionUtils.isNotEmpty(updateComRoleAdminGrp)) {
                List update = updateComRoleAdminGrp.stream().map(x -> this.fullComRoleAdminGrp(comRoleBaseMap, admGroupInfoMap, updateDescConst, useScopeRangeDesc, updateDCTEnum, yesDesc, noDesc, (ComRoleAdminGrp)x)).collect(Collectors.toList());
                del.addAll(update);
            }
            if (null == del || del.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_roleadmgr");
            sb.append("(fid, fperm_logid, frole_id, frole_number, frole_name, fadmingroup_id, fadmingroup_num, fadmingroup_name, fmodifiable, fmodifiable_desc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                ComRoleAdminGrp one = (ComRoleAdminGrp)del.get(i);
                String roleId = StrUtil.nullAbleStr((String)one.getRoleId());
                String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
                String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
                String adminGroupId = StrUtil.nullAbleStr((String)one.getAdminGroupId());
                String adminGroupName = StrUtil.nullAbleStr((String)one.getAdminGroupName());
                String adminGroupNumber = StrUtil.nullAbleStr((String)one.getAdminGroupNumber());
                boolean modifiable = one.isModifiable();
                String modifiableDesc = StrUtil.nullAbleStr((String)one.getModifiableDesc());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, roleId, roleNumber, roleName, StringUtils.isEmpty((String)adminGroupId) ? 0L : Long.parseLong(adminGroupId), adminGroupNumber, adminGroupName, modifiable, modifiableDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_admGrp error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_DRProp(Long fid, List<NewDrPrPerm> delList, List<NewDrPrPerm> addList, List<NewDrPrPerm> updateList, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap, Map<Long, Map<String, Object>> dataRuleMap, Map<String, Map<String, Object>> hasLoadMap) {
        try {
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String dataRuleDesc = ConstantsHelper.getDataRule();
            List del = delList.stream().map(x -> CommonRoleLogDiffHandler.newDrPrPerm2Prop(cloudMap, appIdNameMap, entityNameMap, dataRuleMap, hasLoadMap, delDescConst, dataRuleDesc, delDCTEnum, x)).collect(Collectors.toList());
            List add = addList.stream().map(x -> CommonRoleLogDiffHandler.newDrPrPerm2Prop(cloudMap, appIdNameMap, entityNameMap, dataRuleMap, hasLoadMap, addDescConst, dataRuleDesc, addDCTEnum, x)).collect(Collectors.toList());
            List update = updateList.stream().map(x -> CommonRoleLogDiffHandler.newDrPrPerm2Prop(cloudMap, appIdNameMap, entityNameMap, dataRuleMap, hasLoadMap, updateDescConst, dataRuleDesc, updateDCTEnum, x)).collect(Collectors.toList());
            del.addAll(add);
            del.addAll(update);
            if (null == del || del.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_newdrprop");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fprop_key, fprop_name, fprop_entnum, fprop_entname, fpre_data_ruleid, fpre_data_rulename, fafter_data_ruleid, fafter_data_rulename, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogNewDataRuleProp one = (LogNewDataRuleProp)del.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String propKey = StrUtil.nullAbleStr((String)one.getPropKey());
                String propName = StrUtil.nullAbleStr((String)one.getPropName());
                String propEntNum = StrUtil.nullAbleStr((String)one.getPropEntNum());
                String propEntName = StrUtil.nullAbleStr((String)one.getPropEntName());
                String preDataRuleName = StrUtil.nullAbleStr((String)one.getPreDataRuleName());
                String afterDataRuleName = StrUtil.nullAbleStr((String)one.getAfterDataRuleName());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, propKey, propName, propEntNum, propEntName, one.getPreDataRuleId(), preDataRuleName, one.getAfterDataRuleId(), afterDataRuleName, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_DRProp error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private ComRoleAdminGrp fullComRoleAdminGrp(Map<String, ComRole> comRoleBaseMap, Map<Long, AdmGroup> admGroupInfoMap, String descConst, String useScopeRangeDesc, EnumsDataChangeType DCTEnum, String yesDesc, String noDesc, ComRoleAdminGrp one) {
        boolean modifiable;
        String adminGroupId;
        AdmGroup admGroup;
        String roleName = "";
        String roleNumber = "";
        String adminGroupName = "";
        String adminGroupNumber = "";
        String modifiableDesc = "";
        String roleId = StrUtil.nullAbleStr((String)one.getRoleId());
        ComRole comRole = comRoleBaseMap.get(roleId);
        if (null != comRole) {
            roleName = comRole.getName();
            roleNumber = comRole.getNumber();
        }
        if (null != (admGroup = admGroupInfoMap.get(Long.valueOf(adminGroupId = StrUtil.nullAbleStr((String)one.getAdminGroupId()))))) {
            adminGroupName = admGroup.getName();
            adminGroupNumber = admGroup.getNumber();
        }
        modifiableDesc = (modifiable = one.isModifiable()) ? yesDesc : noDesc;
        one.setRoleName(roleName);
        one.setRoleNumber(roleNumber);
        one.setAdminGroupName(adminGroupName);
        one.setAdminGroupNumber(adminGroupNumber);
        one.setModifiableDesc(modifiableDesc);
        one.setDataChangeType(DCTEnum);
        one.setDataChangeTypeDesc(descConst);
        one.setOpDesc(descConst + useScopeRangeDesc);
        return one;
    }

    private static LogNewDataRuleProp newDrPrPerm2Prop(Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<Long, Map<String, Object>> dataRuleMap, Map<String, Map<String, Object>> hasLoadMap, String descConst, String dataRuleDesc, EnumsDataChangeType DCTEnum, NewDrPrPerm x) {
        LogNewDataRuleProp lfp = new LogNewDataRuleProp();
        String appId = x.getAppId();
        String entityNumber = x.getEntityNumber();
        String propKey = x.getPropKey();
        String propEntNum = x.getPropEntNum();
        Long afterDataRuleId = x.getDataRuleId();
        String preDataRuleId = x.getDataRuleName();
        lfp.setCloudId(x.getCloudId());
        DynamicObject cloud = cloudMap.get(appId);
        if (null != cloud) {
            lfp.setCloudId(cloud.getString("bizcloud.id"));
            lfp.setCloudName(cloud.getString("bizcloud.name"));
        }
        lfp.setAppId(appId);
        lfp.setAppName(appIdNameMap.get(appId));
        lfp.setEntityId(entityNumber);
        lfp.setEntityName(entityNameMap.get(entityNumber));
        lfp.setPropKey(propKey);
        String propName = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, (String)entityNumber, (String)propKey);
        lfp.setPropName(propName);
        lfp.setPropEntNum(propEntNum);
        lfp.setPropEntName(entityNameMap.get(propEntNum));
        Long preDataRuleIdL = Long.valueOf(preDataRuleId);
        lfp.setPreDataRuleId(preDataRuleIdL);
        Map<String, Object> preDataRuleMap = dataRuleMap.get(preDataRuleIdL);
        String preDataRuleName = null == preDataRuleMap || preDataRuleMap.isEmpty() ? "" : (String)preDataRuleMap.get("fname");
        lfp.setPreDataRuleName(preDataRuleName);
        lfp.setAfterDataRuleId(afterDataRuleId);
        Map<String, Object> afterDataRuleMap = dataRuleMap.get(afterDataRuleId);
        String afterDataRuleName = null == afterDataRuleMap || afterDataRuleMap.isEmpty() ? "" : (String)afterDataRuleMap.get("fname");
        lfp.setAfterDataRuleName(afterDataRuleName);
        lfp.setDataChangeType(DCTEnum);
        lfp.setDataChangeTypeDesc(descConst);
        lfp.setOpDesc(descConst + dataRuleDesc);
        return lfp;
    }

    private boolean saveDiffDetail_DR(Long fid, List<NewDrPerm> delList, List<NewDrPerm> addList, List<NewDrPerm> updateList, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap, Map<Long, Map<String, Object>> dataRuleMap) {
        try {
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String dataRuleDesc = ConstantsHelper.getDataRule();
            List del = delList.stream().map(x -> CommonRoleLogDiffHandler.newDrPerm2DR(cloudMap, appIdNameMap, entityNameMap, allPermitemMap, dataRuleMap, delDescConst, dataRuleDesc, delDCTEnum, x)).collect(Collectors.toList());
            List add = addList.stream().map(x -> CommonRoleLogDiffHandler.newDrPerm2DR(cloudMap, appIdNameMap, entityNameMap, allPermitemMap, dataRuleMap, addDescConst, dataRuleDesc, addDCTEnum, x)).collect(Collectors.toList());
            List update = updateList.stream().map(x -> CommonRoleLogDiffHandler.newDrPerm2DR(cloudMap, appIdNameMap, entityNameMap, allPermitemMap, dataRuleMap, updateDescConst, dataRuleDesc, updateDCTEnum, x)).collect(Collectors.toList());
            del.addAll(add);
            del.addAll(update);
            if (null == del || del.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_newdr");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fpre_data_ruleid, fpre_data_rulename, fafter_data_ruleid, fafter_data_rulename, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogNewDataRule one = (LogNewDataRule)del.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String permItemId = StrUtil.nullAbleStr((String)one.getPermItemId());
                String permItemName = StrUtil.nullAbleStr((String)one.getPermItemName());
                String preDataRuleName = StrUtil.nullAbleStr((String)one.getPreDataRuleName());
                String afterDataRuleName = StrUtil.nullAbleStr((String)one.getAfterDataRuleName());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, permItemId, permItemName, one.getPreDataRuleId(), preDataRuleName, one.getAfterDataRuleId(), afterDataRuleName, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), null, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_DR error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static LogNewDataRule newDrPerm2DR(Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap, Map<Long, Map<String, Object>> dataRuleMap, String delDescConst, String dataRuleDesc, EnumsDataChangeType delDCTEnum, NewDrPerm x) {
        LogNewDataRule lfp = new LogNewDataRule();
        String appId = x.getAppId();
        String entityNumber = x.getEntityNumber();
        String permItemId = x.getPermItemId();
        Long afterDataRuleId = x.getDataRuleId();
        String preDataRuleId = x.getDataRuleName();
        lfp.setCloudId(x.getCloudId());
        DynamicObject cloud = cloudMap.get(appId);
        if (null != cloud) {
            lfp.setCloudId(cloud.getString("bizcloud.id"));
            lfp.setCloudName(cloud.getString("bizcloud.name"));
        }
        lfp.setAppId(appId);
        lfp.setAppName(appIdNameMap.get(appId));
        lfp.setEntityId(entityNumber);
        lfp.setEntityName(entityNameMap.get(entityNumber));
        lfp.setPermItemId(permItemId);
        lfp.setPermItemName(allPermitemMap.get(permItemId));
        Long preDataRuleIdL = Long.valueOf(preDataRuleId);
        lfp.setPreDataRuleId(preDataRuleIdL);
        Map<String, Object> preDataRuleMap = dataRuleMap.get(preDataRuleIdL);
        String preDataRuleName = null == preDataRuleMap || preDataRuleMap.isEmpty() ? "" : (String)preDataRuleMap.get("fname");
        lfp.setPreDataRuleName(preDataRuleName);
        lfp.setAfterDataRuleId(afterDataRuleId);
        Map<String, Object> afterDataRuleMap = dataRuleMap.get(afterDataRuleId);
        String afterDataRuleName = null == afterDataRuleMap || afterDataRuleMap.isEmpty() ? "" : (String)afterDataRuleMap.get("fname");
        lfp.setAfterDataRuleName(afterDataRuleName);
        lfp.setDataChangeType(delDCTEnum);
        lfp.setDataChangeTypeDesc(delDescConst);
        lfp.setOpDesc(delDescConst + dataRuleDesc);
        return lfp;
    }

    private boolean saveDiffDetail_fieldPerm(Long fid, List<FieldPerm> delList, List<FieldPerm> addList, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap, Map<String, Map<String, Object>> hasLoadMap) {
        try {
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            String opDesc_ = ConstantsHelper.getFieldPerm();
            List del = delList.stream().map(x -> {
                LogFieldPerm lfp = new LogFieldPerm();
                String appId = x.getAppId();
                String entityNumber = x.getEntityNumber();
                String controlMode = x.getControlMode();
                String fieldName = x.getFieldName();
                lfp.setCloudId(x.getCloudId());
                DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                if (null != cloud) {
                    lfp.setCloudId(cloud.getString("bizcloud.id"));
                    lfp.setCloudName(cloud.getString("bizcloud.name"));
                }
                lfp.setAppId(appId);
                lfp.setAppName((String)appIdNameMap.get(appId));
                lfp.setEntityId(entityNumber);
                lfp.setEntityName((String)entityNameMap.get(entityNumber));
                lfp.setFieldName(fieldName);
                String filedComment = FormHelper.getEntityFieldNameMultiEnt((Map)hasLoadMap, (String)entityNumber, (String)fieldName);
                lfp.setFieldComment(filedComment);
                lfp.setControlMode(controlMode);
                lfp.setControlModeDesc(ConstantsHelper.getControlModelDesc((String)controlMode));
                lfp.setDataChangeType(delDCTEnum);
                lfp.setDataChangeTypeDesc(delDescConst);
                lfp.setOpDesc(delDescConst + opDesc_);
                return lfp;
            }).collect(Collectors.toList());
            List add = addList.stream().map(x -> {
                LogFieldPerm lfp = new LogFieldPerm();
                String appId = x.getAppId();
                String entityNumber = x.getEntityNumber();
                String controlMode = x.getControlMode();
                String fieldName = x.getFieldName();
                lfp.setCloudId(x.getCloudId());
                DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                if (null != cloud) {
                    lfp.setCloudId(cloud.getString("bizcloud.id"));
                    lfp.setCloudName(cloud.getString("bizcloud.name"));
                }
                lfp.setAppId(appId);
                lfp.setAppName((String)appIdNameMap.get(appId));
                lfp.setEntityId(entityNumber);
                lfp.setEntityName((String)entityNameMap.get(entityNumber));
                lfp.setFieldName(fieldName);
                String filedComment = FormHelper.getEntityFieldNameMultiEnt((Map)hasLoadMap, (String)entityNumber, (String)fieldName);
                lfp.setFieldComment(filedComment);
                lfp.setControlMode(controlMode);
                lfp.setControlModeDesc(ConstantsHelper.getControlModelDesc((String)controlMode));
                lfp.setDataChangeType(addDCTEnum);
                lfp.setDataChangeTypeDesc(addDescConst);
                lfp.setOpDesc(addDescConst + opDesc_);
                return lfp;
            }).collect(Collectors.toList());
            del.addAll(add);
            if (null == del || del.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_fieldperm");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, ffield_name, ffield_comment, fcontrol_mode, fcontrol_modedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogFieldPerm one = (LogFieldPerm)del.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String fieldName = StrUtil.nullAbleStr((String)one.getFieldName());
                String fieldComment = StrUtil.nullAbleStr((String)one.getFieldComment());
                String controlMode = StrUtil.nullAbleStr((String)one.getControlMode());
                String controlModeDesc = StrUtil.nullAbleStr((String)one.getControlModeDesc());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, fieldName, fieldComment, controlMode, controlModeDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), null, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_fieldPerm error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_fps(Long fid, List<FieldPermScheme> delFps, List<FieldPermScheme> addFps, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap) {
        try {
            String opDescSuffix;
            String sensitive;
            FieldPermScheme fieldPermScheme;
            DynamicObject cloud;
            String entityNumber;
            String appId;
            HashSet<Long> fpsIdSet = new HashSet<Long>(8);
            if (null != delFps && !delFps.isEmpty()) {
                for (FieldPermScheme delFp : delFps) {
                    fpsIdSet.add(delFp.getId());
                }
            }
            if (null != addFps && !addFps.isEmpty()) {
                for (FieldPermScheme addFp : addFps) {
                    fpsIdSet.add(addFp.getId());
                }
            }
            if (null == fpsIdSet || fpsIdSet.isEmpty()) {
                return false;
            }
            Map fpsMap = FieldPermSchemeHelper.getFpsMap(fpsIdSet);
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            String opDesc_ = ConstantsHelper.getFps();
            String opSeneitiveDesc_ = ConstantsHelper.getFpsSensitive();
            for (FieldPermScheme x : delFps) {
                appId = x.getAppId();
                entityNumber = x.getEntityNumber();
                cloud = cloudMap.get(appId);
                if (null != cloud) {
                    x.setCloudId(cloud.getString("bizcloud.id"));
                    x.setCloudName(cloud.getString("bizcloud.name"));
                }
                x.setAppName(appIdNameMap.get(appId));
                x.setEntityName(entityNameMap.get(entityNumber));
                fieldPermScheme = (FieldPermScheme)fpsMap.get(x.getId());
                x.setName(null == fieldPermScheme ? "" : fieldPermScheme.getName());
                sensitive = null == fieldPermScheme ? "" : fieldPermScheme.getSensitive();
                x.setSensitive(sensitive);
                x.setDataChangeType(delDCTEnum);
                x.setDataChangeTypeDesc(delDescConst);
                opDescSuffix = StringUtils.isNotEmpty((String)sensitive) && Objects.equals("1", sensitive) ? opSeneitiveDesc_ : opDesc_;
                x.setOpDesc(delDescConst + opDescSuffix);
            }
            for (FieldPermScheme x : addFps) {
                appId = x.getAppId();
                entityNumber = x.getEntityNumber();
                cloud = cloudMap.get(appId);
                if (null != cloud) {
                    x.setCloudId(cloud.getString("bizcloud.id"));
                    x.setCloudName(cloud.getString("bizcloud.name"));
                }
                x.setAppName(appIdNameMap.get(appId));
                x.setEntityName(entityNameMap.get(entityNumber));
                fieldPermScheme = (FieldPermScheme)fpsMap.get(x.getId());
                x.setName(null == fieldPermScheme ? "" : fieldPermScheme.getName());
                sensitive = null == fieldPermScheme ? "" : fieldPermScheme.getSensitive();
                x.setSensitive(sensitive);
                x.setDataChangeType(addDCTEnum);
                x.setDataChangeTypeDesc(addDescConst);
                opDescSuffix = StringUtils.isNotEmpty((String)sensitive) && Objects.equals("1", sensitive) ? opSeneitiveDesc_ : opDesc_;
                x.setOpDesc(addDescConst + opDescSuffix);
            }
            delFps.addAll(addFps);
            if (null == delFps || delFps.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_fps");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_num, fentity_name, ffpschemeid, ffpschemename, fsensitive, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = delFps.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                FieldPermScheme one = delFps.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appId2 = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityNumber2 = StrUtil.nullAbleStr((String)one.getEntityNumber());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String ffpschemename = StrUtil.nullAbleStr((String)one.getName());
                String sensitive2 = StrUtil.nullAbleStr((String)one.getSensitive());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId2, appName, entityNumber2, entityName, one.getId(), ffpschemename, sensitive2, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), null, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_fps error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_funcPerm(Long fid, Map<String, Object> diffMap, Map<String, DynamicObject> cloudMap, Map<String, String> appIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap) throws JsonProcessingException {
        ObjectMapper delPermItemMapper = new ObjectMapper();
        List delList = (List)delPermItemMapper.readValue(delPermItemMapper.writeValueAsString(diffMap.get("delPermItem")), delPermItemMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleFuncPerm.class}));
        delList = null == delList ? new ArrayList(0) : delList;
        ObjectMapper addPermItemMapper = new ObjectMapper();
        List addList = (List)addPermItemMapper.readValue(addPermItemMapper.writeValueAsString(diffMap.get("addPermItem")), addPermItemMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleFuncPerm.class}));
        addList = null == addList ? new ArrayList(0) : addList;
        ObjectMapper updatePermItemMapper = new ObjectMapper();
        List updateList = (List)updatePermItemMapper.readValue(updatePermItemMapper.writeValueAsString(diffMap.get("updatePermItem")), updatePermItemMapper.getTypeFactory().constructParametricType(List.class, new Class[]{ComRoleFuncPerm.class}));
        updateList = null == updateList ? new ArrayList(0) : updateList;
        try {
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            String updateDescConst = ConstantsHelper.getUpdate();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateDCTEnum = EnumsDataChangeType.UPDATE;
            String opDesc_ = ConstantsHelper.getFuncPerm();
            List<LogFuncPerm> del = delList.stream().map(x -> {
                LogFuncPerm lfp = new LogFuncPerm();
                String appId = x.getAppId();
                String entityNumber = x.getEntityNumber();
                String permItemId = x.getPermItemId();
                lfp.setCloudId(x.getCloudId());
                DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                if (null != cloud) {
                    lfp.setCloudId(cloud.getString("bizcloud.id"));
                    lfp.setCloudName(cloud.getString("bizcloud.name"));
                }
                lfp.setAppId(appId);
                lfp.setAppName((String)appIdNameMap.get(appId));
                lfp.setEntityId(entityNumber);
                lfp.setEntityName((String)entityNameMap.get(entityNumber));
                lfp.setPermItemId(permItemId);
                lfp.setPermItemName((String)allPermitemMap.get(permItemId));
                lfp.setDataChangeType(delDCTEnum);
                lfp.setDataChangeTypeDesc(delDescConst);
                lfp.setOpDesc(delDescConst + opDesc_);
                return lfp;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                List add = addList.stream().map(x -> {
                    LogFuncPerm lfp = new LogFuncPerm();
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    lfp.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        lfp.setCloudId(cloud.getString("bizcloud.id"));
                        lfp.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    lfp.setAppId(appId);
                    lfp.setAppName((String)appIdNameMap.get(appId));
                    lfp.setEntityId(entityNumber);
                    lfp.setEntityName((String)entityNameMap.get(entityNumber));
                    lfp.setPermItemId(permItemId);
                    lfp.setPermItemName((String)allPermitemMap.get(permItemId));
                    lfp.setDataChangeType(addDCTEnum);
                    lfp.setDataChangeTypeDesc(addDescConst);
                    lfp.setOpDesc(addDescConst + opDesc_);
                    return lfp;
                }).collect(Collectors.toList());
                del.addAll(add);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                List update = updateList.stream().map(x -> {
                    LogFuncPerm lfp = new LogFuncPerm();
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    String permItemId = x.getPermItemId();
                    lfp.setCloudId(x.getCloudId());
                    DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                    if (null != cloud) {
                        lfp.setCloudId(cloud.getString("bizcloud.id"));
                        lfp.setCloudName(cloud.getString("bizcloud.name"));
                    }
                    lfp.setAppId(appId);
                    lfp.setAppName((String)appIdNameMap.get(appId));
                    lfp.setEntityId(entityNumber);
                    lfp.setEntityName((String)entityNameMap.get(entityNumber));
                    lfp.setPermItemId(permItemId);
                    String permItemName = (String)allPermitemMap.get(permItemId);
                    lfp.setPermItemName(permItemName);
                    lfp.setDataChangeType(updateDCTEnum);
                    lfp.setDataChangeTypeDesc(updateDescConst);
                    lfp.setOpDesc(updateDescConst + opDesc_);
                    return lfp;
                }).collect(Collectors.toList());
                del.addAll(update);
            }
            if (null == del || del.isEmpty()) {
                return false;
            }
            LogFuncPerm.save2DB(del, fid);
            return true;
        }
        catch (Exception e) {
            log.warn("CommonRoleLogDiffHandler.saveDiffDetail_funcPerm error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

