/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.model.log.LogDrEvent;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.LogDrInfo;
import kd.bos.util.StringUtils;

public class DrLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(DrLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
        try {
            LogDrEvent pre = (LogDrEvent)new ObjectMapper().readValue(preImage, LogDrEvent.class);
            LogDrEvent after = (LogDrEvent)new ObjectMapper().readValue(afterImage, LogDrEvent.class);
            boolean existsDiff = this.saveDiffDetail(fid, pre, after);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            this.saveInfluenceUser(fid, after.getAffectUserList());
            GenDiffService.updateHasGenDiff(fid, "success");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("preImage", preImage);
            map.put("afterImage", afterImage);
            this.permChangedExt("perm_datarule", SerializationUtils.toJsonString(map), fid);
        }
        catch (Exception e) {
            log.error("DrLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
    }

    private boolean saveDiffDetail(Long fid, LogDrEvent pre, LogDrEvent after) {
        try {
            LogDrInfo preBaseInfo = pre.getBaseInfo();
            LogDrInfo afterBaseInfo = after.getBaseInfo();
            if (Objects.equals(preBaseInfo, afterBaseInfo)) {
                return false;
            }
            this.saveDiffDetail_baseInfo(fid, preBaseInfo, afterBaseInfo);
            return true;
        }
        catch (Exception ex) {
            log.error("DrLogDiffHandler.saveDiffDetail error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private void saveDiffDetail_baseInfo(Long fid, LogDrInfo pre, LogDrInfo after) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_drinfo");
            sb.append("(fid, fperm_logid, fentity_id, fentity_name, fdr_number, fdr_name, frule, fenable, fdr_number_after, fdr_name_after, frule_after, fenable_after, fcreate_time)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            Map entityNameMap = FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
            LocalDateTime curTime = LocalDateTime.now();
            String preEntityId = StrUtil.nullAbleStr((String)pre.getEntityId());
            String preEntityName = StrUtil.nullAbleStr((String)((String)entityNameMap.get(preEntityId)));
            String afterEntityId = StrUtil.nullAbleStr((String)after.getEntityId());
            String afterEntityName = StrUtil.nullAbleStr((String)((String)entityNameMap.get(afterEntityId)));
            String entityId = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preEntityId) ? afterEntityId : preEntityId));
            String entityName = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preEntityName) ? afterEntityName : preEntityName));
            String drNumber = StrUtil.nullAbleStr((String)pre.getDrNumber());
            String drName = StrUtil.nullAbleStr((String)pre.getDrName());
            String ruleText = StrUtil.nullAbleStr((String)pre.getRuleText());
            String drEnable = StrUtil.nullAbleStr((String)pre.getDrEnable());
            String afterDrNumber = StrUtil.nullAbleStr((String)after.getDrNumber());
            String afterDrName = StrUtil.nullAbleStr((String)after.getDrName());
            String afterRuleText = StrUtil.nullAbleStr((String)after.getRuleText());
            String afterDrEnable = StrUtil.nullAbleStr((String)after.getDrEnable());
            Object[] obj = new Object[]{ID.genLongId(), fid, entityId, entityName, drNumber, drName, ruleText, drEnable, afterDrNumber, afterDrName, afterRuleText, afterDrEnable, curTime};
            paramList.add(obj);
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
        }
        catch (Exception e) {
            log.error("DrLogDiffHandler.saveDiffDetail_baseInfo error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

