/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.enums.EnumsFieldPermCtrlMode;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.util.StringUtils;

public class FpsLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(FpsLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
        try {
            FieldPermScheme pre = StringUtils.isEmpty((String)preImage) ? new FieldPermScheme() : (FieldPermScheme)new ObjectMapper().readValue(preImage, FieldPermScheme.class);
            FieldPermScheme after = StringUtils.isEmpty((String)afterImage) ? new FieldPermScheme() : (FieldPermScheme)new ObjectMapper().readValue(afterImage, FieldPermScheme.class);
            boolean existsDiff = this.saveDiffDetail(fid, pre, after);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            this.saveInfluenceUserByUserId(fid, after.getInfluenceUserIdSet());
            GenDiffService.updateHasGenDiff(fid, "success");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("preImage", preImage);
            map.put("afterImage", afterImage);
            this.permChangedExt("perm_fieldscheme", SerializationUtils.toJsonString(map), fid);
        }
        catch (Exception e) {
            log.error("FpsLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    @Override
    public void delChildTab(String fidStr) {
        PermLogService.delChildTab("t_perm_log_diff_fpsd", fidStr);
        PermLogService.delChildTab("t_perm_log_user", fidStr);
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
    }

    private boolean saveDiffDetail(Long fid, FieldPermScheme pre, FieldPermScheme after) {
        try {
            boolean baseInfoDiff = this.saveDiffDetail_baseInfo(fid, pre, after);
            List preFieldPermList = null == pre.getFieldPermList() || pre.getFieldPermList().isEmpty() ? new ArrayList(1) : pre.getFieldPermList();
            List afterFieldPermList = null == after.getFieldPermList() || after.getFieldPermList().isEmpty() ? new ArrayList(1) : after.getFieldPermList();
            List delList = ListUtil.removeAll(preFieldPermList, afterFieldPermList);
            List addList = ListUtil.removeAll(afterFieldPermList, preFieldPermList);
            String appId = StringUtils.isEmpty((String)pre.getAppId()) ? after.getAppId() : pre.getAppId();
            String entityNumber = StringUtils.isEmpty((String)pre.getEntityNumber()) ? after.getEntityNumber() : pre.getEntityNumber();
            boolean diff_fieldPerm = this.saveDiffDetail_fieldperm(fid, delList, addList, appId, entityNumber);
            return baseInfoDiff || diff_fieldPerm;
        }
        catch (Exception ex) {
            log.error("FpsLogDiffHandler.saveDiffDetail error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_baseInfo(Long fid, FieldPermScheme pre, FieldPermScheme after) {
        return !Objects.equals(pre, after);
    }

    private boolean saveDiffDetail_fieldperm(Long fid, List<FieldPerm> delList, List<FieldPerm> addList, String appId, String entityNumber) {
        try {
            if (delList.isEmpty() && (null == addList || addList.isEmpty())) {
                return false;
            }
            Map cloudMap = AppHelper.getCloudMap(null);
            Map appIdNameMap = AppHelper.getAllAppIdNameMap();
            Map entityNameMap = FormHelper.getEntityNameMap(null, (String)RequestContext.get().getLang().name());
            HashMap hasLoadMap = new HashMap(8);
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            String opDesc_ = ConstantsHelper.getFieldPerm();
            List del = delList.stream().map(x -> {
                FieldPerm lfp = new FieldPerm();
                String controlMode = x.getControlMode();
                String fieldName = x.getFieldName();
                lfp.setCloudId(x.getCloudId());
                DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                if (null != cloud) {
                    lfp.setCloudId(cloud.getString("bizcloud.id"));
                    lfp.setCloudName(cloud.getString("bizcloud.name"));
                }
                lfp.setAppId(appId);
                lfp.setAppName((String)appIdNameMap.get(appId));
                lfp.setEntityId(entityNumber);
                lfp.setEntityName((String)entityNameMap.get(entityNumber));
                lfp.setFieldName(fieldName);
                String filedComment = FormHelper.getEntityFieldNameMultiEnt((Map)hasLoadMap, (String)entityNumber, (String)fieldName);
                lfp.setFieldComment(filedComment);
                lfp.setControlMode(controlMode);
                lfp.setControlModeDesc(EnumsFieldPermCtrlMode.getDesc((String)controlMode));
                lfp.setDataChangeType(delDCTEnum);
                lfp.setDataChangeTypeDesc(delDescConst);
                lfp.setOpDesc(delDescConst + opDesc_);
                return lfp;
            }).collect(Collectors.toList());
            List add = addList.stream().map(x -> {
                FieldPerm lfp = new FieldPerm();
                String controlMode = x.getControlMode();
                String fieldName = x.getFieldName();
                lfp.setCloudId(x.getCloudId());
                DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
                if (null != cloud) {
                    lfp.setCloudId(cloud.getString("bizcloud.id"));
                    lfp.setCloudName(cloud.getString("bizcloud.name"));
                }
                lfp.setAppId(appId);
                lfp.setAppName((String)appIdNameMap.get(appId));
                lfp.setEntityId(entityNumber);
                lfp.setEntityName((String)entityNameMap.get(entityNumber));
                lfp.setFieldName(fieldName);
                String filedComment = FormHelper.getEntityFieldNameMultiEnt((Map)hasLoadMap, (String)entityNumber, (String)fieldName);
                lfp.setFieldComment(filedComment);
                lfp.setControlMode(controlMode);
                lfp.setControlModeDesc(ConstantsHelper.getControlModelDesc((String)controlMode));
                lfp.setDataChangeType(addDCTEnum);
                lfp.setDataChangeTypeDesc(addDescConst);
                lfp.setOpDesc(addDescConst + opDesc_);
                return lfp;
            }).collect(Collectors.toList());
            del.addAll(add);
            if (null == del || del.isEmpty()) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_fpsd");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, ffieldname, ffieldcomment, fcontrolmode, fcontrolmodedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = del.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                FieldPerm one = (FieldPerm)del.get(i);
                String cloudId = StrUtil.nullAbleStr((String)one.getCloudId());
                String cloudName = StrUtil.nullAbleStr((String)one.getCloudName());
                String appIdStr = StrUtil.nullAbleStr((String)one.getAppId());
                String appName = StrUtil.nullAbleStr((String)one.getAppName());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                String entityName = StrUtil.nullAbleStr((String)one.getEntityName());
                String fieldName = StrUtil.nullAbleStr((String)one.getFieldName());
                String fieldComment = StrUtil.nullAbleStr((String)one.getFieldComment());
                String controlMode = StrUtil.nullAbleStr((String)one.getControlMode());
                String controlModeDesc = StrUtil.nullAbleStr((String)one.getControlModeDesc());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appIdStr, appName, entityId, entityName, fieldName, fieldComment, controlMode, controlModeDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), null, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.error("FpsLogDiffHandler.saveDiffDetail_fieldperm error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

