/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogOprDirector;
import kd.bos.permission.log.model.LogOprEvent;
import kd.bos.permission.log.model.LogOprExRole;
import kd.bos.permission.log.model.LogOprExUsr;
import kd.bos.permission.log.model.LogOprExUsrGrp;
import kd.bos.permission.log.model.LogOprInfo;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.util.StringUtils;

public class OprLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(OprLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
        try {
            LogOprEvent pre = (LogOprEvent)new ObjectMapper().readValue(preImage, LogOprEvent.class);
            LogOprEvent after = (LogOprEvent)new ObjectMapper().readValue(afterImage, LogOprEvent.class);
            boolean existsDiff = this.saveDiffDetail(fid, pre, after);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            this.saveInfluenceUser(fid, after.getAffectUserList());
            GenDiffService.updateHasGenDiff(fid, "success");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("preImage", preImage);
            map.put("afterImage", afterImage);
            this.permChangedExt("perm_operationrule", SerializationUtils.toJsonString(map), fid);
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
    }

    private boolean saveDiffDetail(Long fid, LogOprEvent pre, LogOprEvent after) {
        try {
            LogOprInfo preBaseInfo = pre.getBaseInfo();
            LogOprInfo afterBaseInfo = after.getBaseInfo();
            boolean baseInfoDiff = this.saveDiffDetail_baseInfo(fid, preBaseInfo, afterBaseInfo);
            ArrayList<LogOprDirector> preDirectorList = pre.getDirectorList();
            preDirectorList = null == preDirectorList ? new ArrayList<LogOprDirector>(0) : preDirectorList;
            ArrayList<LogOprDirector> afterDirectorList = after.getDirectorList();
            afterDirectorList = null == afterDirectorList ? new ArrayList<LogOprDirector>(0) : afterDirectorList;
            boolean directorDiff = this.saveDiffDetail_directorList(fid, preDirectorList, afterDirectorList);
            ArrayList<LogOprExUsr> preExusrList = pre.getExusrList();
            preExusrList = null == preExusrList ? new ArrayList<LogOprExUsr>(0) : preExusrList;
            ArrayList<LogOprExUsr> afterExusrList = after.getExusrList();
            afterExusrList = null == afterExusrList ? new ArrayList<LogOprExUsr>(0) : afterExusrList;
            boolean exusrDiff = this.saveDiffDetail_exusrList(fid, preExusrList, afterExusrList);
            ArrayList<LogOprExUsrGrp> preExusrgrpList = pre.getExusrgrpList();
            preExusrgrpList = null == preExusrgrpList ? new ArrayList<LogOprExUsrGrp>(0) : preExusrgrpList;
            ArrayList<LogOprExUsrGrp> afterExusrgrpList = after.getExusrgrpList();
            afterExusrgrpList = null == afterExusrgrpList ? new ArrayList<LogOprExUsrGrp>(0) : afterExusrgrpList;
            boolean exusrgrpDiff = this.saveDiffDetail_exusrgrpList(fid, preExusrgrpList, afterExusrgrpList);
            ArrayList<LogOprExRole> preExroleList = pre.getExroleList();
            preExroleList = null == preExroleList ? new ArrayList<LogOprExRole>(0) : preExroleList;
            ArrayList<LogOprExRole> afterExroleList = after.getExroleList();
            afterExroleList = null == afterExroleList ? new ArrayList<LogOprExRole>(0) : afterExroleList;
            boolean exeroleDiff = this.saveDiffDetail_exroleList(fid, preExroleList, afterExroleList);
            return baseInfoDiff || directorDiff || exusrDiff || exusrgrpDiff || exeroleDiff;
        }
        catch (Exception ex) {
            log.warn("OprLogDiffHandler.saveDiffDetail error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_exroleList(Long fid, List<LogOprExRole> preList, List<LogOprExRole> afterList) {
        try {
            List<LogOprExRole> list = LogOprExRole.logCompare(preList, afterList);
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_oprexrole");
            sb.append("(fid, fperm_logid, frole_id, frole_number, frole_name, frole_remark, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogOprExRole one = list.get(i);
                String roleId = StrUtil.nullAbleStr((String)one.getRoleId());
                String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
                String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
                String roleRemark = StrUtil.nullAbleStr((String)one.getRoleRemark());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, roleId, roleNumber, roleName, roleRemark, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.saveDiffDetail_exroleList error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_exusrgrpList(Long fid, List<LogOprExUsrGrp> preList, List<LogOprExUsrGrp> afterList) {
        try {
            List<LogOprExUsrGrp> list = LogOprExUsrGrp.logCompare(preList, afterList);
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_oprexusgr");
            sb.append("(fid, fperm_logid, fusrgrp_id, fusrgrp_number, fusrgrp_name, fusrgrp_desc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogOprExUsrGrp one = list.get(i);
                String usrGrpNumber = StrUtil.nullAbleStr((String)one.getUsrGrpNumber());
                String usrGrpName = StrUtil.nullAbleStr((String)one.getUsrGrpName());
                String usrGrpDesc = StrUtil.nullAbleStr((String)one.getUsrGrpDesc());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getUsrGrpId(), usrGrpNumber, usrGrpName, usrGrpDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.saveDiffDetail_exusrgrpList error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_exusrList(Long fid, List<LogOprExUsr> preList, List<LogOprExUsr> afterList) {
        try {
            List<LogOprExUsr> list = LogOprExUsr.logCompare(preList, afterList);
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_oprexusr");
            sb.append("(fid, fperm_logid, fuser_id, fname, fnumber, fuser_name, fphone, femail, fposition, forgid, forg_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogOprExUsr one = list.get(i);
                String userTrueName = StrUtil.nullAbleStr((String)one.getTrueName());
                String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
                String userName = StrUtil.nullAbleStr((String)one.getUserName());
                String phone = StrUtil.nullAbleStr((String)one.getPhone());
                String email = StrUtil.nullAbleStr((String)one.getEmail());
                String position = StrUtil.nullAbleStr((String)one.getPosition());
                String orgName = StrUtil.nullAbleStr((String)one.getOrgName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                long orgId = null == one.getOrgId() ? 0L : one.getOrgId();
                obj = new Object[]{ids[i], fid, one.getUserId(), userTrueName, userNumber, userName, phone, email, position, orgId, orgName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.saveDiffDetail_exusrList error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_directorList(Long fid, List<LogOprDirector> preList, List<LogOprDirector> afterList) {
        try {
            List<LogOprDirector> list = LogOprDirector.logCompare(preList, afterList);
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_oprdirect");
            sb.append("(fid, fperm_logid, fdirector_id, fdirector_name, fdirector_number, fdirector_username, fphone, femail, fposition, forgid, forg_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogOprDirector one = list.get(i);
                String directorName = StrUtil.nullAbleStr((String)one.getTrueName());
                String directorNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
                String directorUsername = StrUtil.nullAbleStr((String)one.getUserName());
                String phone = StrUtil.nullAbleStr((String)one.getPhone());
                String email = StrUtil.nullAbleStr((String)one.getEmail());
                String position = StrUtil.nullAbleStr((String)one.getPosition());
                String orgName = StrUtil.nullAbleStr((String)one.getOrgName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getUserId(), directorName, directorNumber, directorUsername, phone, email, position, one.getOrgId(), orgName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.saveDiffDetail_directorList error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_baseInfo(Long fid, LogOprInfo pre, LogOprInfo after) {
        try {
            if (Objects.equals(pre, after)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_oprinfo");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fname, foperation, foperation_key, foperation_type, fispublic, fispreset, frule, foperationrule_objid, fobjenabled, ");
            sb.append("fname_after, foperation_after, foperation_key_after, foperation_type_after, fispublic_after, fispreset_after, frule_after, foperationrule_objid_after, fobjenabled_after, fcreate_time)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
            LocalDateTime curTime = LocalDateTime.now();
            String preCloudId = StrUtil.nullAbleStr((String)pre.getCloudId());
            String preCloudName = StrUtil.nullAbleStr((String)pre.getCloudName());
            String preAppId = StrUtil.nullAbleStr((String)pre.getAppId());
            String preAppName = StrUtil.nullAbleStr((String)pre.getAppName());
            String preEntityId = StrUtil.nullAbleStr((String)pre.getEntityId());
            String preEntityName = StrUtil.nullAbleStr((String)pre.getEntityName());
            String afterCloudId = StrUtil.nullAbleStr((String)after.getCloudId());
            String afterCloudName = StrUtil.nullAbleStr((String)after.getCloudName());
            String afterAppId = StrUtil.nullAbleStr((String)after.getAppId());
            String afterAppName = StrUtil.nullAbleStr((String)after.getAppName());
            String afterEntityId = StrUtil.nullAbleStr((String)after.getEntityId());
            String afterEntityName = StrUtil.nullAbleStr((String)after.getEntityName());
            String cloudId = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preCloudId) ? afterCloudId : preCloudId));
            String cloudName = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preCloudName) ? afterCloudName : preCloudName));
            String appId = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preAppId) ? afterAppId : preAppId));
            String appName = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preAppName) ? afterAppName : preAppName));
            String entityId = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preEntityId) ? afterEntityId : preEntityId));
            String entityName = StrUtil.nullAbleStr((String)(StringUtils.isEmpty((String)preEntityName) ? afterEntityName : preEntityName));
            String name = StrUtil.nullAbleStr((String)pre.getName());
            String operation = StrUtil.nullAbleStr((String)pre.getOperation());
            String operationKey = StrUtil.nullAbleStr((String)pre.getOperationKey());
            String operationType = StrUtil.nullAbleStr((String)pre.getOperationType());
            String publicYesOrNo = StrUtil.nullAbleStr((String)pre.getPublicYesOrNo());
            String presetYesOrNo = StrUtil.nullAbleStr((String)pre.getPresetYesOrNo());
            String ruleText = StrUtil.nullAbleStr((String)pre.getRuleText());
            String operationRuleObjId = StrUtil.nullAbleStr((String)pre.getOperationRuleObjId());
            String objenabled = StrUtil.nullAbleStr((String)pre.getObjenabled());
            String afterName = StrUtil.nullAbleStr((String)after.getName());
            String afterOperation = StrUtil.nullAbleStr((String)after.getOperation());
            String afterOperationKey = StrUtil.nullAbleStr((String)after.getOperationKey());
            String afterOperationType = StrUtil.nullAbleStr((String)after.getOperationType());
            String afterPublicYesOrNo = StrUtil.nullAbleStr((String)after.getPublicYesOrNo());
            String afterPresetYesOrNo = StrUtil.nullAbleStr((String)after.getPresetYesOrNo());
            String afterRuleText = StrUtil.nullAbleStr((String)after.getRuleText());
            String afterOperationRuleObjId = StrUtil.nullAbleStr((String)after.getOperationRuleObjId());
            String afterObjenabled = StrUtil.nullAbleStr((String)after.getObjenabled());
            Object[] obj = new Object[]{ID.genLongId(), fid, cloudId, cloudName, appId, appName, entityId, entityName, name, operation, operationKey, operationType, publicYesOrNo, presetYesOrNo, ruleText, operationRuleObjId, objenabled, afterName, afterOperation, afterOperationKey, afterOperationType, afterPublicYesOrNo, afterPresetYesOrNo, afterRuleText, afterOperationRuleObjId, afterObjenabled, curTime};
            paramList.add(obj);
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.warn("OprLogDiffHandler.saveDiffDetail_baseInfo error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

