/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.util.StringUtils;

public interface PermLogDiffHandler {
    public static final Log log = LogFactory.getLog(PermLogDiffHandler.class);

    public void genLogDiff(Long var1, String var2, String var3);

    public void saveLogDiff(Long var1, String var2);

    default public void delChildTab(String fidStr) {
    }

    default public boolean saveInfluenceUserByUserId(Long fid, Set<Long> influenceUserIdSet) {
        try {
            List userList = UserHelper.getUserListBySet(influenceUserIdSet, (String)RequestContext.get().getLang().name());
            return this.saveInfluenceUser(fid, userList);
        }
        catch (Exception e) {
            log.error("PermLogDiffHandler.saveInfluenceUser tx error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    default public boolean saveInfluenceUser(Long fid, List<User> userList) {
        try {
            if (CollectionUtils.isEmpty(userList)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_user");
            sb.append("(fid, fperm_logid, fuser_id, fname, fnumber, fuser_name, fphone, femail, fremark, fcreate_time)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = userList.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                User one = userList.get(i);
                String fremark = StrUtil.nullAbleStr((String)one.getFremark());
                String ftruename = StrUtil.nullAbleStr((String)one.getFtruename());
                String fnumber = StrUtil.nullAbleStr((String)one.getFnumber());
                String fusername = StrUtil.nullAbleStr((String)one.getFusername());
                String fphone = StrUtil.nullAbleStr((String)one.getFphone());
                String femail = StrUtil.nullAbleStr((String)one.getFemail());
                obj = new Object[]{ids[i], fid, one.getFid(), ftruename, fnumber, fusername, fphone, femail, fremark, curTime};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.error("PermLogDiffHandler.saveInfluenceUser tx error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    default public PermResult permChangedExt(String reqExtIdentity, String contentJstr, Long permLogId) {
        try {
            if (StringUtils.isNotEmpty((String)reqExtIdentity)) {
                PluginCall call;
                PluginProxy pluginProxy = PluginProxy.create(null, IPermExt.class, (String)"kd.bos.permission.api.ext.IPermExt", null);
                List pluginResults = pluginProxy.callReplaceIfPresent(call = p -> {
                    String extIdentity;
                    if (p != null && Objects.equals(extIdentity = p.getExtIdentity(), reqExtIdentity)) {
                        return p.permChanged(permLogId, contentJstr);
                    }
                    return null;
                });
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                pluginResults.removeIf(x -> null == x);
                if (null == pluginResults || pluginResults.isEmpty()) {
                    return PermResult.ok();
                }
                return (PermResult)pluginResults.get(0);
            }
            return null;
        }
        catch (Exception e) {
            log.error("PermLogDiffHandler.permChangedExt error.", (Throwable)e);
            return PermResult.ok();
        }
    }
}

