/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.util.StringUtils;

public class UgRoleDimLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UgRoleDimLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UgRoleDim.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UgRoleDim.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateObjMapper = new ObjectMapper();
            List updateList = (List)updateObjMapper.readValue(updateObjMapper.writeValueAsString(diffMap.get("update")), updateObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UgRoleDim.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            HashSet<Long> groupIdSet = new HashSet<Long>(8);
            HashSet<String> roleIdSet = new HashSet<String>(8);
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (UgRoleDim one : delList) {
                groupIdSet.add(one.getUsrGrpId());
                roleIdSet.add(one.getRoleId());
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (UgRoleDim one : addList) {
                groupIdSet.add(one.getUsrGrpId());
                roleIdSet.add(one.getRoleId());
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (UgRoleDim one : updateList) {
                groupIdSet.add(one.getUsrGrpId());
                roleIdSet.add(one.getRoleId());
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return;
            }
            Map usrGrpInfoMap = UserGroupHelper.getUsrGrpInfoMapByIds(groupIdSet);
            Map roleMap = PermRoleHelper.getRoleMap(new ArrayList(roleIdSet), (String)langStr);
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)RequestContext.get().getLang().name());
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                String key = (String)dimTypeDimIdSet.getKey();
                Set dimIdSet = (Set)dimTypeDimIdSet.getValue();
                Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIdSet), (String)key);
                Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
                String dimTypeName = (String)dimTypeMap.get("fname");
                List<UgRoleDim> one_delList = delList.stream().filter(x -> Objects.equals(x.getDimType(), key) && dimIdSet.contains(x.getDimId())).collect(Collectors.toList());
                List<UgRoleDim> one_addList = addList.stream().filter(x -> Objects.equals(x.getDimType(), key) && dimIdSet.contains(x.getDimId())).collect(Collectors.toList());
                List<UgRoleDim> one_updateList = updateList.stream().filter(x -> Objects.equals(x.getDimType(), key) && dimIdSet.contains(x.getDimId())).collect(Collectors.toList());
                this.saveDiffDetail(fid, one_delList, one_addList, one_updateList, usrGrpInfoMap, dimMap, roleMap, dimTypeName);
            }
            Set changedUserIdSet = UserGroupHelper.getUserListBySet(groupIdSet);
            List userList = UserHelper.getUserListBySet((Set)changedUserIdSet, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_usrgrprole", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UsrGrpRoleDimLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<UgRoleDim> delList, List<UgRoleDim> addList, List<UgRoleDim> updateList, Map<Long, UsrGrpUser> usrGrpInfoMap, Map<Long, Dim> dimMap, Map<String, Map<String, Object>> roleMap, String dimTypeName) {
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String dimUsrGrpDesc = ConstantsHelper.getDimUsrGrp((String)dimTypeName);
        String delDesc = ConstantsHelper.getDel();
        String delOpDesc = delDesc + dimUsrGrpDesc;
        String addDesc = ConstantsHelper.getAdd();
        String addOpDesc = addDesc + dimUsrGrpDesc;
        String updateDesc = ConstantsHelper.getUpdate();
        String updateOpDesc = updateDesc + dimUsrGrpDesc;
        String includeDesc = ConstantsHelper.getInclude();
        String notIncludeDesc = ConstantsHelper.getNotInclude();
        List<UgRoleDim> del = delList.stream().map(ugr -> this.fullurd(dimMap, usrGrpInfoMap, roleMap, (UgRoleDim)ugr, delEnum, delDesc, delOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
        List add = addList.stream().map(ugr -> this.fullurd(dimMap, usrGrpInfoMap, roleMap, (UgRoleDim)ugr, addEnum, addDesc, addOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
        List update = updateList.stream().map(ugr -> this.fullurd(dimMap, usrGrpInfoMap, roleMap, (UgRoleDim)ugr, updateEnum, updateDesc, updateOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
        del.addAll(add);
        del.addAll(update);
        this.save2DB(del, fid);
    }

    private void save2DB(List<UgRoleDim> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_ugroledim");
        sb.append("(fid, fperm_logid, fusrgrp_id, fusrgrp_name, fusrgrp_number, frole_id, frole_number, frole_name, fdim_id, fdim_number, fdim_name, finclude_sub, finclude_sub_desc, fdimtype, fdimtypedesc, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            UgRoleDim one = diffList.get(i);
            String usrGrpName = StrUtil.nullAbleStr((String)one.getUsrGrpName());
            String usrGrpNumber = StrUtil.nullAbleStr((String)one.getUsrGrpNumber());
            String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
            String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
            String dimName = StrUtil.nullAbleStr((String)one.getDimName());
            String dimNumber = StrUtil.nullAbleStr((String)one.getDimNumber());
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, one.getUsrGrpId(), usrGrpName, usrGrpNumber, one.getRoleId(), roleNumber, roleName, one.getDimId(), dimNumber, dimName, one.getIncludeSub(), one.getIncludeSubDesc(), one.getDimType(), one.getDimTypeDesc(), one.getStarttime(), one.getEndtime(), opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    private UgRoleDim fullurd(Map<Long, Dim> dimMap, Map<Long, UsrGrpUser> usrGrpInfoMap, Map<String, Map<String, Object>> roleMap, UgRoleDim ugr, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc, String dimTypeName, String includeDesc, String notIncludeDesc) {
        String includeSub;
        Dim dim;
        Map<String, Object> roleInfoMap;
        Long usrGrpId = ugr.getUsrGrpId();
        String roleId = ugr.getRoleId();
        Long dimId = ugr.getDimId();
        UsrGrpUser usrGrpUser = usrGrpInfoMap.get(usrGrpId);
        if (null != usrGrpUser) {
            ugr.setUsrGrpName(usrGrpUser.getUsrGrpName());
            ugr.setUsrGrpNumber(usrGrpUser.getUsrGrpNumber());
        }
        if (null != (roleInfoMap = roleMap.get(roleId)) && !roleInfoMap.isEmpty()) {
            ugr.setRoleName(String.valueOf(roleInfoMap.get("fname")));
            ugr.setRoleNumber(String.valueOf(roleInfoMap.get("fnumber")));
        }
        if (null != (dim = dimMap.get(dimId))) {
            ugr.setDimNumber(dim.getDimNumber());
            ugr.setDimName(dim.getDimName());
        }
        String includeSubDesc = StringUtils.isEmpty((String)(includeSub = ugr.getIncludeSub())) ? "" : ("1".equals(includeSub) ? includeDesc : notIncludeDesc);
        ugr.setIncludeSubDesc(includeSubDesc);
        ugr.setDimTypeDesc(dimTypeName);
        ugr.setDataChangeType(dataChangeType);
        ugr.setDataChangeTypeDesc(dataChangeTypeDesc);
        ugr.setOpDesc(opDesc);
        return ugr;
    }
}

