/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogBusiRole;
import kd.bos.permission.log.model.LogUserAsignBusiRole;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;

public class UserAssignBusiRoleSaveLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserAssignBusiRoleSaveLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
        try {
            LogUserAsignBusiRole pre = (LogUserAsignBusiRole)new ObjectMapper().readValue(preImage, LogUserAsignBusiRole.class);
            LogUserAsignBusiRole after = (LogUserAsignBusiRole)new ObjectMapper().readValue(afterImage, LogUserAsignBusiRole.class);
            boolean existsDiff = this.saveDiffDetail(fid, pre, after);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            this.saveInfluenceUser(fid, after.getAffectUserList());
            GenDiffService.updateHasGenDiff(fid, "success");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("preImage", preImage);
            map.put("afterImage", afterImage);
            this.permChangedExt("perm_userbizrole_snapshot", SerializationUtils.toJsonString(map), fid);
        }
        catch (Exception e) {
            log.error("UserAssignBusiRoleSaveLogDiffHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
    }

    private boolean saveDiffDetail(Long fid, LogUserAsignBusiRole pre, LogUserAsignBusiRole after) {
        try {
            ArrayList<LogBusiRole> preBusiRoleList = pre.getBusiRoleList();
            preBusiRoleList = null == preBusiRoleList ? new ArrayList<LogBusiRole>(0) : preBusiRoleList;
            ArrayList<LogBusiRole> afterBusiRoleList = after.getBusiRoleList();
            afterBusiRoleList = null == afterBusiRoleList ? new ArrayList<LogBusiRole>(0) : afterBusiRoleList;
            return this.saveDiffDetail_busiRole(fid, preBusiRoleList, afterBusiRoleList);
        }
        catch (Exception ex) {
            log.error("UserAssignBusiRoleSaveLogDiffHandler.saveDiffDetail error,", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }

    private boolean saveDiffDetail_busiRole(Long fid, List<LogBusiRole> preList, List<LogBusiRole> afterList) {
        try {
            List<LogBusiRole> list = LogBusiRole.logCompare(preList, afterList);
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_busirole");
            sb.append("(fid, fperm_logid, frole_number, frole_name, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc, fstarttime, fendtime)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?)");
            int size = list.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogBusiRole one = list.get(i);
                String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
                String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, roleNumber, roleName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc(), one.getStarTime(), one.getEndTime()};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.error("UserAssignBusiRoleSaveLogDiffHandler.saveDiffDetail_busiRole error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

