/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogDimDis;
import kd.bos.permission.log.model.LogDimRole;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.util.StringUtils;

public class UserAssignRoleSaveLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserAssignRoleSaveLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            Map diffPURMap = (Map)diffMap.get("diffPURMap");
            Map diffDimDisMap = (Map)diffMap.get("diffDimDisMap");
            String langStr = (String)diffMap.get("langStr");
            HashSet<Long> influenceUserIdSet = new HashSet<Long>(8);
            if (!CollectionUtils.isEmpty((Map)diffPURMap)) {
                ObjectMapper delPURObjMapper = new ObjectMapper();
                List delPURList = (List)delPURObjMapper.readValue(delPURObjMapper.writeValueAsString(diffPURMap.get("del")), delPURObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
                delPURList = null == delPURList ? new ArrayList(0) : delPURList;
                ObjectMapper addPURObjMapper = new ObjectMapper();
                List addPURList = (List)addPURObjMapper.readValue(addPURObjMapper.writeValueAsString(diffPURMap.get("add")), addPURObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
                addPURList = null == addPURList ? new ArrayList(0) : addPURList;
                ObjectMapper updatePURObjMapper = new ObjectMapper();
                List updatePURList = (List)updatePURObjMapper.readValue(updatePURObjMapper.writeValueAsString(diffPURMap.get("update")), updatePURObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
                updatePURList = null == updatePURList ? new ArrayList(0) : updatePURList;
                this.saveDimRoleDiff(fid, delPURList, addPURList, updatePURList, langStr, influenceUserIdSet);
            }
            if (!CollectionUtils.isEmpty((Map)diffDimDisMap)) {
                ObjectMapper delDimDisObjMapper = new ObjectMapper();
                List delDimDisList = (List)delDimDisObjMapper.readValue(delDimDisObjMapper.writeValueAsString(diffDimDisMap.get("del")), delDimDisObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimDis.class}));
                delDimDisList = null == delDimDisList ? new ArrayList(0) : delDimDisList;
                ObjectMapper addDimDisObjMapper = new ObjectMapper();
                List addDimDisList = (List)addDimDisObjMapper.readValue(addDimDisObjMapper.writeValueAsString(diffDimDisMap.get("add")), addDimDisObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimDis.class}));
                addDimDisList = null == addDimDisList ? new ArrayList(0) : addDimDisList;
                this.saveDimDisDiff(fid, delDimDisList, addDimDisList, langStr, influenceUserIdSet);
            }
            List userList = UserHelper.getUserListBySet(influenceUserIdSet, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_userrole_save", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UserAssignRoleSaveLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDimDisDiff(Long fid, List<LogDimDis> delDimDisList, List<LogDimDis> addDimDisList, String langStr, Set<Long> influenceUserIdSet) {
        if (CollectionUtils.isEmpty(delDimDisList) && CollectionUtils.isEmpty(addDimDisList)) {
            return;
        }
        delDimDisList.addAll(addDimDisList);
        Set delDimDisUserIdSet = delDimDisList.stream().map(LogDimDis::getUserId).collect(Collectors.toSet());
        influenceUserIdSet.addAll(delDimDisUserIdSet);
        LogDimDis.save2DB(delDimDisList, fid);
    }

    private void saveDimRoleDiff(Long fid, List<PermUserRole> delPURList, List<PermUserRole> addPURList, List<PermUserRole> updatePURList, String langStr, Set<Long> influenceUserIdSet) {
        if (CollectionUtils.isEmpty(delPURList) && CollectionUtils.isEmpty(addPURList) && CollectionUtils.isEmpty(updatePURList)) {
            return;
        }
        HashSet<String> changedRoleIdSet = new HashSet<String>(8);
        HashMap<String, Set> dimTypeDimIdMap = new HashMap<String, Set>(8);
        for (PermUserRole pur2 : delPURList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
            influenceUserIdSet.add(pur2.getFuserid());
            changedRoleIdSet.add(pur2.getFroleid());
        }
        for (PermUserRole pur2 : addPURList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
            influenceUserIdSet.add(pur2.getFuserid());
            changedRoleIdSet.add(pur2.getFroleid());
        }
        for (PermUserRole pur2 : updatePURList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
            influenceUserIdSet.add(pur2.getFuserid());
            changedRoleIdSet.add(pur2.getFroleid());
        }
        if (null == dimTypeDimIdMap || dimTypeDimIdMap.isEmpty()) {
            return;
        }
        ArrayList<LogDimRole> list = new ArrayList<LogDimRole>(10);
        Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)langStr);
        Map roleMap = PermRoleHelper.getRoleMap(new LinkedList(changedRoleIdSet), (String)langStr);
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String delDesc = ConstantsHelper.getDel();
        String addDesc = ConstantsHelper.getAdd();
        String updateDesc = ConstantsHelper.getUpdate();
        String includeDesc = ConstantsHelper.getInclude();
        String notIncludeDesc = ConstantsHelper.getNotInclude();
        for (Map.Entry dimTypeDimId : dimTypeDimIdMap.entrySet()) {
            String key = (String)dimTypeDimId.getKey();
            Set value = (Set)dimTypeDimId.getValue();
            if (null == value || value.isEmpty()) continue;
            Map dimMap = IsoDimHelper.getDimMap(new LinkedList(value), (String)key);
            Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
            String dimTypeName = (String)dimTypeMap.get("fname");
            String dimTypeNameDesc = ConstantsHelper.getOrgUser((String)dimTypeName);
            String delOpDesc = delDesc + dimTypeNameDesc;
            String addOpDesc = addDesc + dimTypeNameDesc;
            String updateOpDesc = updateDesc + dimTypeNameDesc;
            List del = delPURList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldr(dimMap, roleMap, (PermUserRole)pur, delEnum, delDesc, delOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List add = addPURList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldr(dimMap, roleMap, (PermUserRole)pur, addEnum, addDesc, addOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List update = updatePURList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldr(dimMap, roleMap, (PermUserRole)pur, updateEnum, updateDesc, updateOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            list.addAll(del);
            list.addAll(add);
            list.addAll(update);
        }
        LogDimRole.save2DB(list, fid);
    }

    private LogDimRole pur2ldr(Map<Long, Dim> dimMap, Map<String, Map<String, Object>> roleMap, PermUserRole pur, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc, String dimTypeName, String includeDesc, String notIncludeDesc) {
        LogDimRole ldr = new LogDimRole();
        String froleid = pur.getFroleid();
        ldr.setRoleId(froleid);
        Map<String, Object> role = roleMap.get(froleid);
        if (!CollectionUtils.isEmpty(role)) {
            ldr.setRoleNumber((String)role.get("fnumber"));
            ldr.setRoleName((String)role.get("fname"));
        }
        Long dimId = pur.getForgid();
        ldr.setDimId(dimId);
        Dim dim = dimMap.get(dimId);
        if (null != dim) {
            ldr.setDimNumber(dim.getDimNumber());
            ldr.setDimName(dim.getDimName());
        }
        String fisincludesuborg = pur.getFisincludesuborg();
        ldr.setIncludesuborg(fisincludesuborg);
        String fisincludesuborgDesc = StringUtils.isEmpty((String)fisincludesuborg) ? "" : ("1".equals(fisincludesuborg) ? includeDesc : notIncludeDesc);
        ldr.setIncludesuborgDesc(fisincludesuborgDesc);
        ldr.setDimType(pur.getFdimtype());
        ldr.setDimTypeDesc(dimTypeName);
        ldr.setFstarttime(pur.getFstarttime());
        ldr.setFendtime(pur.getFendtime());
        ldr.setDataChangeType(dataChangeType);
        ldr.setDataChangeTypeDesc(dataChangeTypeDesc);
        ldr.setOpDesc(opDesc);
        return ldr;
    }
}

