/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.userbusirole.UserBusiRole;
import kd.bos.util.CollectionUtils;

public class UserBusiRoleLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserBusiRoleLogDiffHandler.class);

    @Override
    public void delChildTab(String fidStr) {
        PermLogService.delChildTab("t_perm_log_diff_ubizrole", fidStr);
        PermLogService.delChildTab("t_perm_log_user", fidStr);
    }

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UserBusiRole.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UserBusiRole.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateObjMapper = new ObjectMapper();
            List updateList = (List)updateObjMapper.readValue(updateObjMapper.writeValueAsString(diffMap.get("update")), updateObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UserBusiRole.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            HashSet<Long> userIdSet = new HashSet<Long>(8);
            HashSet<String> busiRoleIdSet = new HashSet<String>(8);
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                for (UserBusiRole one : delList) {
                    userIdSet.add(one.getUserId());
                    busiRoleIdSet.add(one.getBusiRoleId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                for (UserBusiRole one : addList) {
                    userIdSet.add(one.getUserId());
                    busiRoleIdSet.add(one.getBusiRoleId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                for (UserBusiRole one : updateList) {
                    userIdSet.add(one.getUserId());
                    busiRoleIdSet.add(one.getBusiRoleId());
                }
            }
            this.saveDiffDetail(fid, delList, addList, updateList, userIdSet, busiRoleIdSet, langStr);
            List userList = UserHelper.getUserListBySet(userIdSet, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_userbizrole", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UserBusiRoleLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<UserBusiRole> delList, List<UserBusiRole> addList, List<UserBusiRole> updateList, Set<Long> changedUserIdSet, Set<String> changedBusiRoleIdSet, String langStr) {
        ArrayList<UserBusiRole> list = new ArrayList<UserBusiRole>(10);
        Map userInfoMap = UserHelper.getUserInfoMapByIds(changedUserIdSet, (String)langStr);
        Map busiRoleBaseMap = PermBusiRoleHelper.getBusiRoleBaseMap(changedBusiRoleIdSet.stream().map(x -> Long.valueOf(x)).collect(Collectors.toSet()), null);
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String delDesc = ConstantsHelper.getDel();
        String addDesc = ConstantsHelper.getAdd();
        String updateDesc = ConstantsHelper.getUpdate();
        String userBusiRoleRelateDesc = ConstantsHelper.getUserBusiRoleRelateDesc();
        String delOpDesc = delDesc + userBusiRoleRelateDesc;
        String addOpDesc = addDesc + userBusiRoleRelateDesc;
        String updateOpDesc = updateDesc + userBusiRoleRelateDesc;
        delList.stream().forEach(ubr -> this.fullUbr(userInfoMap, busiRoleBaseMap, (UserBusiRole)ubr, delEnum, delDesc, delOpDesc));
        addList.stream().forEach(ubr -> this.fullUbr(userInfoMap, busiRoleBaseMap, (UserBusiRole)ubr, addEnum, addDesc, addOpDesc));
        updateList.stream().forEach(ubr -> this.fullUbr(userInfoMap, busiRoleBaseMap, (UserBusiRole)ubr, updateEnum, updateDesc, updateOpDesc));
        list.addAll(delList);
        list.addAll(addList);
        list.addAll(updateList);
        this.save2DB(list, fid);
    }

    private void save2DB(List<UserBusiRole> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_ubizrole");
        sb.append("(fid, fperm_logid, fuser_id, fuser_name, fuser_number, fuser_username, fphone, femail, frole_number, frole_name, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            UserBusiRole one = diffList.get(i);
            String busiRoleNumber = StrUtil.nullAbleStr((String)one.getBusiRoleNumber());
            String busiRoleName = StrUtil.nullAbleStr((String)one.getBusiRoleName());
            String trueName = StrUtil.nullAbleStr((String)one.getTrueName());
            String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
            String userName = StrUtil.nullAbleStr((String)one.getUserName());
            String phone = StrUtil.nullAbleStr((String)one.getPhone());
            String email = StrUtil.nullAbleStr((String)one.getEmail());
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, one.getUserId(), trueName, userNumber, userName, phone, email, busiRoleNumber, busiRoleName, one.getStartTime(), one.getEndTime(), opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    private void fullUbr(Map<Long, User> userInfoMap, Map<Long, BusiRole> busiRoleBaseMap, UserBusiRole ubr, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc) {
        BusiRole busiRole;
        Long fuserid = ubr.getUserId();
        User user = userInfoMap.get(fuserid);
        if (null != user) {
            ubr.setTrueName(user.getFtruename());
            ubr.setUserNumber(user.getFnumber());
            ubr.setUserName(user.getFusername());
            ubr.setPhone(user.getFphone());
            ubr.setEmail(user.getFemail());
        }
        if (null != (busiRole = busiRoleBaseMap.get(Long.valueOf(ubr.getBusiRoleId())))) {
            ubr.setBusiRoleNumber(busiRole.getNumber());
            ubr.setBusiRoleName(busiRole.getName());
        }
        ubr.setDataChangeType(dataChangeType);
        ubr.setDataChangeTypeDesc(dataChangeTypeDesc);
        ubr.setOpDesc(opDesc);
    }
}

