/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogCopyTarUser;
import kd.bos.permission.log.model.LogUserCopyPermSave;
import kd.bos.permission.log.service.GenDiffService;

public class UserCopyPermSaveLogHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserCopyPermSaveLogHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
        try {
            LogUserCopyPermSave after = (LogUserCopyPermSave)new ObjectMapper().readValue(afterImage, LogUserCopyPermSave.class);
            this.saveDetail(fid, after);
            this.saveInfluenceUser(fid, after.getAffectUserList());
            GenDiffService.updateHasGenDiff(fid, "success");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("preImage", preImage);
            map.put("afterImage", afterImage);
            this.permChangedExt("bos_copyperm", SerializationUtils.toJsonString(map), fid);
        }
        catch (Exception e) {
            log.error("UserCopyPermSaveLogHandler.genLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
    }

    private void saveDetail(Long fid, LogUserCopyPermSave after) {
        List<LogCopyTarUser> tarUserList = after.getTarUserList();
        if (CollectionUtils.isEmpty(tarUserList)) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_copytaruser");
            sb.append("(fid, fperm_logid, fuser_id, fname, fnumber, fuser_name, fop_desc, fcreate_time)");
            sb.append(" values(?,?,?,?,?,?,?,?)");
            int size = tarUserList.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            for (int i = 0; i < size; ++i) {
                LogCopyTarUser one = tarUserList.get(i);
                String trueName = StrUtil.nullAbleStr((String)one.getTrueName());
                String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
                String userName = StrUtil.nullAbleStr((String)one.getUserName());
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, one.getUserId(), trueName, userNumber, userName, opDesc, curTime};
                paramList.add(obj);
            }
            SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)5000, (DBRoute)DBRoute.log, (boolean)true);
        }
        catch (Exception e) {
            log.error("UserCopyPermSaveLogHandler.saveDetail error,", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

