/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DimNewDrPermHelper;
import kd.bos.permission.cache.helper.DimNewDrPrPermHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogDimField;
import kd.bos.permission.log.model.LogDimFps;
import kd.bos.permission.log.model.LogDimFunc;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.DimNewDrPerm;
import kd.bos.permission.model.perm.DimNewDrPrPerm;

public class UserDirectSaveLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserDirectSaveLogDiffHandler.class);

    @Override
    public void delChildTab(String fidStr) {
        PermLogService.delChildTab("t_perm_log_diff_dimfunc", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_dimfps", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_dimfield", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_dimnewdr", fidStr);
        PermLogService.delChildTab("t_perm_log_diff_dimnewdrp", fidStr);
        PermLogService.delChildTab("t_perm_log_user", fidStr);
    }

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            Map diffDimFuncMap = (Map)diffMap.get("diffDimFuncMap");
            Map diffDimFieldMap = (Map)diffMap.get("diffDimFieldMap");
            Map diffDimFpsMap = (Map)diffMap.get("diffDimFpsMap");
            Map diffDrAndPrMap = (Map)diffMap.get("diffDrAndPrMap");
            List influenceUsers = (List)diffMap.get("influenceUsers");
            String langStr = (String)diffMap.get("langStr");
            HashSet<String> influenceEntNumSet = new HashSet<String>(8);
            boolean existsDiff = this.saveDiffDetail(fid, diffDimFuncMap, diffDimFieldMap, diffDimFpsMap, diffDrAndPrMap, langStr, influenceEntNumSet);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            Set collect = influenceUsers.stream().map(x -> Long.valueOf(x)).collect(Collectors.toSet());
            List userList = UserHelper.getUserListBySet(collect, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_userpermdetail", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UserDirectSaveLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private boolean saveDiffDetail(Long fid, Map<String, Object> diffDimFuncMap, Map<String, Object> diffDimFieldMap, Map<String, Object> diffDimFpsMap, Map<String, Object> diffDrAndPrMap, String langStr, Set<String> influenceEntNumSet) throws Exception {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        paraMap.put("includeDesc", ConstantsHelper.getInclude());
        paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
        boolean dimFuncPermDiff = this.saveDimFuncDiff(fid, diffDimFuncMap, paraMap, influenceEntNumSet);
        boolean dimFieldDiff = this.saveDimFieldDiff(fid, diffDimFieldMap, paraMap, influenceEntNumSet);
        boolean dimFpsDiff = LogDimFps.saveDimFpsDiff(fid, diffDimFpsMap, langStr, paraMap);
        boolean dimDrAndPrDiff = this.saveDrAndPrDiff(fid, diffDrAndPrMap, langStr, paraMap, influenceEntNumSet);
        return dimFuncPermDiff || dimFieldDiff || dimFpsDiff || dimDrAndPrDiff;
    }

    private boolean saveDrAndPrDiff(Long fid, Map<String, Object> diffDrAndPrMap, String langStr, Map<String, Object> paraMap, Set<String> influenceEntNumSet) throws Exception {
        if (CollectionUtils.isEmpty(diffDrAndPrMap)) {
            return false;
        }
        Map newDrMap = (Map)diffDrAndPrMap.get("newDrMap");
        boolean drDiff = this.saveDrDiff(fid, newDrMap, langStr, paraMap, influenceEntNumSet);
        Map newDrPrMap = (Map)diffDrAndPrMap.get("newDrPrMap");
        boolean drprDiff = this.saveDrPrDiff(fid, newDrPrMap, langStr, paraMap, influenceEntNumSet);
        return drDiff || drprDiff;
    }

    private boolean saveDrPrDiff(Long fid, Map<String, Object> newDrPrMap, String langStr, Map<String, Object> paraMap, Set<String> influenceEntNumSet) throws Exception {
        if (CollectionUtils.isEmpty(newDrPrMap)) {
            return false;
        }
        ObjectMapper delDrPrObjMapper = new ObjectMapper();
        List delDrPrList = (List)delDrPrObjMapper.readValue(delDrPrObjMapper.writeValueAsString(newDrPrMap.get("delDrPr")), delDrPrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPrPerm.class}));
        delDrPrList = null == delDrPrList ? new ArrayList(0) : delDrPrList;
        ObjectMapper addDrPrObjMapper = new ObjectMapper();
        List addDrPrList = (List)addDrPrObjMapper.readValue(addDrPrObjMapper.writeValueAsString(newDrPrMap.get("addDrPr")), addDrPrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPrPerm.class}));
        addDrPrList = null == addDrPrList ? new ArrayList(0) : addDrPrList;
        ObjectMapper updateDrPrObjMapper = new ObjectMapper();
        List updateDrPrList = (List)updateDrPrObjMapper.readValue(updateDrPrObjMapper.writeValueAsString(newDrPrMap.get("updateDrPr")), updateDrPrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPrPerm.class}));
        List list = updateDrPrList = null == updateDrPrList ? new ArrayList(0) : updateDrPrList;
        if (CollectionUtils.isEmpty((Collection)delDrPrList) && CollectionUtils.isEmpty((Collection)addDrPrList) && CollectionUtils.isEmpty((Collection)updateDrPrList)) {
            return false;
        }
        delDrPrList.addAll(addDrPrList);
        delDrPrList.addAll(updateDrPrList);
        DimNewDrPrPermHelper.saveLogDiff2DB((List)delDrPrList, (Long)fid, (String)langStr, paraMap, influenceEntNumSet);
        return true;
    }

    private boolean saveDrDiff(Long fid, Map<String, Object> newDrMap, String langStr, Map<String, Object> paraMap, Set<String> influenceEntNumSet) throws Exception {
        if (CollectionUtils.isEmpty(newDrMap)) {
            return false;
        }
        ObjectMapper delDrObjMapper = new ObjectMapper();
        List delDrList = (List)delDrObjMapper.readValue(delDrObjMapper.writeValueAsString(newDrMap.get("delDr")), delDrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPerm.class}));
        delDrList = null == delDrList ? new ArrayList(0) : delDrList;
        ObjectMapper addDrObjMapper = new ObjectMapper();
        List addDrList = (List)addDrObjMapper.readValue(addDrObjMapper.writeValueAsString(newDrMap.get("addDr")), addDrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPerm.class}));
        addDrList = null == addDrList ? new ArrayList(0) : addDrList;
        ObjectMapper updateDrObjMapper = new ObjectMapper();
        List updateDrList = (List)updateDrObjMapper.readValue(updateDrObjMapper.writeValueAsString(newDrMap.get("updateDr")), updateDrObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{DimNewDrPerm.class}));
        List list = updateDrList = null == updateDrList ? new ArrayList(0) : updateDrList;
        if (CollectionUtils.isEmpty((Collection)delDrList) && CollectionUtils.isEmpty((Collection)addDrList) && CollectionUtils.isEmpty((Collection)updateDrList)) {
            return false;
        }
        delDrList.addAll(addDrList);
        delDrList.addAll(updateDrList);
        DimNewDrPermHelper.saveLogDiff2DB((List)delDrList, (Long)fid, (String)langStr, paraMap, influenceEntNumSet);
        return true;
    }

    private boolean saveDimFieldDiff(Long fid, Map<String, Object> diffDimFieldMap, Map<String, Object> paraMap, Set<String> influenceEntNumSet) throws Exception {
        if (CollectionUtils.isEmpty(diffDimFieldMap)) {
            return false;
        }
        ObjectMapper delDimFieldObjMapper = new ObjectMapper();
        List delDimFieldList = (List)delDimFieldObjMapper.readValue(delDimFieldObjMapper.writeValueAsString(diffDimFieldMap.get("del")), delDimFieldObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimField.class}));
        delDimFieldList = null == delDimFieldList ? new ArrayList(0) : delDimFieldList;
        ObjectMapper addDimFieldObjMapper = new ObjectMapper();
        List addDimFieldList = (List)addDimFieldObjMapper.readValue(addDimFieldObjMapper.writeValueAsString(diffDimFieldMap.get("add")), addDimFieldObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimField.class}));
        List list = addDimFieldList = null == addDimFieldList ? new ArrayList(0) : addDimFieldList;
        if (CollectionUtils.isEmpty((Collection)delDimFieldList) && CollectionUtils.isEmpty((Collection)addDimFieldList)) {
            return false;
        }
        delDimFieldList.addAll(addDimFieldList);
        LogDimField.save2DB(delDimFieldList, fid, paraMap, influenceEntNumSet);
        return true;
    }

    private boolean saveDimFuncDiff(Long fid, Map<String, Object> diffDimFuncMap, Map<String, Object> paraMap, Set<String> influenceEntNumSet) throws Exception {
        if (CollectionUtils.isEmpty(diffDimFuncMap)) {
            return false;
        }
        ObjectMapper delDimFuncObjMapper = new ObjectMapper();
        List delDimFuncList = (List)delDimFuncObjMapper.readValue(delDimFuncObjMapper.writeValueAsString(diffDimFuncMap.get("del")), delDimFuncObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimFunc.class}));
        delDimFuncList = null == delDimFuncList ? new ArrayList(0) : delDimFuncList;
        ObjectMapper addDimFuncObjMapper = new ObjectMapper();
        List addDimFuncList = (List)addDimFuncObjMapper.readValue(addDimFuncObjMapper.writeValueAsString(diffDimFuncMap.get("add")), addDimFuncObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimFunc.class}));
        addDimFuncList = null == addDimFuncList ? new ArrayList(0) : addDimFuncList;
        ObjectMapper updateDimFuncObjMapper = new ObjectMapper();
        List updateDimFuncList = (List)updateDimFuncObjMapper.readValue(updateDimFuncObjMapper.writeValueAsString(diffDimFuncMap.get("update")), updateDimFuncObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimFunc.class}));
        List list = updateDimFuncList = null == updateDimFuncList ? new ArrayList(0) : updateDimFuncList;
        if (CollectionUtils.isEmpty((Collection)delDimFuncList) && CollectionUtils.isEmpty((Collection)addDimFuncList) && CollectionUtils.isEmpty((Collection)updateDimFuncList)) {
            return false;
        }
        if (null != addDimFuncList) {
            delDimFuncList.addAll(addDimFuncList);
        }
        if (null != updateDimFuncList) {
            delDimFuncList.addAll(updateDimFuncList);
        }
        LogDimFunc.save2DB(delDimFuncList, fid, paraMap, influenceEntNumSet);
        return true;
    }
}

