/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.LogDimDis;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;

public class UserDisFunSaveLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserDisFunSaveLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            Map diffDimDisMap = (Map)diffMap.get("diffDimDisMap");
            List influenceUsers = (List)diffMap.get("influenceUsers");
            String langStr = (String)diffMap.get("langStr");
            boolean existsDiff = this.saveDiffDetail(fid, diffDimDisMap, langStr);
            if (!existsDiff) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            List userList = UserHelper.getUserListBySet(new HashSet(influenceUsers), (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_direct_disperm", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UserDirectDisFunSaveLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private boolean saveDiffDetail(Long fid, Map<String, Object> diffDimDisMap, String langStr) throws Exception {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("allCloudMap", AppHelper.getAllCloudMap());
        paraMap.put("allAppIdNameMap", AppHelper.getAllAppIdNameMap());
        paraMap.put("entityNameMap", FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name()));
        paraMap.put("allPermItemMap", PermItemHelper.getAllPermItemIdNameMap());
        paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        paraMap.put("includeDesc", ConstantsHelper.getInclude());
        paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
        return this.saveDimDisDiff(fid, diffDimDisMap, langStr, paraMap);
    }

    private boolean saveDimDisDiff(Long fid, Map<String, Object> diffDimDisMap, String langStr, Map<String, Object> paraMap) throws Exception {
        if (CollectionUtils.isEmpty(diffDimDisMap)) {
            return false;
        }
        ObjectMapper delDimDisObjMapper = new ObjectMapper();
        List delDimDisList = (List)delDimDisObjMapper.readValue(delDimDisObjMapper.writeValueAsString(diffDimDisMap.get("del")), delDimDisObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimDis.class}));
        delDimDisList = null == delDimDisList ? new ArrayList(0) : delDimDisList;
        ObjectMapper addDimDisObjMapper = new ObjectMapper();
        List addDimDisList = (List)addDimDisObjMapper.readValue(addDimDisObjMapper.writeValueAsString(diffDimDisMap.get("add")), addDimDisObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimDis.class}));
        addDimDisList = null == addDimDisList ? new ArrayList(0) : addDimDisList;
        ObjectMapper updateDimDisObjMapper = new ObjectMapper();
        List updateDimDisList = (List)updateDimDisObjMapper.readValue(updateDimDisObjMapper.writeValueAsString(diffDimDisMap.get("update")), updateDimDisObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{LogDimDis.class}));
        List list = updateDimDisList = null == updateDimDisList ? new ArrayList(0) : updateDimDisList;
        if (CollectionUtils.isEmpty((Collection)delDimDisList) && CollectionUtils.isEmpty((Collection)addDimDisList) && CollectionUtils.isEmpty((Collection)updateDimDisList)) {
            return false;
        }
        String funcPermDesc = ConstantsHelper.getFuncPerm();
        if (!CollectionUtils.isEmpty((Collection)delDimDisList)) {
            EnumsDataChangeType delDCT = EnumsDataChangeType.DEL;
            String delDesc = ConstantsHelper.getDel();
            String delOpDesc = delDesc + funcPermDesc;
            delDimDisList.stream().forEach(ldd -> {
                ldd.setOpDesc(delOpDesc);
                ldd.setDataChangeType(delDCT);
                ldd.setDataChangeTypeDesc(delDesc);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)addDimDisList)) {
            EnumsDataChangeType addDCT = EnumsDataChangeType.ADD;
            String addDesc = ConstantsHelper.getAdd();
            String addOpDesc = addDesc + funcPermDesc;
            addDimDisList.stream().forEach(ldd -> {
                ldd.setOpDesc(addOpDesc);
                ldd.setDataChangeType(addDCT);
                ldd.setDataChangeTypeDesc(addDesc);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)updateDimDisList)) {
            EnumsDataChangeType updateDCT = EnumsDataChangeType.UPDATE;
            String updateDesc = ConstantsHelper.getAdd();
            String updateOpDesc = updateDesc + funcPermDesc;
            updateDimDisList.stream().forEach(ldd -> {
                ldd.setOpDesc(updateOpDesc);
                ldd.setDataChangeType(updateDCT);
                ldd.setDataChangeTypeDesc(updateDesc);
            });
        }
        if (null != addDimDisList) {
            delDimDisList.addAll(addDimDisList);
        }
        if (null != updateDimDisList) {
            delDimDisList.addAll(updateDimDisList);
        }
        LogDimDis.save2DB(delDimDisList, fid, paraMap);
        return true;
    }
}

