/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.userrole.UserRoleDim;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserRoleLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(UserRoleLogDiffHandler.class);

    @Override
    public void delChildTab(String fidStr) {
        PermLogService.delChildTab("t_perm_log_diff_urdim", fidStr);
        PermLogService.delChildTab("t_perm_log_user", fidStr);
    }

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            ObjectMapper updateObjMapper = new ObjectMapper();
            List updateList = (List)updateObjMapper.readValue(updateObjMapper.writeValueAsString(diffMap.get("update")), updateObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{PermUserRole.class}));
            updateList = null == updateList ? new ArrayList(0) : updateList;
            HashSet<Long> userIdSet = new HashSet<Long>(8);
            HashSet<String> roleIdSet = new HashSet<String>(8);
            if (CollectionUtils.isNotEmpty((Collection)delList)) {
                for (PermUserRole one : delList) {
                    userIdSet.add(one.getFuserid());
                    roleIdSet.add(one.getFroleid());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                for (PermUserRole one : addList) {
                    userIdSet.add(one.getFuserid());
                    roleIdSet.add(one.getFroleid());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                for (PermUserRole one : updateList) {
                    userIdSet.add(one.getFuserid());
                    roleIdSet.add(one.getFroleid());
                }
            }
            this.saveDiffDetail(fid, delList, addList, updateList, userIdSet, roleIdSet, langStr);
            List userList = UserHelper.getUserListBySet(userIdSet, (String)langStr);
            this.saveInfluenceUser(fid, userList);
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("perm_userrole", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UserRoleLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<PermUserRole> delList, List<PermUserRole> addList, List<PermUserRole> updateList, Set<Long> changedUserIdSet, Set<String> changedRoleIdSet, String langStr) {
        HashMap<String, Set> dimTypeDimIdMap = new HashMap<String, Set>(8);
        for (PermUserRole pur2 : delList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        for (PermUserRole pur2 : addList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        for (PermUserRole pur2 : updateList) {
            dimTypeDimIdMap.computeIfAbsent(pur2.getFdimtype(), k -> new HashSet(8)).add(pur2.getForgid());
        }
        if (null == dimTypeDimIdMap || dimTypeDimIdMap.isEmpty()) {
            return;
        }
        ArrayList<UserRoleDim> list = new ArrayList<UserRoleDim>(10);
        Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)langStr);
        Map userInfoMap = UserHelper.getUserInfoMapByIds(changedUserIdSet, (String)langStr);
        Map comRoleBaseMap = PermRoleHelper.getComRoleBaseMap(changedRoleIdSet, null);
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
        String delDesc = ConstantsHelper.getDel();
        String addDesc = ConstantsHelper.getAdd();
        String updateDesc = ConstantsHelper.getUpdate();
        String includeDesc = ConstantsHelper.getInclude();
        String notIncludeDesc = ConstantsHelper.getNotInclude();
        for (Map.Entry dimTypeDimId : dimTypeDimIdMap.entrySet()) {
            String key = (String)dimTypeDimId.getKey();
            Set value = (Set)dimTypeDimId.getValue();
            if (null == value || value.isEmpty()) continue;
            Map dimMap = IsoDimHelper.getDimMap(new LinkedList(value), (String)key);
            Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
            String dimTypeName = (String)dimTypeMap.get("fname");
            String orgUserDesc = ConstantsHelper.getOrgUser((String)dimTypeName);
            String delOpDesc = delDesc + orgUserDesc;
            String addOpDesc = addDesc + orgUserDesc;
            String updateOpDesc = updateDesc + orgUserDesc;
            List del = delList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, comRoleBaseMap, (PermUserRole)pur, delEnum, delDesc, delOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List add = addList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, comRoleBaseMap, (PermUserRole)pur, addEnum, addDesc, addOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            List update = updateList.stream().filter(x -> Objects.equals(x.getFdimtype(), key)).map(pur -> this.pur2ldu(dimMap, userInfoMap, comRoleBaseMap, (PermUserRole)pur, updateEnum, updateDesc, updateOpDesc, dimTypeName, includeDesc, notIncludeDesc)).collect(Collectors.toList());
            list.addAll(del);
            list.addAll(add);
            list.addAll(update);
        }
        this.save2DB(list, fid);
    }

    private void save2DB(List<UserRoleDim> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_urdim");
        sb.append("(fid, fperm_logid, frole_number, frole_name, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fuser_id, fuser_name, fuser_number, fuser_username, fphone, femail, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            UserRoleDim one = diffList.get(i);
            String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
            String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
            String dimNumber = StrUtil.nullAbleStr((String)one.getDimNumber());
            String dimName = StrUtil.nullAbleStr((String)one.getDimName());
            String includesuborgDesc = StrUtil.nullAbleStr((String)one.getIncludeSubDesc());
            String dimType = StrUtil.nullAbleStr((String)one.getDimType());
            String dimTypeDesc = StrUtil.nullAbleStr((String)one.getDimTypeDesc());
            String trueName = StrUtil.nullAbleStr((String)one.getTrueName());
            String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
            String userName = StrUtil.nullAbleStr((String)one.getUserName());
            String phone = StrUtil.nullAbleStr((String)one.getPhone());
            String email = StrUtil.nullAbleStr((String)one.getEmail());
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, roleNumber, roleName, one.getDimId(), dimNumber, dimName, one.getIncludeSub(), includesuborgDesc, dimType, dimTypeDesc, one.getUserId(), trueName, userNumber, userName, phone, email, one.getStartTime(), one.getEndTime(), opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    private UserRoleDim pur2ldu(Map<Long, Dim> dimMap, Map<Long, User> userInfoMap, Map<String, ComRole> comRoleBaseMap, PermUserRole pur, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc, String dimTypeName, String includeDesc, String notIncludeDesc) {
        String fisincludesuborg;
        ComRole comRole;
        UserRoleDim ldu = new UserRoleDim();
        Long fuserid = pur.getFuserid();
        ldu.setUserId(fuserid);
        User user = userInfoMap.get(fuserid);
        if (null != user) {
            ldu.setTrueName(user.getFtruename());
            ldu.setUserNumber(user.getFnumber());
            ldu.setUserName(user.getFusername());
            ldu.setPhone(user.getFphone());
            ldu.setEmail(user.getFemail());
        }
        if (null != (comRole = comRoleBaseMap.get(pur.getFroleid()))) {
            ldu.setRoleNumber(comRole.getNumber());
            ldu.setRoleName(comRole.getName());
        }
        Long dimId = pur.getForgid();
        ldu.setDimId(dimId);
        Dim dim = dimMap.get(dimId);
        if (null != dim) {
            ldu.setDimNumber(dim.getDimNumber());
            ldu.setDimName(dim.getDimName());
        }
        ldu.setIncludeSub(StringUtils.isNotEmpty((String)(fisincludesuborg = pur.getFisincludesuborg())) && Objects.equals("1", fisincludesuborg) ? Boolean.TRUE : Boolean.FALSE);
        String fisincludesuborgDesc = StringUtils.isEmpty((String)fisincludesuborg) ? "" : ("1".equals(fisincludesuborg) ? includeDesc : notIncludeDesc);
        ldu.setIncludeSubDesc(fisincludesuborgDesc);
        ldu.setDimType(pur.getFdimtype());
        ldu.setDimTypeDesc(dimTypeName);
        ldu.setStartTime(pur.getFstarttime());
        ldu.setEndTime(pur.getFendtime());
        ldu.setDataChangeType(dataChangeType);
        ldu.setDataChangeTypeDesc(dataChangeTypeDesc);
        ldu.setOpDesc(opDesc);
        return ldu;
    }
}

