/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.log.handler.CommonRoleAssignOrgUserLogDiffHandler;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.service.GenDiffService;
import kd.bos.permission.log.service.PermLogService;

public class UsrGrpUserLogDiffHandler
implements PermLogDiffHandler {
    private static Log log = LogFactory.getLog(CommonRoleAssignOrgUserLogDiffHandler.class);

    @Override
    public void genLogDiff(Long fid, String preImage, String afterImage) {
    }

    @Override
    public void saveLogDiff(Long fid, String diffContent) {
        try {
            String uncompress = StrUtil.uncompress((String)diffContent);
            Map diffMap = (Map)new ObjectMapper().readValue(uncompress, Map.class);
            String langStr = (String)diffMap.get("langStr");
            ObjectMapper delObjMapper = new ObjectMapper();
            List delList = (List)delObjMapper.readValue(delObjMapper.writeValueAsString(diffMap.get("del")), delObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UsrGrpUser.class}));
            delList = null == delList ? new ArrayList(0) : delList;
            ObjectMapper addObjMapper = new ObjectMapper();
            List addList = (List)addObjMapper.readValue(addObjMapper.writeValueAsString(diffMap.get("add")), addObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UsrGrpUser.class}));
            addList = null == addList ? new ArrayList(0) : addList;
            HashSet<Long> userIdSet = new HashSet<Long>(8);
            HashSet<Long> groupIdSet = new HashSet<Long>(8);
            for (UsrGrpUser usrGrpUser : delList) {
                userIdSet.add(usrGrpUser.getUserId());
                groupIdSet.add(usrGrpUser.getUsrGrpId());
            }
            for (UsrGrpUser usrGrpUser : addList) {
                userIdSet.add(usrGrpUser.getUserId());
                groupIdSet.add(usrGrpUser.getUsrGrpId());
            }
            if ((null == userIdSet || userIdSet.isEmpty()) && (null == groupIdSet || groupIdSet.isEmpty())) {
                PermLogService.del(Sets.newHashSet((Object[])new Long[]{fid}));
                return;
            }
            Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, (String)langStr);
            Map usrGrpInfoMap = UserGroupHelper.getUsrGrpInfoMapByIds(groupIdSet);
            this.saveDiffDetail(fid, delList, addList, userInfoMap, usrGrpInfoMap);
            this.saveInfluenceUser(fid, userInfoMap.values().stream().collect(Collectors.toList()));
            GenDiffService.updateHasGenDiff(fid, "success");
            this.permChangedExt("bos_usergroupstaff", uncompress, fid);
        }
        catch (Exception e) {
            log.error("UsrGrpUserLogDiffHandler.saveLogDiff error", (Throwable)e);
            GenDiffService.updateHasGenDiff(fid, e.getMessage());
            return;
        }
    }

    private void saveDiffDetail(Long fid, List<UsrGrpUser> delList, List<UsrGrpUser> addList, Map<Long, User> userInfoMap, Map<Long, UsrGrpUser> usrGrpInfoMap) {
        EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
        EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
        String userGroupUserRelate = ConstantsHelper.getUserGroupUserRelate();
        String delDesc = ConstantsHelper.getDel();
        String delOpDesc = delDesc + userGroupUserRelate;
        String addDesc = ConstantsHelper.getAdd();
        String addOpDesc = addDesc + userGroupUserRelate;
        List<UsrGrpUser> del = delList.stream().map(ugu -> this.fullugu((UsrGrpUser)ugu, userInfoMap, usrGrpInfoMap, delEnum, delDesc, delOpDesc)).collect(Collectors.toList());
        List add = addList.stream().map(ugu -> this.fullugu((UsrGrpUser)ugu, userInfoMap, usrGrpInfoMap, addEnum, addDesc, addOpDesc)).collect(Collectors.toList());
        del.addAll(add);
        this.save2DB(del, fid);
    }

    private UsrGrpUser fullugu(UsrGrpUser ugu, Map<Long, User> userInfoMap, Map<Long, UsrGrpUser> usrGrpInfoMap, EnumsDataChangeType dataChangeType, String dataChangeTypeDesc, String opDesc) {
        UsrGrpUser usrGrpUser;
        User user = userInfoMap.get(ugu.getUserId());
        if (null != user) {
            ugu.setUserNumber(user.getFnumber());
            ugu.setUserName(user.getFtruename());
            ugu.setUserUserName(user.getFusername());
            ugu.setPhone(user.getFphone());
            ugu.setEmail(user.getFemail());
        }
        if (null != (usrGrpUser = usrGrpInfoMap.get(ugu.getUsrGrpId()))) {
            ugu.setUsrGrpNumber(usrGrpUser.getUsrGrpNumber());
            ugu.setUsrGrpName(usrGrpUser.getUsrGrpName());
        }
        ugu.setDataChangeType(dataChangeType);
        ugu.setDataChangeTypeDesc(dataChangeTypeDesc);
        ugu.setOpDesc(opDesc);
        return ugu;
    }

    private void save2DB(List<UsrGrpUser> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_usrgrpu");
        sb.append("(fid, fperm_logid, fusrgrp_id, fusrgrp_name, fusrgrp_number, fuser_id, fuser_name, fuser_number, fuser_username, fphone, femail, ffrom_type, ffrom_type_desc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            UsrGrpUser one = diffList.get(i);
            String usrGrpName = StrUtil.nullAbleStr((String)one.getUsrGrpName());
            String usrGrpNumber = StrUtil.nullAbleStr((String)one.getUsrGrpNumber());
            String userName = StrUtil.nullAbleStr((String)one.getUserName());
            String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
            String userUserName = StrUtil.nullAbleStr((String)one.getUserUserName());
            String phone = StrUtil.nullAbleStr((String)one.getPhone());
            String email = StrUtil.nullAbleStr((String)one.getEmail());
            String fromTypeOri = one.getFromType();
            String fromType = StrUtil.nullAbleStr((String)fromTypeOri);
            String fromTypeDesc = StrUtil.nullAbleStr((String)GrpUsrFromTypeEnum.getDesc((String)fromType));
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, one.getUsrGrpId(), usrGrpName, usrGrpNumber, one.getUserId(), userName, userNumber, userUserName, phone, email, fromType, fromTypeDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }
}

