/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.log.LogDrEvent;
import kd.bos.permission.model.perm.LogDrInfo;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DrLogHelper {
    private static Log log = LogFactory.getLog(DrLogHelper.class);

    public static String drEventImage(Long dataRuleId, String langStr, boolean isAfterImage, String paramEntityNum) {
        LogDrEvent do_ = new LogDrEvent();
        try {
            if (null == dataRuleId || 0L == dataRuleId) {
                log.debug("DrLogHelper.drEventImage dataRuleId is empty, dataRuleId:{}, langStr:{}", (Object)dataRuleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            LogDrInfo baseInfo = DrLogHelper.getDrBaseInfo(dataRuleId, langStr, paramEntityNum);
            if (null == baseInfo) {
                log.debug("DrLogHelper.drEventImage baseInfo is empty, dataRuleId:{}, langStr:{}", (Object)dataRuleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List affectUserList = do_.getAffectUserList();
            if (isAfterImage) {
                List userIdList = DrHelper.getUserIdList((Long)dataRuleId);
                affectUserList.addAll(UserHelper.getUserListBySet(new HashSet(userIdList), (String)langStr));
            }
            do_.setBaseInfo(baseInfo);
            do_.setAffectUserList(affectUserList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("DrLogHelper.drEventImage error, dataRuleId:{}, langStr:{}", new Object[]{dataRuleId, langStr, e});
            return e.getMessage();
        }
    }

    public static LogDrInfo getDrBaseInfo(Long dataRuleId, String langStr, final String paramEntityNum) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fentitynum, fnumber, fname,frule, fenable");
        sql.append(" from t_perm_datarule");
        sql.append(" where fid = ?");
        Object[] queryParams = new Object[]{dataRuleId};
        return (LogDrInfo)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<LogDrInfo>(){

            public LogDrInfo handle(ResultSet rs) throws SQLException {
                LogDrInfo one = new LogDrInfo();
                while (rs.next()) {
                    String entityId = StringUtils.isEmpty((String)paramEntityNum) ? rs.getString("fentitynum") : paramEntityNum;
                    one.setEntityId(entityId);
                    one.setDrNumber(rs.getString("fnumber"));
                    one.setDrName(rs.getString("fname"));
                    one.setRuleText(rs.getString("frule"));
                    one.setDrEnable(rs.getString("fenable"));
                }
                return one;
            }
        });
    }
}

