/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.log.callable.GetLogIdByAffectUserCallable;
import kd.bos.permission.log.callable.GetLogIdByPermChangeFormCallable;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class LogQueryHelper {
    private static Log log = LogFactory.getLog(LogQueryHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_LogQueryHelper_Pool", (int)1);

    public static Set<Long> getLogIdSetByAffectUser(String kw) {
        try {
            StringBuilder sb = new StringBuilder("select fperm_logid from ");
            sb.append("t_perm_log_user");
            sb.append(" where fname like '").append(kw).append("%' or fuser_name like '").append(kw).append("%'");
            return (Set)DB.query((DBRoute)DBRoute.log, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws SQLException {
                    HashSet<Long> set = new HashSet<Long>(8);
                    while (rs.next()) {
                        set.add(rs.getLong("fperm_logid"));
                    }
                    return set;
                }
            });
        }
        catch (Exception e) {
            log.warn("LogAffectUserHelper.getLogIdSetByAffectUser error, kw:{}", (Object)kw, (Object)e);
            return new HashSet<Long>(1);
        }
    }

    public static Set<Long> getLogIdSetByForm(String kw, String tableName) {
        try {
            StringBuilder sb = new StringBuilder("select fperm_logid from ");
            sb.append(tableName);
            sb.append(" where fentity_name like '").append(kw).append("%'");
            return (Set)DB.query((DBRoute)DBRoute.log, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws SQLException {
                    HashSet<Long> set = new HashSet<Long>(8);
                    while (rs.next()) {
                        set.add(rs.getLong("fperm_logid"));
                    }
                    return set;
                }
            });
        }
        catch (Exception e) {
            log.warn("LogAffectUserHelper.getLogIdSetByForm error, kw:{}", (Object)kw, (Object)e);
            return new HashSet<Long>(1);
        }
    }

    public static Set<Long> getLogIdSet(List<String> searchkwList) {
        try {
            if (CollectionUtils.isEmpty(searchkwList)) {
                log.debug("LogAffectUserHelper.getLogIdSet searchkwList is empty, searchkwList:{}", searchkwList);
                return new HashSet<Long>(1);
            }
            HashSet<Long> set = new HashSet<Long>(8);
            for (String kw : searchkwList) {
                Future logIdsSetByAffectUser = pool.submit((Callable)new GetLogIdByAffectUserCallable(kw));
                Future funcPerm = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_funcperm"));
                Future filePerm = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_fieldperm"));
                Future newDr = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_newdr"));
                Future newDrProp = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_newdrprop"));
                Future bcPerm = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_bcperm"));
                Future disPerm = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_disperm"));
                Future dimFunc = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimfunc"));
                Future dimField = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimfield"));
                Future dimNewDr = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimnewdr"));
                Future dimNewDrProp = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimnewdrp"));
                Future dimDis = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimdis"));
                Future fpsd = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_fpsd"));
                Future fps = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_fps"));
                Future dimfps = pool.submit((Callable)new GetLogIdByPermChangeFormCallable(kw, "t_perm_log_diff_dimfps"));
                set.addAll((Collection)logIdsSetByAffectUser.get());
                set.addAll((Collection)funcPerm.get());
                set.addAll((Collection)filePerm.get());
                set.addAll((Collection)newDr.get());
                set.addAll((Collection)newDrProp.get());
                set.addAll((Collection)bcPerm.get());
                set.addAll((Collection)disPerm.get());
                set.addAll((Collection)dimFunc.get());
                set.addAll((Collection)dimField.get());
                set.addAll((Collection)dimNewDr.get());
                set.addAll((Collection)dimNewDrProp.get());
                set.addAll((Collection)dimDis.get());
                set.addAll((Collection)fpsd.get());
                set.addAll((Collection)fps.get());
                set.addAll((Collection)dimfps.get());
            }
            return set;
        }
        catch (Exception e) {
            log.warn("LogAffectUserHelper.getLogIdSet error, searchkwList:{}", searchkwList, (Object)e);
            return new HashSet<Long>(1);
        }
    }
}

