/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.ConstantsHelper;
import kd.bos.permission.log.model.LogOprDirector;
import kd.bos.permission.log.model.LogOprEvent;
import kd.bos.permission.log.model.LogOprExRole;
import kd.bos.permission.log.model.LogOprExUsr;
import kd.bos.permission.log.model.LogOprExUsrGrp;
import kd.bos.permission.log.model.LogOprInfo;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.model.common.User;
import kd.bos.permission.log.model.common.UserPosition;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OprLogHelper {
    private static Log log = LogFactory.getLog(OprLogHelper.class);

    public static String oprEventImage(String opRuleId, String langStr, boolean isAfterImage, PermLogBusiType permLogBusiType, String paramAppId, String paramEntityNum, String preImg) {
        LogOprEvent do_ = new LogOprEvent();
        try {
            if (StringUtils.isEmpty((String)opRuleId)) {
                log.debug("OprLogHelper.oprEventImage opRuleId is empty, opRuleId:{}, langStr:{}", (Object)opRuleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            LogOprInfo baseInfo = OprLogHelper.getOprBaseInfo(opRuleId, langStr, paramAppId, paramEntityNum);
            if (null == baseInfo) {
                log.debug("OprLogHelper.oprEventImage baseInfo is empty, opRuleId:{}, langStr:{}", (Object)opRuleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List<LogOprDirector> directorList = do_.getDirectorList();
            List<LogOprExUsr> exusrList = do_.getExusrList();
            List<LogOprExUsrGrp> exusrgrpList = do_.getExusrgrpList();
            List<LogOprExRole> exroleList = do_.getExroleList();
            List userList = do_.getAffectUserList();
            String operationRuleObjId = baseInfo.getOperationRuleObjId();
            String busiType = permLogBusiType.getBusiType();
            if (StringUtils.isNotEmpty((String)operationRuleObjId)) {
                if ("opr_director".equals(busiType)) {
                    directorList = OprLogHelper.getDirectorList(operationRuleObjId, langStr);
                }
                if ("opr_exusr".equals(busiType)) {
                    exusrList = OprLogHelper.getExusrList(operationRuleObjId, langStr);
                }
                if ("opr_exusrgrp".equals(busiType)) {
                    exusrgrpList = OprLogHelper.getExusrgrpList(operationRuleObjId, langStr);
                }
                if ("opr_exrole".equals(busiType)) {
                    exroleList = OprLogHelper.getExroleList(operationRuleObjId, langStr);
                }
            }
            boolean needCountAffectUser = PermLogBusiType.checkNeedCountAffectUser(busiType);
            if (isAfterImage && needCountAffectUser) {
                HashSet<Object> influenUserIdSet = new HashSet<Object>(8);
                if ("opr_director".equals(busiType)) {
                    Set directUserIdSet = directorList.stream().map(User::getUserId).collect(Collectors.toSet());
                    influenUserIdSet.addAll(directUserIdSet);
                }
                if ("opr_exusr".equals(busiType)) {
                    Set exusrUserIdSet = exusrList.stream().map(User::getUserId).collect(Collectors.toSet());
                    influenUserIdSet.addAll(exusrUserIdSet);
                }
                if ("opr_exusrgrp".equals(busiType)) {
                    Set exusrgrpIdSet = exusrgrpList.stream().map(LogOprExUsrGrp::getUsrGrpId).collect(Collectors.toSet());
                    Set exusrgrpUserIdSet = UserGroupHelper.getUserListBySet(exusrgrpIdSet);
                    influenUserIdSet.addAll(exusrgrpUserIdSet);
                }
                if ("opr_exrole".equals(busiType)) {
                    Set exroleIdSet = exroleList.stream().map(LogOprExRole::getRoleId).collect(Collectors.toSet());
                    Set exroleIdUserIds = PermRoleHelper.getUserIds(exroleIdSet);
                    influenUserIdSet.addAll(exroleIdUserIds);
                }
                Set<Long> preImgUserList = OprLogHelper.getPreImgUserList(preImg, permLogBusiType);
                influenUserIdSet.addAll(preImgUserList);
                userList.addAll(UserHelper.getUserListBySet(influenUserIdSet, (String)langStr));
            }
            do_ = new LogOprEvent(baseInfo, directorList, exusrList, exusrgrpList, exroleList);
            do_.setAffectUserList(userList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("OprLogHelper.oprEventImage error, opRuleId:{}, langStr:{}", new Object[]{opRuleId, langStr, e});
            return e.getMessage();
        }
    }

    private static Set<Long> getPreImgUserList(String preImg, PermLogBusiType permLogBusiType) {
        try {
            if (StringUtils.isEmpty((String)preImg)) {
                return new HashSet<Long>(1);
            }
            LogOprEvent pre = (LogOprEvent)new ObjectMapper().readValue(preImg, LogOprEvent.class);
            if (null == pre) {
                return new HashSet<Long>(1);
            }
            List<LogOprDirector> directorList = pre.getDirectorList();
            List<LogOprExUsr> exusrList = pre.getExusrList();
            List<LogOprExUsrGrp> exusrgrpList = pre.getExusrgrpList();
            List<LogOprExRole> exroleList = pre.getExroleList();
            String busiType = permLogBusiType.getBusiType();
            if ("opr_director".equals(busiType)) {
                return directorList.stream().map(User::getUserId).collect(Collectors.toSet());
            }
            if ("opr_exusr".equals(busiType)) {
                return exusrList.stream().map(User::getUserId).collect(Collectors.toSet());
            }
            if ("opr_exusrgrp".equals(busiType)) {
                Set exusrgrpIdSet = exusrgrpList.stream().map(LogOprExUsrGrp::getUsrGrpId).collect(Collectors.toSet());
                return UserGroupHelper.getUserListBySet(exusrgrpIdSet);
            }
            if ("opr_exrole".equals(busiType)) {
                Set exroleIdSet = exroleList.stream().map(LogOprExRole::getRoleId).collect(Collectors.toSet());
                return PermRoleHelper.getUserIds(exroleIdSet);
            }
            return new HashSet<Long>(1);
        }
        catch (Exception e) {
            log.warn("OprLogHelper.getPreImgUserList error ", (Throwable)e);
            return new HashSet<Long>(1);
        }
    }

    private static List<LogOprExRole> getExroleList(String operationRuleObjId, String langStr) {
        StringBuilder sql = new StringBuilder("select a.froleid, b.fnumber, b.fname bName, b.fremark, c.fname cName");
        sql.append(" from t_perm_oprexrole a");
        sql.append(" left join t_perm_role b on a.froleid = b.fid");
        sql.append(" left join t_perm_role_l c on c.fid = b.fid and c.flocaleid = ?");
        sql.append(" where a.foperationruleobjid = ? ");
        Object[] params = new Object[]{langStr, operationRuleObjId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogOprExRole>>(){

            public List<LogOprExRole> handle(ResultSet rs) throws SQLException {
                ArrayList<LogOprExRole> list = new ArrayList<LogOprExRole>(8);
                LogOprExRole one = null;
                while (rs.next()) {
                    one = new LogOprExRole();
                    one.setRoleId(rs.getString("froleid"));
                    one.setRoleNumber(rs.getString("fnumber"));
                    String bName = rs.getString("bName");
                    String cName = rs.getString("cName");
                    one.setRoleName(StringUtils.isEmpty((String)cName) ? bName : cName);
                    one.setRoleRemark(rs.getString("fremark"));
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogOprExUsrGrp> getExusrgrpList(String operationRuleObjId, String langStr) {
        StringBuilder sql = new StringBuilder("select a.fusergroupid, b.fnumber, b.fname bName, b.fdescription, c.fname cName");
        sql.append(" from t_perm_oprexusrgrp a");
        sql.append(" left join t_sec_usergroup b on a.fusergroupid = b.fid");
        sql.append(" left join t_sec_usergroup_l c on c.fid = b.fid and c.flocaleid = ?");
        sql.append(" where a.foperationruleobjid = ? ");
        Object[] params = new Object[]{langStr, operationRuleObjId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogOprExUsrGrp>>(){

            public List<LogOprExUsrGrp> handle(ResultSet rs) throws SQLException {
                ArrayList<LogOprExUsrGrp> list = new ArrayList<LogOprExUsrGrp>(8);
                LogOprExUsrGrp one = null;
                while (rs.next()) {
                    one = new LogOprExUsrGrp();
                    one.setUsrGrpId(rs.getLong("fusergroupid"));
                    one.setUsrGrpNumber(rs.getString("fnumber"));
                    String bName = rs.getString("bName");
                    String cName = rs.getString("cName");
                    one.setUsrGrpName(StringUtils.isEmpty((String)cName) ? bName : cName);
                    one.setUsrGrpDesc(rs.getString("fdescription"));
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogOprExUsr> getExusrList(String operationRuleObjId, String langStr) {
        final ArrayList<LogOprExUsr> list = new ArrayList<LogOprExUsr>(8);
        StringBuilder sql = new StringBuilder("select fuserid");
        sql.append(" from t_perm_exceptuser");
        sql.append(" where foperationruleobjid = ? ");
        Object[] params = new Object[]{operationRuleObjId};
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                LogOprExUsr one = null;
                while (rs.next()) {
                    one = new LogOprExUsr();
                    one.setUserId(rs.getLong("fuserid"));
                    list.add(one);
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<LogOprExUsr>(1);
        }
        Set userIdSet = list.stream().map(User::getUserId).collect(Collectors.toSet());
        Map allOrgNameMap = OrgHelper.getAllOrgNameMap();
        Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, (String)langStr);
        Map userPositionInfoMap = UserHelper.getUserPositionInfoMapByIds(userIdSet, (String)langStr);
        list.stream().forEach(x -> {
            Long uId = x.getUserId();
            kd.bos.permission.cache.model.User user = (kd.bos.permission.cache.model.User)userInfoMap.get(uId);
            if (null != user) {
                x.setTrueName(user.getFtruename());
                x.setUserNumber(user.getFnumber());
                x.setUserName(user.getFusername());
                x.setPhone(user.getFphone());
                x.setEmail(user.getFemail());
                kd.bos.permission.cache.model.User userPostion = (kd.bos.permission.cache.model.User)userPositionInfoMap.get(uId);
                if (null != userPostion) {
                    x.setPosition(userPostion.getPosition());
                    Long dpId = userPostion.getDpId();
                    x.setOrgId(dpId);
                    x.setOrgName((String)allOrgNameMap.get(String.valueOf(dpId)));
                } else {
                    x.setOrgId(0L);
                    x.setOrgName(" ");
                }
            }
        });
        return list;
    }

    private static List<LogOprDirector> getDirectorList(String operationRuleObjId, String langStr) {
        final ArrayList<LogOprDirector> list = new ArrayList<LogOprDirector>(8);
        StringBuilder sql = new StringBuilder("select fdirectorid, forgid");
        sql.append(" from t_perm_director");
        sql.append(" where foperationruleobjid = ? ");
        Object[] params = new Object[]{operationRuleObjId};
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                LogOprDirector one = null;
                while (rs.next()) {
                    one = new LogOprDirector();
                    long fdirectorid = rs.getLong("fdirectorid");
                    long forgid = rs.getLong("forgid");
                    one.setUserId(fdirectorid);
                    one.setOrgId(forgid);
                    list.add(one);
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<LogOprDirector>(1);
        }
        Set dimIdSet = list.stream().map(UserPosition::getOrgId).collect(Collectors.toSet());
        Map orgMap = OrgHelper.getOrgMap(new ArrayList(dimIdSet));
        Set userIdSet = list.stream().map(User::getUserId).collect(Collectors.toSet());
        Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, (String)langStr);
        Map userPositionInfoMap = UserHelper.getUserPositionInfoMapByIds(userIdSet, (String)langStr);
        list.stream().forEach(x -> {
            Long directorId;
            kd.bos.permission.cache.model.User user;
            Long orgId = x.getOrgId();
            Org orgDo = (Org)orgMap.get(orgId);
            if (null != orgDo) {
                x.setOrgName(orgDo.getOrgName());
            }
            if (null != (user = (kd.bos.permission.cache.model.User)userInfoMap.get(directorId = x.getUserId()))) {
                x.setTrueName(user.getFtruename());
                x.setUserNumber(user.getFnumber());
                x.setUserName(user.getFusername());
                x.setPhone(user.getFphone());
                x.setEmail(user.getFemail());
                kd.bos.permission.cache.model.User userPostion = (kd.bos.permission.cache.model.User)userPositionInfoMap.get(directorId);
                if (null != userPostion) {
                    x.setPosition(userPostion.getPosition());
                }
            }
        });
        return list;
    }

    public static LogOprInfo getOprBaseInfo(String opRuleId, final String langStr, final String paramAppId, final String paramEntityNum) {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, b.fobjenabled, b.fid operationRuleObjId, a.foperationtype, a.fentitytypeid, a.fispublic, a.fbizappid, a.fispreset, a.frule, a.foperationkey, a.fname aName, c.fname cName, a.fdescription");
        sql.append(" from t_perm_operationrule a");
        sql.append(" left join t_perm_operationrule_l c on c.fid = a.fid and c.flocaleid = ?");
        sql.append(" left join t_perm_operationruleobj b on b.fbizappid = a.fbizappid and b.fentitytypeid = a.fentitytypeid and b.foperationruleid = a.fid");
        sql.append(" where a.fid = ?");
        Object[] queryParams = new Object[]{langStr, opRuleId};
        final LogOprInfo info = (LogOprInfo)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<LogOprInfo>(){

            public LogOprInfo handle(ResultSet rs) throws SQLException {
                LogOprInfo one = new LogOprInfo();
                while (rs.next()) {
                    String appId = StringUtils.isEmpty((String)paramAppId) ? rs.getString("fbizappid") : paramAppId;
                    Map appCloudMap = AppHelper.getCloudMap(Collections.singletonList(appId));
                    Map appIdNameMap = AppHelper.getAllAppIdNameMap();
                    Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
                    DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
                    if (null != cloudObj) {
                        one.setCloudId(cloudObj.getString("bizcloud.id"));
                        one.setCloudName(cloudObj.getString("bizcloud.name"));
                    }
                    one.setAppId(appId);
                    one.setAppName((String)appIdNameMap.get(appId));
                    String entityId = StringUtils.isEmpty((String)paramEntityNum) ? rs.getString("fentitytypeid") : paramEntityNum;
                    one.setEntityId(entityId);
                    one.setEntityName((String)entityNameMap.get(entityId));
                    String cName = rs.getString("cName");
                    String aName = rs.getString("aName");
                    one.setName(StringUtils.isEmpty((String)cName) ? aName : cName);
                    String operationKey = rs.getString("foperationkey");
                    String operationType = rs.getString("foperationtype");
                    Map operationInfoMap = OperationHelper.getOperationTypeInfoMap((String)entityId);
                    String operationName = (String)operationInfoMap.get(operationType);
                    Map operationKeyMap = OperationHelper.getOperationInfoMap((String)entityId);
                    if (StringUtils.isNotEmpty((String)operationKey) && !CollectionUtils.isEmpty((Map)operationKeyMap)) {
                        operationName = (String)operationKeyMap.get(operationKey);
                    }
                    one.setOperation(operationName);
                    one.setOperationKey(operationKey);
                    one.setOperationType(operationType);
                    one.setPublicYesOrNo(rs.getString("fispublic"));
                    one.setPresetYesOrNo(rs.getString("fispreset"));
                    String frule = rs.getString("frule");
                    frule = PermCommonUtil.replaceBackSlach((String)frule);
                    one.setRuleText(frule);
                    one.setObjenabled(rs.getString("fobjenabled"));
                    one.setOperationRuleObjId(rs.getString("operationRuleObjId"));
                }
                return one;
            }
        });
        if (StringUtils.isNotEmpty((String)paramEntityNum) && StringUtils.isNotEmpty((String)paramAppId)) {
            StringBuilder sqlObj = new StringBuilder();
            sqlObj.append("select b.fobjenabled, b.fid operationRuleObjId");
            sqlObj.append(" from t_perm_operationruleobj b");
            sqlObj.append(" where b.fbizappid = ? and b.fentitytypeid= ? and b.foperationruleid = ? ");
            Object[] queryObjParams = new Object[]{paramAppId, paramEntityNum, opRuleId};
            DB.query((DBRoute)DBRoute.basedata, (String)sqlObj.toString(), (Object[])queryObjParams, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        info.setObjenabled(rs.getString("fobjenabled"));
                        info.setOperationRuleObjId(rs.getString("operationRuleObjId"));
                    }
                    return null;
                }
            });
        }
        return info;
    }

    public static Map<String, Object> getOpr(String operationRuleObjId, String langStr) {
        if (StringUtils.isEmpty((String)operationRuleObjId)) {
            return new HashMap<String, Object>(1);
        }
        StringBuilder sql = new StringBuilder("select a.fid, a.foperationruleid, a.fentitytypeid, a.fobjenabled, a.fbizappid, b.fname bName, c.fname cName");
        sql.append(" from t_perm_operationruleobj a ");
        sql.append(" inner join  t_perm_operationrule b on b.fid = a.foperationruleid");
        sql.append(" left join  t_perm_operationrule_l c on c.fid = b.fid and c.flocaleid = ?");
        sql.append(" where a.fid = ? ");
        Object[] params = new Object[]{langStr, operationRuleObjId};
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                while (rs.next()) {
                    map.put("fid", rs.getString("fid"));
                    map.put("foperationruleid", rs.getString("foperationruleid"));
                    map.put("fentitytypeid", rs.getString("fentitytypeid"));
                    map.put("fobjenabled", rs.getString("fobjenabled"));
                    map.put("fbizappid", rs.getString("fbizappid"));
                    String bName = rs.getString("bName");
                    String cName = rs.getString("cName");
                    map.put("oprrulename", StringUtils.isEmpty((String)cName) ? bName : cName);
                }
                return map;
            }
        });
    }

    public static boolean add(PermLogBusiType logType, Map<String, Map<String, Object>> opPermLogMap, String opFormNum, String opAppId) {
        if (logType == null || CollectionUtils.isEmpty(opPermLogMap) || !PermCommonUtil.isEnablePermLog()) {
            return false;
        }
        boolean needCountAffectUser = PermLogBusiType.checkNeedCountAffectUser(logType.getBusiType());
        int count = opPermLogMap.size();
        ArrayList list = new ArrayList(count);
        String opCloudId = AppHelper.getMetaAppInfo((String)opAppId).getCloudId();
        HashMap<String, String> appDescMap = new HashMap<String, String>(count);
        String[] numbers = PermLogUtil.getPermLogFnumbers(count);
        int numIndex = 0;
        for (Map.Entry<String, Map<String, Object>> entry : opPermLogMap.entrySet()) {
            Map<String, Object> logMap = entry.getValue();
            Object logInfoParam = logMap.get("esloginfo");
            if (!(logInfoParam instanceof LogOprInfo)) continue;
            LogOprInfo logOprInfo = (LogOprInfo)logInfoParam;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("number", numbers[numIndex++]);
            map.put("busi_from", logType.getBusiTypeDesc());
            map.put("busi_type", logType.getBusiType());
            map.put("cloud_id", opCloudId);
            map.put("app_id", opAppId);
            map.put("form_identity", opFormNum);
            map.put("op", logOprInfo.getOperationKey());
            map.put("opbtn", logOprInfo.getOperation());
            map.put("interface_method", "kd.bos.permission.log.handler.OprLogDiffHandler");
            map.put("op_item_id", logOprInfo.getOperationRuleId());
            map.put("op_item_name", logOprInfo.getName());
            map.put("pre_data", OprLogHelper.getChangeData(logOprInfo, logMap, "pre_data"));
            map.put("after_data", OprLogHelper.getChangeData(logOprInfo, logMap, "after_data"));
            String desc = (String)appDescMap.get(logOprInfo.getAppId());
            if (desc == null) {
                desc = ConstantsHelper.getOprAffectUserDesc(logOprInfo.getAppId(), needCountAffectUser);
                appDescMap.put(logOprInfo.getAppId(), desc);
            }
            map.put("op_desc", desc);
            list.add(map);
        }
        BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
        BDLogHelper.addBDLog((BDLogInfo)info);
        return true;
    }

    private static Object getChangeData(LogOprInfo logOprInfo, Map<String, Object> logMap, String key) {
        try {
            Object beforeData = logMap.get(key);
            if (beforeData == null) {
                LogOprEvent beforeDataEvent = new LogOprEvent(new LogOprInfo(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
                beforeData = new ObjectMapper().writeValueAsString((Object)beforeDataEvent);
            }
            return beforeData;
        }
        catch (JsonProcessingException e) {
            log.warn("\u89e3\u6790\u7279\u6b8a\u6570\u636e\u6743\u9650\u64cd\u4f5c\u524d\u6570\u636e\u5931\u8d25\uff1a" + logOprInfo.getName(), (Throwable)e);
            return null;
        }
    }
}

