/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.log.model.LogAdmOrg;
import kd.bos.permission.log.model.LogAdmOrgUser;
import kd.bos.permission.log.model.LogAdminGroupPermSave;
import kd.bos.permission.log.model.LogAdminSave;
import kd.bos.permission.log.model.LogApp;
import kd.bos.permission.log.model.LogBusiUnit;
import kd.bos.permission.log.model.LogFuncPerm;
import kd.bos.permission.log.model.common.User;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermAdminLogHelper {
    private static Log log = LogFactory.getLog(PermAdminLogHelper.class);
    public static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public static String adminEventImage(String adminGroupId, String langStr, Set<Long> userIdSet) {
        LogAdminSave do_ = new LogAdminSave();
        try {
            boolean existAdminGroup;
            if (StringUtils.isEmpty((String)adminGroupId)) {
                log.debug("PermAdminLogHelper.adminEventImage adminGroupId illegal, adminGroupId:{}, langStr:{}", (Object)adminGroupId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            if (!ID_ROOTNODE.equalsIgnoreCase(adminGroupId) && !(existAdminGroup = PermAdminLogHelper.existAdminGroup(Long.valueOf(adminGroupId)))) {
                log.debug("PermAdminLogHelper.adminEventImage adminGroup not exist, adminGroupId:{}, langStr:{}", (Object)adminGroupId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            do_.setAffectUserList(UserHelper.getUserListBySet(userIdSet, (String)langStr));
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermAdminLogHelper.adminEventImage error, adminGroupId:{}, langStr:{}", new Object[]{adminGroupId, langStr, e});
            return e.getMessage();
        }
    }

    public static String adminGroupPermSaveImage(Long adminGroupId, String langStr, boolean isAfterImage, String preImg) {
        try {
            if (null == adminGroupId || 0L == adminGroupId) {
                log.debug("PermAdminLogHelper.adminGroupPermSaveImage adminGroupId illegal, adminGroupId:{}, langStr:{}", (Object)adminGroupId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)new LogAdminGroupPermSave());
            }
            boolean existAdminGroup = PermAdminLogHelper.existAdminGroup(adminGroupId);
            if (!existAdminGroup) {
                log.debug("PermAdminLogHelper.adminGroupPermSaveImage adminGroup not exist, adminGroupId:{}, langStr:{}", (Object)adminGroupId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)new LogAdminGroupPermSave());
            }
            List<LogFuncPerm> funcPermList = PermAdminLogHelper.getFuncPermList(adminGroupId, langStr);
            List<LogBusiUnit> busiUnitList = PermAdminLogHelper.getBusiUnitList(adminGroupId, langStr);
            List<LogAdmOrg> admOrgList = PermAdminLogHelper.getAdmOrgList(adminGroupId, langStr);
            List<LogAdmOrgUser> admOrgUserList = PermAdminLogHelper.getAdmOrgUserList(adminGroupId, langStr);
            List<LogApp> appList = PermAdminLogHelper.getAppList(adminGroupId, langStr);
            LogAdminGroupPermSave do_ = new LogAdminGroupPermSave(funcPermList, busiUnitList, admOrgList, admOrgUserList, appList);
            List userList = do_.getAffectUserList();
            if (isAfterImage) {
                Set adminUserIdSet = AdminGroupHelper.getAdminUserIds((Long)adminGroupId);
                Set admOrgExceptUsers = admOrgUserList.stream().map(User::getUserId).collect(Collectors.toSet());
                adminUserIdSet.addAll(admOrgExceptUsers);
                if (StringUtils.isEmpty((String)preImg)) {
                    userList.addAll(UserHelper.getUserListBySet((Set)adminUserIdSet, (String)langStr));
                    return new ObjectMapper().writeValueAsString((Object)do_);
                }
                LogAdminGroupPermSave pre = (LogAdminGroupPermSave)new ObjectMapper().readValue(preImg, LogAdminGroupPermSave.class);
                if (null == pre || CollectionUtils.isEmpty(pre.getAdmOrgUserList())) {
                    userList.addAll(UserHelper.getUserListBySet((Set)adminUserIdSet, (String)langStr));
                    return new ObjectMapper().writeValueAsString((Object)do_);
                }
                Set preUserSet = pre.getAdmOrgUserList().stream().map(User::getUserId).collect(Collectors.toSet());
                adminUserIdSet.addAll(preUserSet);
                userList.addAll(UserHelper.getUserListBySet((Set)adminUserIdSet, (String)langStr));
            }
            do_.setAffectUserList(userList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermAdminLogHelper.adminGroupPermSaveImage error, adminGroupId:{}, langStr:{}", new Object[]{adminGroupId, langStr, e});
            return e.getMessage();
        }
    }

    private static List<LogApp> getAppList(Long adminGroupId, String langStr) {
        final Map allCloudMap = AppHelper.getAllCloudMap();
        final Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
        StringBuilder sb = new StringBuilder("select fappid from t_perm_admingroupapp where fusergroupid = ? ");
        Object[] params = new Object[]{adminGroupId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogApp>>(){

            public List<LogApp> handle(ResultSet rs) throws Exception {
                ArrayList<LogApp> list = new ArrayList<LogApp>(8);
                LogApp one = null;
                String cloudId = "";
                String cloudName = "";
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    one = new LogApp();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName((String)allAppIdNameMap.get(appId));
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogAdmOrgUser> getAdmOrgUserList(Long adminGroupId, String langStr) {
        Set admOrgAddUserIds = AdminGroupHelper.getAdmOrgAddUserIds((Long)adminGroupId);
        if (CollectionUtils.isEmpty((Collection)admOrgAddUserIds)) {
            return new ArrayList<LogAdmOrgUser>(1);
        }
        List userList = UserHelper.getUserListBySet((Set)admOrgAddUserIds, (String)langStr);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return new ArrayList<LogAdmOrgUser>(1);
        }
        return userList.stream().map(x -> {
            LogAdmOrgUser user = new LogAdmOrgUser();
            user.setUserId(x.getFid());
            user.setTrueName(x.getFtruename());
            user.setUserNumber(x.getFusername());
            user.setUserName(x.getFusername());
            user.setPhone(x.getFphone());
            user.setEmail(x.getFemail());
            return user;
        }).collect(Collectors.toList());
    }

    private static List<LogAdmOrg> getAdmOrgList(Long adminGroupId, String langStr) {
        final Map orgMap = OrgHelper.getAllOrgMap();
        StringBuilder sb = new StringBuilder("select forgid from t_perm_admingrouporg where fusergroupid = ? ");
        Object[] params = new Object[]{adminGroupId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogAdmOrg>>(){

            public List<LogAdmOrg> handle(ResultSet rs) throws Exception {
                ArrayList<LogAdmOrg> list = new ArrayList<LogAdmOrg>(8);
                LogAdmOrg one = null;
                String admOrgNumber = "";
                String admOrgName = "";
                while (rs.next()) {
                    Long admOrgId = rs.getLong("forgid");
                    Org org = (Org)orgMap.get(admOrgId);
                    if (null != org) {
                        admOrgNumber = org.getOrgNumber();
                        admOrgName = org.getOrgName();
                    }
                    one = new LogAdmOrg(admOrgId, admOrgNumber, admOrgName);
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogBusiUnit> getBusiUnitList(Long adminGroupId, String langStr) {
        final Map orgMap = OrgHelper.getAllOrgMap();
        StringBuilder sb = new StringBuilder("select forgid from t_perm_admingroupbizunit where fusergroupid = ? ");
        Object[] params = new Object[]{adminGroupId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogBusiUnit>>(){

            public List<LogBusiUnit> handle(ResultSet rs) throws Exception {
                ArrayList<LogBusiUnit> list = new ArrayList<LogBusiUnit>(8);
                LogBusiUnit one = null;
                String busiUnitNumber = "";
                String busiUnitName = "";
                while (rs.next()) {
                    Long busiUnitId = rs.getLong("forgid");
                    Org org = (Org)orgMap.get(busiUnitId);
                    if (null != org) {
                        busiUnitNumber = org.getOrgNumber();
                        busiUnitName = org.getOrgName();
                    }
                    one = new LogBusiUnit(busiUnitId, busiUnitNumber, busiUnitName);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static List<LogFuncPerm> getFuncPermList(Long adminGroupId, String langStr) {
        if (null == adminGroupId || 0L == adminGroupId) {
            return new ArrayList<LogFuncPerm>(1);
        }
        final Map allCloudMap = AppHelper.getAllCloudMap();
        final Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
        final Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
        final Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
        StringBuilder sb = new StringBuilder("select fappid, fentitynum, fpermitemid from t_perm_admingroupfunperm where fusergroupid = ? ");
        Object[] params = new Object[]{adminGroupId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogFuncPerm>>(){

            public List<LogFuncPerm> handle(ResultSet rs) throws Exception {
                ArrayList<LogFuncPerm> list = new ArrayList<LogFuncPerm>(8);
                LogFuncPerm lfp = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String permItemName = "";
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    String entityId = rs.getString("fentitynum");
                    String permItemId = rs.getString("fpermitemid");
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = (String)allAppIdNameMap.get(appId);
                    entityName = (String)entityNameMap.get(entityId);
                    permItemName = (String)allPermitemMap.get(permItemId);
                    lfp = new LogFuncPerm();
                    lfp.setCloudId(cloudId);
                    lfp.setCloudName(cloudName);
                    lfp.setAppId(appId);
                    lfp.setAppName(appName);
                    lfp.setEntityId(entityId);
                    lfp.setEntityName(entityName);
                    lfp.setPermItemId(permItemId);
                    lfp.setPermItemName(permItemName);
                    list.add(lfp);
                }
                return list;
            }
        });
    }

    private static boolean existAdminGroup(Long adminGroupId) {
        StringBuilder sb = new StringBuilder("select fid from t_perm_admingroup where fid = ?");
        Object[] params = new Object[]{adminGroupId};
        Boolean aBoolean = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return aBoolean;
    }
}

