/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.log.model.LogBizRole;
import kd.bos.permission.log.model.LogBusiRoleAssignUser;
import kd.bos.permission.log.model.LogBusiRoleSave;
import kd.bos.permission.log.model.LogCommonRole;
import kd.bos.permission.log.model.LogDimRange;
import kd.bos.permission.log.model.LogPermBc;
import kd.bos.permission.log.model.LogPermDis;
import kd.bos.permission.log.model.LogUser;
import kd.bos.permission.log.model.common.User;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermBusiRoleLogHelper {
    private static Log log = LogFactory.getLog(PermBusiRoleLogHelper.class);

    @Deprecated
    public static String busiRoleEventImage(Long bizRoleId, String langStr, boolean isAfterImage) {
        LogBusiRoleSave do_ = new LogBusiRoleSave();
        try {
            if (null == bizRoleId || 0L == bizRoleId) {
                log.debug("PermBusiRoleLogHelper.busiRoleEventImage bizRoleId illegal, bizRoleId:{}, langStr:{}", (Object)bizRoleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List<LogCommonRole> commonRoleDiffList = PermBusiRoleLogHelper.getCommonRoleList(bizRoleId, langStr);
            List<LogPermBc> bcDiffList = PermBusiRoleLogHelper.getPermBcDiffList(bizRoleId, langStr);
            List<LogPermDis> forbidDiffList = PermBusiRoleLogHelper.getPermDisDiffList(bizRoleId, langStr);
            List<LogDimRange> orgRangeDiffList = PermBusiRoleLogHelper.getOrgDiffList(bizRoleId, langStr);
            List userList = new ArrayList(1);
            if (isAfterImage) {
                userList = PermBusiRoleHelper.getUserList((Long)bizRoleId, (String)langStr);
            }
            do_ = new LogBusiRoleSave(null, commonRoleDiffList, bcDiffList, forbidDiffList, orgRangeDiffList);
            do_.setAffectUserList(userList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermBusiRoleLogHelper.busiRoleEventImage error, bizRoleId:{}, langStr:{}", new Object[]{bizRoleId, langStr, e});
            return e.getMessage();
        }
    }

    public static Map<String, Object> busiRoleEventImage(Set<String> bizRoleIdSet, boolean isAfterImage, boolean queryFL) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        try {
            Map baseInfoMap = new HashMap(1);
            Map comRoleSetMap = new HashMap(1);
            Map dimObjSetMap = new HashMap(1);
            Map bcFuncPermSetMap = new HashMap(1);
            Map disFuncPermSetMap = new HashMap(1);
            Map roleUserIdSetMap = new HashMap(1);
            if (CollectionUtils.isEmpty(bizRoleIdSet)) {
                log.debug("PermBusiRoleLogHelper.busiRoleEventImage, bizRoleIdSet is empty, bizRoleIdSet:{}", bizRoleIdSet);
                return resultMap;
            }
            baseInfoMap = PermBusiRoleHelper.getBusiRoleBaseMap(bizRoleIdSet.stream().map(Long::valueOf).collect(Collectors.toSet()), null);
            if (queryFL) {
                comRoleSetMap = PermBusiRoleHelper.getComRoleSetMap(bizRoleIdSet, (String)"id");
                dimObjSetMap = PermBusiRoleHelper.getDimObjSetMap(bizRoleIdSet, (String)"id");
                bcFuncPermSetMap = PermBusiRoleHelper.getBcFuncPermSetMap(bizRoleIdSet, (String)"id");
                disFuncPermSetMap = PermBusiRoleHelper.getDisFuncPermSetMap(bizRoleIdSet, (String)"id");
            }
            if (isAfterImage) {
                roleUserIdSetMap = PermBusiRoleHelper.getUserIdSetMap(bizRoleIdSet, (String)"id");
            }
            HashMap map = null;
            for (String roleId : bizRoleIdSet) {
                map = new HashMap(8);
                map.put("baseInfoDB", baseInfoMap.get(Long.valueOf(roleId)));
                map.put("comRoleSetDB", comRoleSetMap.get(roleId));
                map.put("dimObjSetDB", dimObjSetMap.get(roleId));
                map.put("bcFuncPermSetDB", bcFuncPermSetMap.get(roleId));
                map.put("disFuncPermSetDB", disFuncPermSetMap.get(roleId));
                Set value = (Set)roleUserIdSetMap.get(roleId);
                HashSet roleUserIdSet = null == value || value.isEmpty() ? new HashSet(1) : value.stream().map(String::valueOf).collect(Collectors.toSet());
                map.put("roleUserIdSet", roleUserIdSet);
                resultMap.put(roleId, map);
            }
        }
        catch (Exception e) {
            log.warn("PermBusiRoleLogHelper.busiRoleEventImage error, bizRoleIdSet:{}", bizRoleIdSet, (Object)e);
        }
        return resultMap;
    }

    public static String busiRoleAssignUserImage(Long bizRoleId, String langStr, boolean isAfterImage, String preImg) {
        LogBusiRoleAssignUser do_ = new LogBusiRoleAssignUser();
        try {
            if (null == bizRoleId || 0L == bizRoleId) {
                log.debug("PermBusiRoleLogHelper.busiRoleAssignUserImage bizRoleId illegal, bizRoleId:{}, langStr:{}", (Object)bizRoleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            LogBizRole baseInfo = PermBusiRoleLogHelper.getRoleBaseInfo(bizRoleId, langStr);
            if (null == baseInfo) {
                log.debug("PermBusiRoleLogHelper.busiRoleAssignUserImage baseInfo is empty, bizRoleId:{}, langStr:{}", (Object)bizRoleId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List<LogUser> logUserList = PermBusiRoleLogHelper.getUsersByRoleId(bizRoleId, langStr);
            do_ = new LogBusiRoleAssignUser(baseInfo.getFnumber(), baseInfo.getFname(), logUserList);
            List affectUserList = do_.getAffectUserList();
            if (isAfterImage) {
                Set userIdSet = logUserList.stream().map(User::getUserId).collect(Collectors.toSet());
                if (StringUtils.isEmpty((String)preImg)) {
                    affectUserList.addAll(UserHelper.getUserListBySet(userIdSet, (String)langStr));
                    do_.setAffectUserList(affectUserList);
                    return new ObjectMapper().writeValueAsString((Object)do_);
                }
                LogBusiRoleAssignUser pre = (LogBusiRoleAssignUser)new ObjectMapper().readValue(preImg, LogBusiRoleAssignUser.class);
                if (null == pre || CollectionUtils.isEmpty(pre.getUserList())) {
                    affectUserList.addAll(UserHelper.getUserListBySet(userIdSet, (String)langStr));
                    do_.setAffectUserList(affectUserList);
                    return new ObjectMapper().writeValueAsString((Object)do_);
                }
                Set preUserSet = pre.getUserList().stream().map(User::getUserId).collect(Collectors.toSet());
                userIdSet.addAll(preUserSet);
                affectUserList.addAll(UserHelper.getUserListBySet(userIdSet, (String)langStr));
                do_.setAffectUserList(affectUserList);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            do_.setAffectUserList(affectUserList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermBusiRoleLogHelper.busiRoleAssignUserImage error, bizRoleId:{}, langStr:{}", new Object[]{bizRoleId, langStr, e});
            return e.getMessage();
        }
    }

    public static List<LogUser> getUsersByRoleId(Long bizRoleId, String langStr) {
        StringBuilder sql = new StringBuilder("select fuserid from t_perm_userbizrole where fbizroleid=?");
        Object[] params = new Object[]{bizRoleId};
        final HashSet userIdSet = new HashSet(8);
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    userIdSet.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new ArrayList<LogUser>(1);
        }
        List userList = UserHelper.getUserListBySet(userIdSet, (String)langStr);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return new ArrayList<LogUser>(1);
        }
        return userList.stream().map(x -> {
            LogUser logUser = new LogUser();
            logUser.setUserId(x.getFid());
            logUser.setTrueName(x.getFtruename());
            logUser.setUserNumber(x.getFusername());
            logUser.setUserName(x.getFusername());
            logUser.setPhone(x.getFphone());
            logUser.setEmail(x.getFemail());
            return logUser;
        }).collect(Collectors.toList());
    }

    public static List<LogCommonRole> getCommonRoleList(Long bizRoleId, String langStr) {
        StringBuilder sb = new StringBuilder("select a.froleid, b.fnumber, c.fname, a.fenable");
        sb.append(" from t_perm_bizrolecomrole a");
        sb.append(" inner join t_perm_role b on a.froleid  = b.fid");
        sb.append(" inner join t_perm_role_l c on a.froleid  = c.fid");
        sb.append(" where a.fid = ? and c.flocaleid = ? ");
        Object[] params = new Object[]{bizRoleId, langStr};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogCommonRole>>(){

            public List<LogCommonRole> handle(ResultSet rs) throws SQLException {
                ArrayList<LogCommonRole> list = new ArrayList<LogCommonRole>(8);
                LogCommonRole one = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String fnumber = rs.getString("fnumber");
                    String fname = rs.getString("fname");
                    String fenable = rs.getString("fenable");
                    String enableDesc = StringUtils.isEmpty((String)fenable) || "0".equals(fenable) ? ConstantsHelper.getDisable() : ConstantsHelper.getEnable();
                    one = new LogCommonRole(froleid, fnumber, fname, fenable, enableDesc);
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogPermBc> getPermBcDiffList(Long bizRoleId, String langStr) {
        final Map appCloudMap = AppHelper.getAllCloudMap();
        final Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        final Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
        final Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
        StringBuilder sb = new StringBuilder("select fbizappid, fentitytypeid, fpermitemid from t_perm_bizroleperm where fid = ? ");
        Object[] params = new Object[]{bizRoleId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogPermBc>>(){

            public List<LogPermBc> handle(ResultSet rs) throws SQLException {
                ArrayList<LogPermBc> list = new ArrayList<LogPermBc>(8);
                LogPermBc one = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String permItemName = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = (String)appIdNameMap.get(appId);
                    entityName = (String)entityNameMap.get(entityId);
                    permItemName = (String)allPermitemMap.get(permItemId);
                    one = new LogPermBc();
                    one.setPermItemId(permItemId);
                    one.setPermItemName(permItemName);
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogPermDis> getPermDisDiffList(Long bizRoleId, String langStr) {
        final Map appCloudMap = AppHelper.getAllCloudMap();
        final Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        final Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
        final Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
        StringBuilder sb = new StringBuilder("select fbizappid, fentitytypeid, fpermitemid from t_perm_bizroledisperm where fid = ? ");
        Object[] params = new Object[]{bizRoleId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogPermDis>>(){

            public List<LogPermDis> handle(ResultSet rs) throws SQLException {
                ArrayList<LogPermDis> list = new ArrayList<LogPermDis>(8);
                LogPermDis lpd = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String permItemName = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = (String)appIdNameMap.get(appId);
                    entityName = (String)entityNameMap.get(entityId);
                    permItemName = (String)allPermitemMap.get(permItemId);
                    lpd = new LogPermDis();
                    lpd.setCloudId(cloudId);
                    lpd.setCloudName(cloudName);
                    lpd.setAppId(appId);
                    lpd.setAppName(appName);
                    lpd.setEntityId(entityId);
                    lpd.setEntityName(entityName);
                    lpd.setPermItemId(permItemId);
                    lpd.setPermItemName(permItemName);
                    list.add(lpd);
                }
                return list;
            }
        });
    }

    public static List<LogDimRange> getOrgDiffList(Long bizRoleId, String langStr) {
        StringBuilder sb = new StringBuilder("select forgid, fisincludesuborg, fdimtype from t_perm_bizroleorg where fid = ? ");
        Object[] params = new Object[]{bizRoleId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimRange>>(){

            public List<LogDimRange> handle(ResultSet rs) throws SQLException {
                ArrayList<LogDimRange> list = new ArrayList<LogDimRange>(8);
                LogDimRange one = null;
                String orgNumber = "";
                String orgName = "";
                while (rs.next()) {
                    Long forgid = rs.getLong("forgid");
                    String fisincludesuborg = rs.getString("fisincludesuborg");
                    String fdimtype = rs.getString("fdimtype");
                    String fisincludesuborgDesc = StringUtils.isEmpty((String)fisincludesuborg) ? "" : ("1".equals(fisincludesuborg) ? ConstantsHelper.getInclude() : ConstantsHelper.getNotInclude());
                    one = new LogDimRange(forgid, orgNumber, orgName, fisincludesuborg, fisincludesuborgDesc, fdimtype);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static LogBizRole getRoleBaseInfo(Long bizRoleId, String langStr) {
        StringBuilder sql = new StringBuilder("select a.fid, a.fmasterid, a.fnumber, a.fusertype, a.fstatus, a.fenable,");
        sql.append(" a.fcreatetime, a.fcreatorid, a.fmodifytime, a.fmodifierid, a.fdisablerid, a.fdisabledate, a.fname, a.fdescription");
        sql.append(" from t_perm_bizrole a ");
        sql.append(" inner join t_perm_bizrole_l b on a.fid = b.fid ");
        sql.append(" where a.fid = ? and b.flocaleid = ? ");
        Object[] queryParams = new Object[]{bizRoleId, langStr};
        return (LogBizRole)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<LogBizRole>(){

            public LogBizRole handle(ResultSet rs) throws SQLException {
                LogBizRole role = new LogBizRole();
                while (rs.next()) {
                    role.setFid(rs.getLong("fid"));
                    role.setFmasterid(rs.getLong("fmasterid"));
                    role.setFnumber(rs.getString("fnumber"));
                    role.setFusertype(rs.getString("fusertype"));
                    role.setFstatus(rs.getString("fstatus"));
                    role.setFenable(rs.getString("fenable"));
                    role.setFcreatetime(rs.getString("fcreatetime"));
                    role.setFcreatorid(rs.getLong("fcreatorid"));
                    role.setFmodifytime(rs.getString("fmodifytime"));
                    role.setFmodifierid(rs.getLong("fmodifierid"));
                    role.setFdisablerid(rs.getLong("fdisablerid"));
                    role.setFdisabledate(rs.getString("fdisabledate"));
                    role.setFname(rs.getString("fname"));
                    role.setFdescription(rs.getString("fdescription"));
                }
                return role;
            }
        });
    }
}

