/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.log.model.LogBusiRole;
import kd.bos.permission.log.model.LogCopyTarUser;
import kd.bos.permission.log.model.LogDimDis;
import kd.bos.permission.log.model.LogDimField;
import kd.bos.permission.log.model.LogDimFunc;
import kd.bos.permission.log.model.LogDimNewDr;
import kd.bos.permission.log.model.LogDimNewDrPr;
import kd.bos.permission.log.model.LogDimNewDrWrapper;
import kd.bos.permission.log.model.LogUserAsignBusiRole;
import kd.bos.permission.log.model.LogUserClearPermSave;
import kd.bos.permission.log.model.LogUserCopyPermSave;
import kd.bos.permission.model.DataRuleInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermDirectLogHelper {
    private static Log log = LogFactory.getLog(PermDirectLogHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_PermDirectLogHelper_Pool", (int)2);

    public static String userAssignBusiRoleSaveImage(Long userId, String langStr, boolean isAfterImage) {
        LogUserAsignBusiRole do_ = new LogUserAsignBusiRole();
        try {
            if (null == userId || 0L == userId) {
                log.debug("PermDirectLogHelper.userAssignBusiRoleSaveImage userId illegal, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            Map baseInfoMap = UserHelper.getUserInfoMapByIds((Set)Sets.newHashSet((Object[])new Long[]{userId}), (String)langStr);
            if (CollectionUtils.isEmpty((Map)baseInfoMap)) {
                log.debug("PermDirectLogHelper.userAssignBusiRoleSaveImage baseInfo is empty, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            User baseInfo = (User)baseInfoMap.get(userId);
            List<LogBusiRole> dimRoleList = PermDirectLogHelper.getBusiRoleList(userId, langStr);
            List<Object> userList = new ArrayList(1);
            if (isAfterImage) {
                userList = Collections.singletonList(baseInfo);
            }
            do_ = new LogUserAsignBusiRole(dimRoleList);
            do_.setAffectUserList(userList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermDirectLogHelper.userAssignBusiRoleSaveImage error, userId:{}, langStr:{}", new Object[]{userId, langStr, e});
            return e.getMessage();
        }
    }

    public static String copyPermSaveImage(Long userId, String langStr, boolean isAfterImage, List<Long> targetUserIds, boolean isCopyRole, boolean isCopyBizRole, boolean isCopyDisfunperm, boolean isCopyUserperm) {
        LogUserCopyPermSave do_ = new LogUserCopyPermSave();
        try {
            if (null == userId || 0L == userId) {
                log.debug("PermDirectLogHelper.copyPermSaveImage userId illegal, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            Map baseInfoMap = UserHelper.getUserInfoMapByIds((Set)Sets.newHashSet((Object[])new Long[]{userId}), (String)langStr);
            if (CollectionUtils.isEmpty((Map)baseInfoMap)) {
                log.debug("PermDirectLogHelper.copyPermSaveImage baseInfo is empty, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List userList = UserHelper.getUserListBySet(new HashSet<Long>(targetUserIds), (String)langStr);
            ArrayList<LogCopyTarUser> tarUserList = new ArrayList<LogCopyTarUser>(userList.size());
            userList.stream().forEach(x -> {
                LogCopyTarUser logCopyTarUser;
                if (isCopyRole) {
                    logCopyTarUser = new LogCopyTarUser();
                    logCopyTarUser.setUserId(x.getFid());
                    logCopyTarUser.setTrueName(x.getFtruename());
                    logCopyTarUser.setUserNumber(x.getFnumber());
                    logCopyTarUser.setUserName(x.getFusername());
                    logCopyTarUser.setOpDesc(ConstantsHelper.getCopyCommonRole());
                    tarUserList.add(logCopyTarUser);
                }
                if (isCopyBizRole) {
                    logCopyTarUser = new LogCopyTarUser();
                    logCopyTarUser.setUserId(x.getFid());
                    logCopyTarUser.setTrueName(x.getFtruename());
                    logCopyTarUser.setUserNumber(x.getFnumber());
                    logCopyTarUser.setUserName(x.getFusername());
                    logCopyTarUser.setOpDesc(ConstantsHelper.getCopyBusiRole());
                    tarUserList.add(logCopyTarUser);
                }
                if (isCopyDisfunperm) {
                    logCopyTarUser = new LogCopyTarUser();
                    logCopyTarUser.setUserId(x.getFid());
                    logCopyTarUser.setTrueName(x.getFtruename());
                    logCopyTarUser.setUserNumber(x.getFnumber());
                    logCopyTarUser.setUserName(x.getFusername());
                    logCopyTarUser.setOpDesc(ConstantsHelper.getCopyForbidPerm());
                    tarUserList.add(logCopyTarUser);
                }
                if (isCopyUserperm) {
                    logCopyTarUser = new LogCopyTarUser();
                    logCopyTarUser.setUserId(x.getFid());
                    logCopyTarUser.setTrueName(x.getFtruename());
                    logCopyTarUser.setUserNumber(x.getFnumber());
                    logCopyTarUser.setUserName(x.getFusername());
                    logCopyTarUser.setOpDesc(ConstantsHelper.getCopyDirectPerm());
                    tarUserList.add(logCopyTarUser);
                }
            });
            do_ = new LogUserCopyPermSave(tarUserList);
            do_.setAffectUserList(userList);
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermDirectLogHelper.copyPermSaveImage error, userId:{}, langStr:{}", new Object[]{userId, langStr, e});
            return e.getMessage();
        }
    }

    public static String clearPermSaveImage(Long userId, String langStr, boolean isAfterImage) {
        LogUserClearPermSave do_ = new LogUserClearPermSave();
        try {
            if (null == userId || 0L == userId) {
                log.debug("PermDirectLogHelper.clearPermSaveImage userId illegal, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            Map baseInfoMap = UserHelper.getUserInfoMapByIds((Set)Sets.newHashSet((Object[])new Long[]{userId}), (String)langStr);
            if (CollectionUtils.isEmpty((Map)baseInfoMap)) {
                log.debug("PermDirectLogHelper.clearPermSaveImage baseInfo is empty, userId:{}, langStr:{}", (Object)userId, (Object)langStr);
                return new ObjectMapper().writeValueAsString((Object)do_);
            }
            List affectUserList = do_.getAffectUserList();
            if (isAfterImage) {
                HashSet<Long> set = new HashSet<Long>(1);
                set.add(userId);
                affectUserList.addAll(UserHelper.getUserListBySet(set, (String)langStr));
            }
            return new ObjectMapper().writeValueAsString((Object)do_);
        }
        catch (Exception e) {
            log.warn("PermDirectLogHelper.clearPermSaveImage error, userId:{}, langStr:{}", new Object[]{userId, langStr, e});
            return e.getMessage();
        }
    }

    public static List<LogBusiRole> getBusiRoleList(Long userId, String langStr) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogBusiRole>(1);
        }
        StringBuilder sql = new StringBuilder("select b.fid, b.fnumber , b.fname , c.fname, a.fstarttime, a.fendtime ");
        sql.append(" from t_perm_userbizrole a ");
        sql.append(" left join t_perm_bizrole b on a.fbizroleid  = b.fid");
        sql.append(" left join t_perm_bizrole_l c on c.fid = b.fid and c.flocaleid = ?");
        sql.append(" where a.fuserid = ?");
        Object[] params = new Object[]{langStr, userId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogBusiRole>>(){

            public List<LogBusiRole> handle(ResultSet rs) throws SQLException {
                ArrayList<LogBusiRole> list = new ArrayList<LogBusiRole>(8);
                LogBusiRole one = null;
                while (rs.next()) {
                    one = new LogBusiRole();
                    one.setRoleNumber(rs.getString("fnumber"));
                    one.setBizRoleId(rs.getString("fid"));
                    String bName = rs.getString("fname");
                    String cName = rs.getString("fname");
                    one.setRoleName(StringUtils.isEmpty((String)cName) ? bName : cName);
                    String startTimeStr = rs.getString("fstarttime");
                    String endTimeStr = rs.getString("fendtime");
                    Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate((String)startTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                    Date endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                    one.setStarTime(startTime);
                    one.setEndTime(endTime);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static List<LogDimDis> getDimDisList(final Long userId, Set<Long> dimIdSet, String dimType, String langStr) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimDis>(1);
        }
        StringBuilder sb = new StringBuilder("select a.forgid, a.fdimtype, a.fpermitemid, a.fbizappid , a.fentitytypeid , a.fisincludesuborg, a.fid");
        sb.append(" from t_perm_disfunperm a");
        sb.append(" where a.fuserid = ? ");
        if (!CollectionUtils.isEmpty(dimIdSet)) {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.forgid in(").append(dimIdIdStr).append(')');
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sb.append(" and a.fdimtype = '").append(dimType).append('\'');
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimDis>>(){

            public List<LogDimDis> handle(ResultSet rs) throws SQLException {
                ArrayList<LogDimDis> list = new ArrayList<LogDimDis>(8);
                LogDimDis one = null;
                Long dimId = 0L;
                String includesuborg = "";
                String dimType = "";
                String fid = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    dimId = rs.getLong("forgid");
                    includesuborg = rs.getString("fisincludesuborg");
                    dimType = rs.getString("fdimtype");
                    fid = rs.getString("fid");
                    one = new LogDimDis();
                    one.setFid(fid);
                    one.setUserId(userId);
                    one.setDimId(dimId);
                    one.setIncludesuborg(includesuborg);
                    one.setDimType(dimType);
                    one.setPermItemId(permItemId);
                    one.setAppId(appId);
                    one.setEntityId(entityId);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static List<LogDimDis> getDimDisListMulti(final Long userId, Set<Long> dimIdSet, Map<String, String[]> dimTypeInfos, Map<String, String> dimInfoMap, String langStr) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimDis>(1);
        }
        StringBuilder sb = new StringBuilder("select a.forgid, a.fdimtype, a.fpermitemid, a.fbizappid , a.fentitytypeid , a.fisincludesuborg, a.fid");
        sb.append(" from t_perm_disfunperm a");
        sb.append(" where a.fuserid = ? ");
        if (!CollectionUtils.isEmpty(dimIdSet)) {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.forgid in(").append(dimIdIdStr).append(')');
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimDis>>(){

            public List<LogDimDis> handle(ResultSet rs) throws SQLException {
                ArrayList<LogDimDis> list = new ArrayList<LogDimDis>(8);
                LogDimDis one = null;
                Long dimId = 0L;
                String includesuborg = "";
                String dimType = "";
                String fid = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    dimType = rs.getString("fdimtype");
                    dimId = rs.getLong("forgid");
                    includesuborg = rs.getString("fisincludesuborg");
                    fid = rs.getString("fid");
                    one = new LogDimDis();
                    one.setFid(fid);
                    one.setUserId(userId);
                    one.setDimId(dimId);
                    one.setIncludesuborg(includesuborg);
                    one.setDimType(dimType);
                    one.setPermItemId(permItemId);
                    one.setAppId(appId);
                    one.setEntityId(entityId);
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogDimFunc> getFuncPermListDoMulti(final Long userId, Set<String> dimIdSet, Map<String, String[]> dimTypeInfos) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimFunc>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fdimtype, a.fdimid , a.fisincludesub, a.fbizappid , a.fentitytypeid , a.fpermitemid");
        sb.append(" from t_perm_userpermdetail a");
        sb.append(" where a.fuserid = ?");
        if (CollectionUtils.isEmpty(dimIdSet)) {
            sb.append(" and a.fdimid > 0");
        } else {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.fdimid in(").append(dimIdIdStr).append(')');
        }
        if (!CollectionUtils.isEmpty(dimTypeInfos)) {
            Set<String> dimTypeSet = dimTypeInfos.keySet();
            String dimTypeSbStr = String.join((CharSequence)"','", dimTypeSet);
            sb.append(" and a.fdimtype IN ('").append(dimTypeSbStr).append("') ");
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimFunc>>(){

            public List<LogDimFunc> handle(ResultSet rs) throws Exception {
                ArrayList<LogDimFunc> list = new ArrayList<LogDimFunc>(8);
                LogDimFunc one = null;
                String cloudId = "";
                Long dimId = 0L;
                String includesuborg = "";
                String dimType = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    dimId = rs.getLong("fdimid");
                    dimType = rs.getString("fdimtype");
                    includesuborg = rs.getString("fisincludesub");
                    one = new LogDimFunc();
                    one.setUserId(userId);
                    one.setCloudId(cloudId);
                    one.setAppId(appId);
                    one.setEntityId(entityId);
                    one.setPermItemId(permItemId);
                    one.setDimId(dimId);
                    one.setIncludesuborg(includesuborg);
                    one.setDimType(dimType);
                    list.add(one);
                }
                return list;
            }
        });
    }

    private static List<LogDimFunc> getFuncPermListDo(Long userId, Set<String> dimIdSet, String dimType, final Map<String, DynamicObject> allCloudMap, final Map<String, String> allAppIdNameMap, final Map<String, String> entityNameMap, final Map<String, String> allPermitemMap, final Map<Long, Dim> dimMap, final String dimTypeDesc, final String includeDesc, final String notIncludeDesc) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimFunc>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fdimtype, a.fdimid , a.fisincludesub, a.fbizappid , a.fentitytypeid , a.fpermitemid");
        sb.append(" from t_perm_userpermdetail a");
        sb.append(" where a.fuserid = ?");
        if (CollectionUtils.isEmpty(dimIdSet)) {
            sb.append(" and a.fdimid > 0");
        } else {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.fdimid in(").append(dimIdIdStr).append(')');
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sb.append(" and a.fdimtype = '").append(dimType).append('\'');
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimFunc>>(){

            public List<LogDimFunc> handle(ResultSet rs) throws Exception {
                ArrayList<LogDimFunc> list = new ArrayList<LogDimFunc>(8);
                LogDimFunc one = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String permItemName = "";
                Long dimId = 0L;
                String dimNumber = "";
                String dimName = "";
                String includesuborg = "";
                String includesuborgDesc = "";
                String dimType = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    appName = (String)allAppIdNameMap.get(appId);
                    entityName = (String)entityNameMap.get(entityId);
                    permItemName = (String)allPermitemMap.get(permItemId);
                    dimId = rs.getLong("fdimid");
                    Dim dim = (Dim)dimMap.get(dimId);
                    if (null != dim) {
                        dimNumber = dim.getDimNumber();
                        dimName = dim.getDimName();
                    }
                    includesuborgDesc = StringUtils.isEmpty((String)(includesuborg = rs.getString("fisincludesub"))) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                    dimType = rs.getString("fdimtype");
                    one = new LogDimFunc();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    one.setPermItemId(permItemId);
                    one.setPermItemName(permItemName);
                    one.setDimId(dimId);
                    one.setDimNumber(dimNumber);
                    one.setDimName(dimName);
                    one.setIncludesuborg(includesuborg);
                    one.setIncludesuborgDesc(includesuborgDesc);
                    one.setDimType(dimType);
                    one.setDimTypeDesc(dimTypeDesc);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static List<LogDimFunc> getFuncPermListMulti(final Long userId, Set<String> dimIdSet, final Map<String, String[]> dimTypeInfos) {
        try {
            if (null == userId || 0L == userId) {
                return new ArrayList<LogDimFunc>(1);
            }
            if (CollectionUtils.isEmpty(dimIdSet)) {
                return PermDirectLogHelper.getFuncPermListDoMulti(userId, dimIdSet, dimTypeInfos);
            }
            int m = SqlUtil.getBatchCount((Integer)4, (int)dimIdSet.size());
            List listAvg = ListUtil.averageAssign(new LinkedList<String>(dimIdSet), (int)m);
            int size = listAvg.size();
            ArrayList<Future> futureList = new ArrayList<Future>(size);
            final CountDownLatch countDownLatch = new CountDownLatch(size);
            for (int i = 0; i < size; ++i) {
                final List scheme = (List)listAvg.get(i);
                futureList.add(pool.submit((Callable)new Callable<List<LogDimFunc>>(){

                    @Override
                    public List<LogDimFunc> call() throws Exception {
                        try {
                            List list = PermDirectLogHelper.getFuncPermListDoMulti(userId, new HashSet(scheme), dimTypeInfos);
                            return list;
                        }
                        catch (Exception e) {
                            log.warn("PermDirectLogHelper.getFuncPermList.call error.", (Throwable)e);
                            throw new Exception(e);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                }));
            }
            countDownLatch.await();
            LinkedList<LogDimFunc> resultList = new LinkedList<LogDimFunc>();
            for (Future future : futureList) {
                resultList.addAll((Collection)future.get());
            }
            return resultList;
        }
        catch (Exception e) {
            log.warn("PermDirectLogHelper.getFuncPermList error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u76f4\u63a5\u6388\u6743\u7684\u529f\u80fd\u6743\u9650\u6811\uff0c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PermDirectLogHelper_0", (String)"bos-permission-log", (Object[])new Object[0]));
        }
    }

    public static List<LogDimFunc> getFuncPermList(final Long userId, Set<String> dimIdSet, final String dimType, final Map<String, DynamicObject> allCloudMap, final Map<String, String> allAppIdNameMap, final Map<String, String> entityNameMap, final Map<String, String> allPermitemMap, final Map<Long, Dim> dimMap, final String dimTypeDesc) {
        try {
            if (null == userId || 0L == userId) {
                return new ArrayList<LogDimFunc>(1);
            }
            final String includeDesc = ConstantsHelper.getInclude();
            final String notIncludeDesc = ConstantsHelper.getNotInclude();
            if (CollectionUtils.isEmpty(dimIdSet)) {
                return PermDirectLogHelper.getFuncPermListDo(userId, dimIdSet, dimType, allCloudMap, allAppIdNameMap, entityNameMap, allPermitemMap, dimMap, dimTypeDesc, includeDesc, notIncludeDesc);
            }
            int m = SqlUtil.getBatchCount((Integer)4, (int)dimIdSet.size());
            List listAvg = ListUtil.averageAssign(new LinkedList<String>(dimIdSet), (int)m);
            int size = listAvg.size();
            ArrayList<Future> futureList = new ArrayList<Future>(size);
            final CountDownLatch countDownLatch = new CountDownLatch(size);
            for (int i = 0; i < size; ++i) {
                final List scheme = (List)listAvg.get(i);
                futureList.add(pool.submit((Callable)new Callable<List<LogDimFunc>>(){

                    @Override
                    public List<LogDimFunc> call() throws Exception {
                        try {
                            List list = PermDirectLogHelper.getFuncPermListDo(userId, new HashSet(scheme), dimType, allCloudMap, allAppIdNameMap, entityNameMap, allPermitemMap, dimMap, dimTypeDesc, includeDesc, notIncludeDesc);
                            return list;
                        }
                        catch (Exception e) {
                            log.warn("PermDirectLogHelper.getFuncPermList.call error.", (Throwable)e);
                            throw new Exception(e);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                }));
            }
            countDownLatch.await();
            LinkedList<LogDimFunc> resultList = new LinkedList<LogDimFunc>();
            for (Future future : futureList) {
                resultList.addAll((Collection)future.get());
            }
            return resultList;
        }
        catch (Exception e) {
            log.warn("PermDirectLogHelper.getFuncPermList error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u76f4\u63a5\u6388\u6743\u7684\u529f\u80fd\u6743\u9650\u6811\uff0c\u53d1\u751f\u5f02\u5e38\u3002", (String)"PermDirectLogHelper_0", (String)"bos-permission-log", (Object[])new Object[0]));
        }
    }

    public static List<LogDimField> getFieldPermListMulti(Long userId, Set<String> dimIdSet, Map<String, String[]> dimTypeInfos) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimField>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select a.forgid, a.fdimtype, a.fisincludesuborg, b.fbizappid, b.fentitytypeid, b.ffieldname, b.fcontrolmode");
        sb.append(" from t_perm_userfieldperm a ");
        sb.append(" left join t_perm_fieldpermdetail b on a.ffieldpermid = b.fid");
        sb.append(" where a.fuserid = ?");
        if (CollectionUtils.isEmpty(dimIdSet)) {
            sb.append(" and a.forgid > 0");
        } else {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.forgid in(").append(dimIdIdStr).append(')');
        }
        if (!CollectionUtils.isEmpty(dimTypeInfos)) {
            Set<String> dimTypeSet = dimTypeInfos.keySet();
            String dimTypeSbStr = String.join((CharSequence)"','", dimTypeSet);
            sb.append(" and a.fdimtype IN ('").append(dimTypeSbStr).append("') ");
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimField>>(){

            public List<LogDimField> handle(ResultSet rs) throws Exception {
                ArrayList<LogDimField> list = new ArrayList<LogDimField>(8);
                LogDimField one = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String fieldComment = "";
                String controlModeDesc = "";
                Long dimId = 0L;
                String dimNumber = "";
                String dimName = "";
                String includesuborg = "";
                String includesuborgDesc = "";
                String dimType = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String ffieldname = rs.getString("ffieldname");
                    String fcontrolmode = rs.getString("fcontrolmode");
                    dimId = rs.getLong("forgid");
                    dimType = rs.getString("fdimtype");
                    includesuborg = rs.getString("fisincludesuborg");
                    one = new LogDimField();
                    one.setCloudId(cloudId);
                    one.setCloudName(cloudName);
                    one.setAppId(appId);
                    one.setAppName(appName);
                    one.setEntityId(entityId);
                    one.setEntityName(entityName);
                    one.setFieldName(ffieldname);
                    one.setFieldComment(fieldComment);
                    one.setControlMode(fcontrolmode);
                    one.setControlModeDesc(controlModeDesc);
                    one.setDimId(dimId);
                    one.setDimNumber(dimNumber);
                    one.setDimName(dimName);
                    one.setIncludesuborg(includesuborg);
                    one.setIncludesuborgDesc(includesuborgDesc);
                    one.setDimType(dimType);
                    list.add(one);
                }
                return list;
            }
        });
    }

    public static List<LogDimField> getFieldPermList(Long userId, Set<String> dimIdSet, String dimType, Map<String, DynamicObject> allCloudMap, Map<String, String> allAppIdNameMap, Map<String, String> entityNameMap, final Map<Long, Dim> dimMap, final String dimTypeDesc) {
        if (null == userId || 0L == userId) {
            return new ArrayList<LogDimField>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select a.forgid, a.fdimtype, a.fisincludesuborg, b.fbizappid, b.fentitytypeid, b.ffieldname, b.fcontrolmode");
        sb.append(" from t_perm_userfieldperm a ");
        sb.append(" left join t_perm_fieldpermdetail b on a.ffieldpermid = b.fid");
        sb.append(" where a.fuserid = ?");
        if (CollectionUtils.isEmpty(dimIdSet)) {
            sb.append(" and a.forgid > 0");
        } else {
            List dimIdList = dimIdSet.parallelStream().map(String::valueOf).collect(Collectors.toList());
            String dimIdIdStr = String.join((CharSequence)",", dimIdList);
            sb.append(" and a.forgid in(").append(dimIdIdStr).append(')');
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sb.append(" and a.fdimtype = '").append(dimType).append('\'');
        }
        Object[] params = new Object[]{userId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<LogDimField>>(){

            public List<LogDimField> handle(ResultSet rs) throws Exception {
                ArrayList<LogDimField> list = new ArrayList<LogDimField>(8);
                LogDimField one = null;
                String cloudId = "";
                String cloudName = "";
                String appName = "";
                String entityName = "";
                String fieldComment = "";
                String controlModeDesc = "";
                Long dimId = 0L;
                String dimNumber = "";
                String dimName = "";
                String includesuborg = "";
                String includesuborgDesc = "";
                String dimType = "";
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityId = rs.getString("fentitytypeid");
                    String ffieldname = rs.getString("ffieldname");
                    String fcontrolmode = rs.getString("fcontrolmode");
                    controlModeDesc = ConstantsHelper.getControlModelDesc((String)fcontrolmode);
                    dimId = rs.getLong("forgid");
                    Dim dim = (Dim)dimMap.get(dimId);
                    if (null != dim) {
                        dimNumber = dim.getDimNumber();
                        dimName = dim.getDimName();
                    }
                    includesuborgDesc = StringUtils.isEmpty((String)(includesuborg = rs.getString("fisincludesuborg"))) ? "" : ("1".equals(includesuborg) ? ConstantsHelper.getInclude() : ConstantsHelper.getNotInclude());
                    dimType = rs.getString("fdimtype");
                    one = new LogDimField();
                    one.setCloudId(cloudId);
                    one.setAppId(appId);
                    one.setEntityId(entityId);
                    one.setFieldName(ffieldname);
                    one.setControlMode(fcontrolmode);
                    one.setDimId(dimId);
                    one.setIncludesuborg(includesuborg);
                    one.setDimType(dimType);
                    one.setDimTypeDesc(dimTypeDesc);
                    list.add(one);
                }
                return list;
            }
        });
    }

    @Deprecated
    public static LogDimNewDrWrapper getNewDataRule(Long userId, String langStr, Map<String, String> allAppIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermitemMap, Map<Long, Dim> dimMap, String dimTypeDesc) {
        LogDimNewDrWrapper wrapper = new LogDimNewDrWrapper();
        if (null == userId || 0L == userId) {
            return wrapper;
        }
        StringBuilder sql = new StringBuilder("select fdatarulesid from t_perm_userdatarules where fuserid = ?");
        Object[] params = new Object[]{userId};
        Long fdatarulesid = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong("fdatarulesid");
                }
                return 0L;
            }
        });
        if (0L == fdatarulesid) {
            return wrapper;
        }
        DynamicObject dataRulesObj = BusinessDataServiceHelper.loadSingle((Object)fdatarulesid, (String)"perm_datarules", (String)"id,bizapp,entity,datarule,modifier,modifytime,creator,createtime,number,name");
        DynamicObjectCollection entryc = dataRulesObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryc)) {
            return wrapper;
        }
        Set appIdsSet = entryc.stream().map(rowObj -> rowObj.getString("bizapp_id")).collect(Collectors.toSet());
        Map appCloudMap = AppHelper.getCloudMap(new ArrayList(appIdsSet));
        String cloudId = "";
        String cloudName = "";
        for (DynamicObject rowObj2 : entryc) {
            List bdPropsDataRule;
            StringBuilder processInfo;
            Long dataRuleId;
            Object[] queryDataRule;
            String appId = rowObj2.getString("bizapp_id");
            String appName = allAppIdNameMap.get(appId);
            String entityId = rowObj2.getString("entity_id");
            String entityName = rowObj2.getString("entity.name");
            DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
            if (null != cloudObj) {
                cloudId = cloudObj.getString("bizcloud.id");
                cloudName = cloudObj.getString("bizcloud.name");
            }
            if (!ArrayUtils.isNotEmpty((Object[])(queryDataRule = DataRuleCache.queryDataRule((QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(dataRuleId = Long.valueOf(rowObj2.getLong("datarule_id"))))}, (StringBuilder)(processInfo = new StringBuilder()))))) continue;
            List<Object> rList = CollectionUtils.isEmpty(wrapper.getRuleList()) ? new ArrayList(1) : wrapper.getRuleList();
            Object dataRuleInfo = queryDataRule[0];
            List permItemsDataRule = dataRuleInfo.getPermItemsDataRule();
            if (!CollectionUtils.isEmpty((Collection)permItemsDataRule)) {
                ArrayList<LogDimNewDr> ruleList = new ArrayList<LogDimNewDr>(permItemsDataRule.size());
                LogDimNewDr newDataRule = null;
                for (DataRuleInfo.PermItemsDataRule dataRule : permItemsDataRule) {
                    DataRuleInfo rule = dataRule.getDataRule();
                    String permItemId = dataRule.getPermItemId();
                    Long id = rule.getId();
                    String name = rule.getName().getLocaleValue();
                    newDataRule = new LogDimNewDr();
                    newDataRule.setCloudId(cloudId);
                    newDataRule.setCloudName(cloudName);
                    newDataRule.setAppId(appId);
                    newDataRule.setAppName(appName);
                    newDataRule.setEntityId(entityId);
                    newDataRule.setEntityName(entityName);
                    newDataRule.setPermItemId(permItemId);
                    newDataRule.setPermItemName(allPermitemMap.get(permItemId));
                    newDataRule.setDataRuleId(id);
                    newDataRule.setDataRuleName(name);
                    ruleList.add(newDataRule);
                }
                rList.addAll(ruleList);
                wrapper.setRuleList(rList);
            }
            if (CollectionUtils.isEmpty((Collection)(bdPropsDataRule = dataRuleInfo.getBdPropsDataRule()))) continue;
            List<Object> pList = CollectionUtils.isEmpty(wrapper.getPropList()) ? new ArrayList(1) : wrapper.getPropList();
            ArrayList<LogDimNewDrPr> propList = new ArrayList<LogDimNewDrPr>(bdPropsDataRule.size());
            HashMap hasLoadMap = new HashMap(8);
            LogDimNewDrPr newDataRuleProp = null;
            for (DataRuleInfo.BdPropsDataRule prop : bdPropsDataRule) {
                String propKey = prop.getPropKey();
                String propName = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, (String)entityId, (String)propKey);
                String propEntNum = prop.getPropEntNum();
                DataRuleInfo rule = prop.getDataRule();
                Long id = rule.getId();
                String name = rule.getName().getLocaleValue();
                String propEntName = entityNameMap.get(propEntNum);
                newDataRuleProp = new LogDimNewDrPr();
                newDataRuleProp.setCloudId(cloudId);
                newDataRuleProp.setCloudName(cloudName);
                newDataRuleProp.setAppId(appId);
                newDataRuleProp.setAppName(appName);
                newDataRuleProp.setEntityId(entityId);
                newDataRuleProp.setEntityName(entityName);
                newDataRuleProp.setPropKey(propKey);
                newDataRuleProp.setPropName(propName);
                newDataRuleProp.setPropEntNum(StringUtils.isEmpty((String)propEntNum) ? "" : propEntNum);
                newDataRuleProp.setPropEntName(propEntName);
                newDataRuleProp.setDataRuleId(id);
                newDataRuleProp.setDataRuleName(name);
                propList.add(newDataRuleProp);
            }
            pList.addAll(propList);
            wrapper.setPropList(pList);
        }
        return wrapper;
    }
}

