/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.log.model.LogFieldPerm;
import kd.bos.permission.log.model.LogFuncPerm;
import kd.bos.permission.log.model.LogNewDataRule;
import kd.bos.permission.log.model.LogNewDataRuleProp;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.LogOldDataRule;
import kd.bos.permission.log.model.LogRole;
import kd.bos.permission.log.model.common.Entity;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermRoleLogHelper {
    private static Log log = LogFactory.getLog(PermRoleLogHelper.class);

    public static Map<String, Object> commRoleEventImage(Set<String> roleIdSet, boolean isAfterImage, boolean queryFL) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        try {
            Map baseInfoMap = new HashMap(1);
            Map funcPermSetDBMap = new HashMap(1);
            Map fieldPermSetDBMap = new HashMap(1);
            Map fpsSetDBMap = new HashMap(1);
            Map newDrPermSetDBMap = new HashMap(1);
            Map newDrPrPermSetDBMap = new HashMap(1);
            Map comRoleAdminGrpSetDBMap = new HashMap(1);
            Map roleUserIdSetMap = new HashMap(1);
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                log.debug("PermRoleLogHelper.commRoleEventImage roleIdSet is empty, roleIdSet:{}", roleIdSet);
                return resultMap;
            }
            baseInfoMap = PermRoleHelper.getComRoleBaseMap(roleIdSet, null);
            if (queryFL) {
                funcPermSetDBMap = PermRoleHelper.getRoleFuncPermSetMap(roleIdSet, null);
                fieldPermSetDBMap = PermRoleHelper.getFieldPermSetMap(roleIdSet, null);
                fpsSetDBMap = PermRoleHelper.getFpsSetMap(roleIdSet);
                newDrPermSetDBMap = PermRoleHelper.getNewDrPermSetMap(roleIdSet, null);
                newDrPrPermSetDBMap = PermRoleHelper.getNewDrPrPermSetMap(roleIdSet, null);
                comRoleAdminGrpSetDBMap = PermRoleHelper.getComRoleAdminGrpSetMap(roleIdSet, null);
            }
            if (isAfterImage) {
                roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(roleIdSet);
            }
            HashMap map = null;
            for (String roleId : roleIdSet) {
                map = new HashMap(8);
                map.put("baseInfoDB", baseInfoMap.get(roleId));
                map.put("funcPermSetDB", funcPermSetDBMap.get(roleId));
                map.put("fieldPermSetDB", fieldPermSetDBMap.get(roleId));
                map.put("fpsSetDB", fpsSetDBMap.get(roleId));
                map.put("newDrPermSetDB", newDrPermSetDBMap.get(roleId));
                map.put("newDrPrPermSetDB", newDrPrPermSetDBMap.get(roleId));
                map.put("comRoleAdminGrpSetDB", comRoleAdminGrpSetDBMap.get(roleId));
                Set value = (Set)roleUserIdSetMap.get(roleId);
                HashSet roleUserIdSet = null == value || value.isEmpty() ? new HashSet(1) : value.stream().map(String::valueOf).collect(Collectors.toSet());
                map.put("roleUserIdSet", roleUserIdSet);
                resultMap.put(roleId, map);
            }
        }
        catch (Exception e) {
            log.warn("PermRoleLogHelper.commRoleEventImage error, roleIdSet:{}", roleIdSet, (Object)e);
        }
        return resultMap;
    }

    public static LogRole getRoleBaseInfo(String roleId, String langStr) {
        StringBuilder sql = new StringBuilder("select a.fid, a.ftype, a.fnumber, a.flongnumber, a.fparentroleid, a.fbizdomainid, a.frolegroupid, ");
        sql.append(" a.fcreatetime, a.fcreatorid, a.fmodifytime, a.fmodifierid, a.fstatus, a.fenable, ");
        sql.append(" a.fgroupid, a.fdisablerid, a.fdisabledate, a.fmasterid, a.fissystem, a.fremark, a.fdimtypeid, b.fname ");
        sql.append(" from t_perm_role a ");
        sql.append(" inner join t_perm_role_l b on a.fid = b.fid ");
        sql.append(" where a.fid = ? and b.flocaleid = ? ");
        Object[] queryParams = new Object[]{roleId, langStr};
        return (LogRole)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])queryParams, (ResultSetHandler)new ResultSetHandler<LogRole>(){

            public LogRole handle(ResultSet rs) throws SQLException {
                LogRole role = new LogRole();
                while (rs.next()) {
                    role.setFid(rs.getString("fid"));
                    role.setFtype(rs.getString("ftype"));
                    role.setFnumber(rs.getString("fnumber"));
                    role.setFlongnumber(rs.getString("flongnumber"));
                    role.setFparentroleid(rs.getString("fparentroleid"));
                    role.setFbizdomainid(rs.getString("fbizdomainid"));
                    role.setFrolegroupid(rs.getString("frolegroupid"));
                    role.setFcreatetime(rs.getString("fcreatetime"));
                    role.setFcreatorid(rs.getLong("fcreatorid"));
                    role.setFmodifytime(rs.getString("fmodifytime"));
                    role.setFmodifierid(rs.getLong("fmodifierid"));
                    role.setFstatus(rs.getString("fstatus"));
                    role.setFenable(rs.getString("fenable"));
                    role.setFgroupid(rs.getString("fgroupid"));
                    role.setFdisablerid(rs.getLong("fdisablerid"));
                    role.setFdisabledate(rs.getString("fdisabledate"));
                    role.setFmasterid(rs.getString("fmasterid"));
                    role.setFissystem(rs.getString("fissystem"));
                    role.setFremark(rs.getString("fremark"));
                    role.setFname(rs.getString("fname"));
                    role.setFdimtypeid(rs.getString("fdimtypeid"));
                }
                return role;
            }
        });
    }

    public static List<LogFuncPerm> getFuncPermList(String roleId, String langStr) {
        if (StringUtils.isEmpty((String)roleId)) {
            return new ArrayList<LogFuncPerm>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fbizappid, fentitytypeid, fpermitemid ");
        sb.append(" from t_perm_rolepermdetial ");
        sb.append(" where froleid = ? ");
        final ArrayList<LogFuncPerm> list = new ArrayList<LogFuncPerm>(128);
        Object[] params = new Object[]{roleId};
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                LogFuncPerm logFuncPerm = null;
                while (rs.next()) {
                    logFuncPerm = new LogFuncPerm();
                    logFuncPerm.setAppId(rs.getString("fbizappid"));
                    logFuncPerm.setEntityId(rs.getString("fentitytypeid"));
                    logFuncPerm.setPermItemId(rs.getString("fpermitemid"));
                    list.add(logFuncPerm);
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<LogFuncPerm>(1);
        }
        Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
        Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        Set entityIdSet = list.stream().map(Entity::getEntityId).collect(Collectors.toSet());
        Map entityNameMap = FormHelper.getEntityNameMap(new ArrayList(entityIdSet), (String)langStr);
        Set appIdSet = list.stream().map(kd.bos.permission.log.model.common.App::getAppId).collect(Collectors.toSet());
        Map cloudMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
        list.forEach(one -> {
            String appId = one.getAppId();
            DynamicObject cloud = (DynamicObject)cloudMap.get(appId);
            if (null != cloud) {
                one.setCloudId(cloud.getString("bizcloud.id"));
                one.setCloudName(cloud.getString("bizcloud.name"));
            }
            String newAppId = (String)extAppAndOrgnlAppRel.get(appId);
            one.setAppName((String)appIdNameMap.get(newAppId));
            String entityId = one.getEntityId();
            one.setEntityName((String)entityNameMap.get(entityId));
            String permItemId = one.getPermItemId();
            one.setPermItemName((String)allPermitemMap.get(permItemId));
        });
        return list;
    }

    public static List<LogFieldPerm> getFieldPermList(String roleId, String langStr) {
        if (StringUtils.isEmpty((String)roleId)) {
            return new ArrayList<LogFieldPerm>(1);
        }
        String selFields = "fieldperm.fieldrule.entitytype" + ',' + "fieldperm.fieldrule.bizapp";
        DynamicObject[] arrDObj = BusinessDataServiceHelper.load((String)"perm_rolefieldperm", (String)selFields, (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        if (null == arrDObj || arrDObj.length == 0) {
            return new ArrayList<LogFieldPerm>(1);
        }
        DynamicObject dObj = arrDObj[0];
        DynamicObjectCollection doc = dObj.getDynamicObjectCollection("fieldperm.fieldrule");
        if (null == doc) {
            return new ArrayList<LogFieldPerm>(1);
        }
        Set appIdsSet = doc.stream().map(fieldRow -> fieldRow.getString("bizapp.id")).collect(Collectors.toSet());
        Map appCloudMap = AppHelper.getCloudMap(new ArrayList(appIdsSet));
        Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        int size = doc.size();
        ArrayList<LogFieldPerm> list = new ArrayList<LogFieldPerm>(size);
        LogFieldPerm filedPerm = null;
        String cloudId = "";
        String cloudName = "";
        HashMap hasLoadMap = new HashMap(size);
        for (DynamicObject fieldRow2 : doc) {
            String appId = fieldRow2.getString("bizapp.id");
            String appName = (String)appIdNameMap.get(appId);
            String entityId = fieldRow2.getString("entitytype.id");
            String entityName = fieldRow2.getString("entitytype.name");
            String filedName = fieldRow2.getString("fieldname");
            String filedComment = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, (String)entityId, (String)filedName);
            String controlMode = fieldRow2.getString("rowcondition");
            DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
            if (null != cloudObj) {
                cloudId = cloudObj.getString("bizcloud.id");
                cloudName = cloudObj.getString("bizcloud.name");
            }
            filedPerm = new LogFieldPerm();
            filedPerm.setCloudId(cloudId);
            filedPerm.setCloudName(cloudName);
            filedPerm.setAppId(appId);
            filedPerm.setAppName(appName);
            filedPerm.setEntityId(entityId);
            filedPerm.setEntityName(entityName);
            filedPerm.setFieldName(filedName);
            filedPerm.setFieldComment(filedComment);
            filedPerm.setControlMode(controlMode);
            filedPerm.setControlModeDesc(ConstantsHelper.getControlModelDesc((String)controlMode));
            list.add(filedPerm);
        }
        return list;
    }

    public static List<LogOldDataRule> getOldDataRuleList(String roleId, String langStr) {
        if (StringUtils.isEmpty((String)roleId)) {
            return new ArrayList<LogOldDataRule>(1);
        }
        StringBuilder sbSelFields = new StringBuilder("datapermid");
        DynamicObject[] arrRoleDataPerm = BusinessDataServiceHelper.load((String)"perm_roledataperm", (String)sbSelFields.toString(), (QFilter[])new QFilter[]{new QFilter("role.id", "=", (Object)roleId)});
        if (arrRoleDataPerm == null || arrRoleDataPerm.length == 0 || arrRoleDataPerm[0] == null) {
            return new ArrayList<LogOldDataRule>(1);
        }
        int arrRoleDataPermSize = arrRoleDataPerm.length;
        ArrayList<String> dataPermIds = new ArrayList<String>(arrRoleDataPermSize);
        for (DynamicObject userDataPerm : arrRoleDataPerm) {
            String dataPermId = userDataPerm.getString("datapermid.id");
            dataPermIds.add(dataPermId);
        }
        StringBuilder sbSelDataPermFields = new StringBuilder("entitytypelist.entitytype").append(", ").append("entitytypelist.bizapp").append(", ").append("entitytypelist.rule");
        DynamicObject[] arrDataPerm = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)sbSelDataPermFields.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", dataPermIds)});
        if (arrDataPerm == null || arrDataPerm.length == 0 || arrDataPerm[0] == null) {
            return new ArrayList<LogOldDataRule>(1);
        }
        DynamicObject dataPerm = arrDataPerm[0];
        DynamicObjectCollection dataPermEntry = dataPerm.getDynamicObjectCollection("entitytypelist");
        if (dataPermEntry == null || dataPermEntry.size() == 0) {
            return new ArrayList<LogOldDataRule>(1);
        }
        Set appIdsSet = dataPermEntry.stream().map(dyo -> dyo.getString("bizapp.id")).collect(Collectors.toSet());
        Map appCloudMap = AppHelper.getCloudMap(new ArrayList(appIdsSet));
        Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        ArrayList<LogOldDataRule> list = new ArrayList<LogOldDataRule>(dataPermEntry.size());
        LogOldDataRule obj = null;
        String cloudId = "";
        String cloudName = "";
        for (DynamicObject dyo2 : dataPermEntry) {
            String appId = dyo2.getString("bizapp.id");
            String appName = (String)appIdNameMap.get(appId);
            String entityId = dyo2.getString("entitytype.id");
            String entityName = dyo2.getString("entitytype.name");
            String rule = dyo2.getString("rule");
            DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
            if (null != cloudObj) {
                cloudId = cloudObj.getString("bizcloud.id");
                cloudName = cloudObj.getString("bizcloud.name");
            }
            obj = new LogOldDataRule();
            obj.setRule(rule);
            obj.setCloudId(cloudId);
            obj.setCloudName(cloudName);
            obj.setAppId(appId);
            obj.setAppName(appName);
            obj.setEntityId(entityId);
            obj.setEntityName(entityName);
            list.add(obj);
        }
        return list;
    }

    public static LogNewDataRuleWrapper getNewDataRule(String roleId, String langStr) {
        Set newDrPrPerms;
        LogNewDataRuleWrapper wrapper = new LogNewDataRuleWrapper();
        if (StringUtils.isEmpty((String)roleId)) {
            return wrapper;
        }
        HashSet<String> roleIdSet = new HashSet<String>(1);
        roleIdSet.add(roleId);
        Map newDrPermSetDBMap = PermRoleHelper.getNewDrPermSetMap(roleIdSet, null);
        Set newDrPerms = null == newDrPermSetDBMap.get(roleId) ? new HashSet(0) : (Set)newDrPermSetDBMap.get(roleId);
        Map newDrPrPermSetDBMap = PermRoleHelper.getNewDrPrPermSetMap(roleIdSet, null);
        Set set = newDrPrPerms = null == newDrPrPermSetDBMap.get(roleId) ? new HashSet(0) : (Set)newDrPrPermSetDBMap.get(roleId);
        if (newDrPerms.isEmpty() && newDrPrPerms.isEmpty()) {
            return wrapper;
        }
        Set appIdsSet = newDrPerms.stream().map(App::getAppId).collect(Collectors.toSet());
        Set appIdsSet2 = newDrPrPerms.stream().map(App::getAppId).collect(Collectors.toSet());
        appIdsSet.addAll(appIdsSet2);
        Map appCloudMap = AppHelper.getCloudMap(new ArrayList(appIdsSet));
        Map appIdNameMap = AppHelper.getAllAppIdNameMap();
        Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
        String cloudId = "";
        String cloudName = "";
        Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
        ArrayList<LogNewDataRule> rList = new ArrayList<LogNewDataRule>(10);
        if (!CollectionUtils.isEmpty(newDrPerms)) {
            ArrayList<LogNewDataRule> ruleList = new ArrayList<LogNewDataRule>(newDrPerms.size());
            LogNewDataRule newDataRule = null;
            for (NewDrPerm one : newDrPerms) {
                String appId = one.getAppId();
                String appName = (String)appIdNameMap.get(appId);
                String entityId = one.getEntityNumber();
                String entityName = one.getEntityName();
                DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                String permItemId = one.getPermItemId();
                Long dataRuleId = one.getDataRuleId();
                String dataRuleName = one.getDataRuleName();
                newDataRule = new LogNewDataRule();
                newDataRule.setDataRuleId(dataRuleId);
                newDataRule.setDataRuleName(dataRuleName);
                newDataRule.setCloudId(cloudId);
                newDataRule.setCloudName(cloudName);
                newDataRule.setAppId(appId);
                newDataRule.setAppName(appName);
                newDataRule.setEntityId(entityId);
                newDataRule.setEntityName(entityName);
                newDataRule.setPermItemId(permItemId);
                newDataRule.setPermItemName((String)allPermitemMap.get(permItemId));
                ruleList.add(newDataRule);
            }
            rList.addAll(ruleList);
            wrapper.setRuleList(rList);
        }
        if (!CollectionUtils.isEmpty(newDrPrPerms)) {
            ArrayList<LogNewDataRuleProp> propList = new ArrayList<LogNewDataRuleProp>(newDrPrPerms.size());
            HashMap hasLoadMap = new HashMap(8);
            LogNewDataRuleProp newDataRuleProp = null;
            for (NewDrPrPerm one : newDrPrPerms) {
                String appId = one.getAppId();
                String appName = (String)appIdNameMap.get(appId);
                String entityId = one.getEntityNumber();
                String entityName = one.getEntityName();
                DynamicObject cloudObj = (DynamicObject)appCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                String propKey = one.getPropKey();
                String propName = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, (String)entityId, (String)propKey);
                String propEntNum = one.getPropEntNum();
                Long dataRuleId = one.getDataRuleId();
                String dataRuleName = one.getDataRuleName();
                String propEntName = (String)entityNameMap.get(propEntNum);
                newDataRuleProp = new LogNewDataRuleProp();
                newDataRuleProp.setCloudId(cloudId);
                newDataRuleProp.setCloudName(cloudName);
                newDataRuleProp.setAppId(appId);
                newDataRuleProp.setAppName(appName);
                newDataRuleProp.setEntityId(entityId);
                newDataRuleProp.setEntityName(entityName);
                newDataRuleProp.setPropKey(propKey);
                newDataRuleProp.setPropName(propName);
                newDataRuleProp.setPropEntNum(StringUtils.isEmpty((String)propEntNum) ? "" : propEntNum);
                newDataRuleProp.setPropEntName(propEntName);
                newDataRuleProp.setDataRuleId(dataRuleId);
                newDataRuleProp.setDataRuleName(dataRuleName);
                propList.add(newDataRuleProp);
            }
            wrapper.setPropList(propList);
        }
        return wrapper;
    }
}

