/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermMessage;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.model.common.DimPermItem;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class LogDimDis
extends DimPermItem
implements Serializable {
    private static final long serialVersionUID = 2274474876034747419L;
    private static final Log log = LogFactory.getLog(LogDimDis.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_LogDimDis_Pool", (int)1);
    private String fid;
    private Long userId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogDimDis logDimDis = (LogDimDis)o;
        return Objects.equals(this.userId, logDimDis.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId);
    }

    public static Map<String, Object> logCompareMutiThread(List<LogDimDis> preList, List<LogDimDis> afterList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", new LinkedList());
        map.put("add", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (LogDimDis one : preList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (LogDimDis one : afterList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("del");
            List add = (List)map.get("add");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set dimIdSet = (Set)dimTypeDimIdSet.getValue();
                Iterator iterator = dimIdSet.iterator();
                int i = 0;
                int oneThreadDeal = 1;
                ArrayList<Long> list = new ArrayList<Long>(oneThreadDeal);
                ArrayList<Future> futureList = new ArrayList<Future>(dimIdSet.size());
                while (iterator.hasNext()) {
                    Long dimId = (Long)iterator.next();
                    list.add(dimId);
                    if (i % oneThreadDeal != 0) {
                        ArrayList<Long> oneThreadList = list;
                        List<LogDimDis> oneThreadPreList = preList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                        List<LogDimDis> oneThreadAfterList = afterList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                        futureList.add(pool.submit(LogDimDis.diff(oneThreadPreList, oneThreadAfterList)));
                        list.clear();
                    }
                    ++i;
                }
                if (!CollectionUtils.isEmpty(list)) {
                    ArrayList<Long> oneThreadList = list;
                    List<LogDimDis> oneThreadPreList = preList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    List<LogDimDis> oneThreadAfterList = afterList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    futureList.add(pool.submit(LogDimDis.diff(oneThreadPreList, oneThreadAfterList)));
                }
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                    }
                    catch (Exception e) {
                        log.error("LogDimDis.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            Long elementBytes = PermMessage.getListEleOccupyBytes(CollectionUtils.isEmpty((Collection)del) ? null : del.get(0), CollectionUtils.isEmpty((Collection)add) ? null : add.get(0), null);
            map.put("ELEMENTBYTES", elementBytes);
            map.put("ELEMENTCOUNT", del.size() + add.size());
            return map;
        }
        catch (Exception e) {
            log.error("LogDimDis.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Map<String, List<LogDimDis>>> diff(final List<LogDimDis> preList, final List<LogDimDis> afterList) {
        return new Callable<Map<String, List<LogDimDis>>>(){

            @Override
            public Map<String, List<LogDimDis>> call() throws Exception {
                try {
                    return LogDimDis.logCompare(preList, afterList);
                }
                catch (Exception ex) {
                    log.error("LogDimDis.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    public static void save2DB(List<LogDimDis> diffList, Long fid) {
        LogDimDis.save2DB(diffList, fid, null);
    }

    public static void save2DB(List<LogDimDis> diffList, Long fid, Map<String, Object> paraMap) {
        HashMap<String, List> dimTypeRecordMap = new HashMap<String, List>(8);
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        for (LogDimDis one : diffList) {
            userIdSet.add(one.getUserId());
            dimTypeRecordMap.computeIfAbsent(one.getDimType(), k -> new ArrayList(10)).add(one);
        }
        if (null == dimTypeRecordMap || dimTypeRecordMap.isEmpty()) {
            return;
        }
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(8);
            paraMap.put("allCloudMap", AppHelper.getAllCloudMap());
            paraMap.put("allAppIdNameMap", AppHelper.getAllAppIdNameMap());
            paraMap.put("entityNameMap", FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name()));
            paraMap.put("allPermItemMap", PermItemHelper.getAllPermItemIdNameMap());
            paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
            paraMap.put("includeDesc", ConstantsHelper.getInclude());
            paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
        }
        Map allCloudMap = (Map)paraMap.get("allCloudMap");
        Map allAppIdNameMap = (Map)paraMap.get("allAppIdNameMap");
        Map entityNameMap = (Map)paraMap.get("entityNameMap");
        Map allPermItemMap = (Map)paraMap.get("allPermItemMap");
        Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
        Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, null);
        String includeDesc = (String)paraMap.get("includeDesc");
        String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimdis");
        sb.append("(fid, fperm_logid, fuser_id, fuser_name, fuser_number, fuser_username, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        String cloudId = "";
        String cloudName = "";
        String appName = "";
        String entityName = "";
        String permItemName = "";
        String includesuborgDesc = "";
        String dimTypeDesc = "";
        String dimName = "";
        String dimNumber = "";
        String trueName = "";
        String userNumber = "";
        String userName = "";
        int i = 0;
        for (Map.Entry dimTypeRecord : dimTypeRecordMap.entrySet()) {
            String dimType = (String)dimTypeRecord.getKey();
            List recordList = (List)dimTypeRecord.getValue();
            if (StringUtils.isEmpty((String)dimType) || null == recordList || recordList.isEmpty()) continue;
            Set dimIdSet = recordList.stream().map(DimPermItem::getDimId).collect(Collectors.toSet());
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIdSet), (String)dimType);
            for (LogDimDis one : recordList) {
                Long userIdOne;
                User user;
                String appId = one.getAppId();
                String entityId = one.getEntityId();
                String permItemId = one.getPermItemId();
                DynamicObject cloudObj = (DynamicObject)allCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                appName = (String)allAppIdNameMap.get(appId);
                entityName = (String)entityNameMap.get(entityId);
                permItemName = (String)allPermItemMap.get(permItemId);
                String includesuborg = one.getIncludesuborg();
                includesuborgDesc = StringUtils.isEmpty((String)includesuborg) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                Long dimId = one.getDimId();
                Dim dim = (Dim)dimMap.get(dimId);
                if (null != dim) {
                    dimName = dim.getDimName();
                    dimNumber = dim.getDimNumber();
                }
                if (null != (user = (User)userInfoMap.get(userIdOne = one.getUserId()))) {
                    trueName = StrUtil.nullAbleStr((String)user.getFtruename());
                    userNumber = StrUtil.nullAbleStr((String)user.getFnumber());
                    userName = StrUtil.nullAbleStr((String)user.getFusername());
                }
                obj = new Object[]{ids[i], fid, userIdOne, trueName, userNumber, userName, StrUtil.nullAbleStr((String)cloudId), StrUtil.nullAbleStr((String)cloudName), StrUtil.nullAbleStr((String)appId), StrUtil.nullAbleStr((String)appName), StrUtil.nullAbleStr((String)entityId), StrUtil.nullAbleStr((String)entityName), StrUtil.nullAbleStr((String)permItemId), StrUtil.nullAbleStr((String)permItemName), dimId, StrUtil.nullAbleStr((String)dimNumber), StrUtil.nullAbleStr((String)dimName), StrUtil.nullAbleStr((String)includesuborg), StrUtil.nullAbleStr((String)includesuborgDesc), StrUtil.nullAbleStr((String)one.getDimType()), StrUtil.nullAbleStr((String)dimTypeDesc), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
                ++i;
            }
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    public static Map<String, List<LogDimDis>> logCompare(List<LogDimDis> preList, List<LogDimDis> afterList) {
        HashMap<String, List<LogDimDis>> map = new HashMap<String, List<LogDimDis>>(2);
        List delList = ListUtil.removeAll(preList, afterList);
        List addList = ListUtil.removeAll(afterList, preList);
        map.put("del", delList);
        map.put("add", addList);
        return map;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
}

