/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermMessage;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.model.common.EntityField;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class LogDimField
extends EntityField
implements Serializable {
    private static final long serialVersionUID = -9115790724798537540L;
    private static final Log log = LogFactory.getLog(LogDimField.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_LogDimField_Pool", (int)1);
    private Long dimId;
    private String dimNumber;
    private String dimName;
    private String includesuborg;
    private String includesuborgDesc;
    private String dimType;
    private String dimTypeDesc;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogDimField that = (LogDimField)o;
        return Objects.equals(this.dimId, that.dimId) && Objects.equals(this.includesuborg, that.includesuborg) && Objects.equals(this.dimType, that.dimType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dimId, this.includesuborg, this.dimType);
    }

    public static Map<String, Object> logCompareMutiThread(List<LogDimField> preldfList, List<LogDimField> afterldfList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", new LinkedList());
        map.put("add", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (LogDimField one : preldfList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (LogDimField one : afterldfList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("del");
            List add = (List)map.get("add");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set ldfdimIdSet = (Set)dimTypeDimIdSet.getValue();
                Iterator ldfiterator = ldfdimIdSet.iterator();
                int i = 0;
                int ldfoneThreadDeal = 2;
                ArrayList<Long> list = new ArrayList<Long>(ldfoneThreadDeal);
                ArrayList<Future> ldffutureList = new ArrayList<Future>(ldfdimIdSet.size());
                while (ldfiterator.hasNext()) {
                    Long dimId = (Long)ldfiterator.next();
                    list.add(dimId);
                    if (i % ldfoneThreadDeal != 0) {
                        ArrayList<Long> oneThreadList = list;
                        List<LogDimField> oneThreadPreList = preldfList.stream().filter(ldf -> oneThreadList.contains(ldf.getDimId())).collect(Collectors.toList());
                        List<LogDimField> oneThreadAfterList = afterldfList.stream().filter(ldf -> oneThreadList.contains(ldf.getDimId())).collect(Collectors.toList());
                        ldffutureList.add(pool.submit(LogDimField.diff(oneThreadPreList, oneThreadAfterList)));
                        list.clear();
                    }
                    ++i;
                }
                if (!CollectionUtils.isEmpty(list)) {
                    ArrayList<Long> oneThreadList = list;
                    List<LogDimField> oneThreadPreList = preldfList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    List<LogDimField> oneThreadAfterList = afterldfList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    ldffutureList.add(pool.submit(LogDimField.diff(oneThreadPreList, oneThreadAfterList)));
                }
                if (CollectionUtils.isEmpty(ldffutureList)) continue;
                for (Future future : ldffutureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                    }
                    catch (Exception e) {
                        log.error("LogDimField.logCompareMutiThread --> error, preldfList:{}, afterldfList:{}", new Object[]{preldfList, afterldfList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            Long elementBytes = PermMessage.getListEleOccupyBytes(CollectionUtils.isEmpty((Collection)del) ? null : del.get(0), CollectionUtils.isEmpty((Collection)add) ? null : add.get(0), null);
            map.put("ELEMENTBYTES", elementBytes);
            map.put("ELEMENTCOUNT", del.size() + add.size());
            return map;
        }
        catch (Exception e) {
            log.error("LogDimField.logCompareMutiThread --> error, preldfList:{}, afterldfList:{}", new Object[]{preldfList, afterldfList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Map<String, List<LogDimField>>> diff(final List<LogDimField> preList, final List<LogDimField> afterList) {
        return new Callable<Map<String, List<LogDimField>>>(){

            @Override
            public Map<String, List<LogDimField>> call() throws Exception {
                try {
                    return LogDimField.logCompare(preList, afterList);
                }
                catch (Exception ex) {
                    log.error("LogDimField.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    public static Map<String, List<LogDimField>> logCompare(List<LogDimField> preldfList, List<LogDimField> afterldfList) {
        HashMap<String, List<LogDimField>> map = new HashMap<String, List<LogDimField>>(2);
        List preList_ = preldfList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getControlMode()) && !x.getControlMode().equals("0")).collect(Collectors.toList());
        List afterList_ = afterldfList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getControlMode()) && !x.getControlMode().equals("0")).collect(Collectors.toList());
        List delList = ListUtil.removeAll(preList_, afterList_);
        List addList = ListUtil.removeAll(afterList_, preList_);
        delList.stream().forEach(ldf -> {
            ldf.setOpDesc(ConstantsHelper.getDel() + ConstantsHelper.getFieldPerm());
            ldf.setDataChangeType(EnumsDataChangeType.DEL);
            ldf.setDataChangeTypeDesc(ConstantsHelper.getDel());
        });
        addList.stream().forEach(ldf -> {
            ldf.setOpDesc(ConstantsHelper.getAdd() + ConstantsHelper.getFieldPerm());
            ldf.setDataChangeType(EnumsDataChangeType.ADD);
            ldf.setDataChangeTypeDesc(ConstantsHelper.getAdd());
        });
        map.put("del", delList);
        map.put("add", addList);
        return map;
    }

    @Deprecated
    @SdkInternal
    public static void save2DB(List<LogDimField> diffList, Long fid) {
        LogDimField.save2DB(diffList, fid, null);
    }

    @Deprecated
    @SdkInternal
    public static void save2DB(List<LogDimField> diffList, Long fid, Map<String, Object> paraMap) {
        LogDimField.save2DB(diffList, fid, paraMap, null);
    }

    public static void save2DB(List<LogDimField> diffList, Long fid, Map<String, Object> paraMap, Set<String> influenceEntNumSet) {
        HashMap<String, List> dimTypeRecordMap = new HashMap<String, List>(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        for (LogDimField one : diffList) {
            dimTypeRecordMap.computeIfAbsent(one.getDimType(), k -> new ArrayList(10)).add(one);
            appIdSet.add(one.getAppId());
            entNumSet.add(one.getEntityId());
        }
        if (null == dimTypeRecordMap || dimTypeRecordMap.isEmpty()) {
            return;
        }
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(8);
            paraMap.put("includeDesc", ConstantsHelper.getInclude());
            paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
            paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        }
        Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
        String includeDesc = (String)paraMap.get("includeDesc");
        String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
        Map appIdCloudMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(appIdSet);
        HashMap<String, HashSet<String>> ent_paraMap = new HashMap<String, HashSet<String>>(8);
        ent_paraMap.put("paramEntNumSet", entNumSet);
        Map entNumEntMap = FormHelper.getEntNumEntMap(ent_paraMap);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimfield");
        sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, ffield_name, ffield_comment, fcontrol_mode, fcontrol_modedesc, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        String cloudId = "";
        String cloudName = "";
        String appName = "";
        String entityName = "";
        String includesuborgDesc = "";
        String dimTypeDesc = "";
        String dimName = "";
        String dimNumber = "";
        String fieldComment = "";
        HashMap hasLoadMap = new HashMap(8);
        int i = 0;
        Map pctMap = IsoDimHelper.permCtrlTypeMap();
        for (Map.Entry dimTypeRecord : dimTypeRecordMap.entrySet()) {
            String dimType = (String)dimTypeRecord.getKey();
            dimType = (String)pctMap.get(dimType);
            List recordList = (List)dimTypeRecord.getValue();
            if (StringUtils.isEmpty((String)dimType) || null == recordList || recordList.isEmpty()) continue;
            Set dimIdSet = recordList.stream().map(LogDimField::getDimId).collect(Collectors.toSet());
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIdSet), (String)dimType);
            for (LogDimField one : recordList) {
                String appId = StrUtil.nullAbleStr((String)one.getAppId());
                String entityId = StrUtil.nullAbleStr((String)one.getEntityId());
                DynamicObject cloudObj = (DynamicObject)appIdCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = StrUtil.nullAbleStr((String)cloudObj.getString("bizcloud.id"));
                    cloudName = StrUtil.nullAbleStr((String)cloudObj.getString("bizcloud.name"));
                }
                appName = StrUtil.nullAbleStr((String)((String)allAppIdNameMap.get(appId)));
                Entity entity = (Entity)entNumEntMap.get(entityId);
                entityName = null == entity ? "" : entity.getEntityName();
                String fieldName = StrUtil.nullAbleStr((String)one.getFieldName());
                fieldComment = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, (String)entityId, (String)fieldName);
                String controlMode = StrUtil.nullAbleStr((String)one.getControlMode());
                String controlModeDesc = ConstantsHelper.getControlModelDesc((String)controlMode);
                String includesuborg = StrUtil.nullAbleStr((String)one.getIncludesuborg());
                includesuborgDesc = StringUtils.isEmpty((String)includesuborg) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                Long dimId = one.getDimId();
                Dim dim = (Dim)dimMap.get(dimId);
                if (null != dim) {
                    dimName = StrUtil.nullAbleStr((String)dim.getDimName());
                    dimNumber = StrUtil.nullAbleStr((String)dim.getDimNumber());
                }
                String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityId, entityName, fieldName, fieldComment, controlMode, controlModeDesc, one.getDimId(), dimNumber, dimName, includesuborg, includesuborgDesc, dimType, dimTypeDesc, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
                if (null != influenceEntNumSet) {
                    influenceEntNumSet.add(entityId);
                }
                ++i;
            }
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    public Long getDimId() {
        return this.dimId;
    }

    public void setDimId(Long dimId) {
        this.dimId = dimId;
    }

    public String getDimNumber() {
        return this.dimNumber;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public String getDimName() {
        return this.dimName;
    }

    public void setDimName(String dimName) {
        this.dimName = dimName;
    }

    public String getIncludesuborg() {
        return this.includesuborg;
    }

    public void setIncludesuborg(String includesuborg) {
        this.includesuborg = includesuborg;
    }

    public String getIncludesuborgDesc() {
        return this.includesuborgDesc;
    }

    public void setIncludesuborgDesc(String includesuborgDesc) {
        this.includesuborgDesc = includesuborgDesc;
    }

    public String getDimType() {
        return this.dimType;
    }

    public void setDimType(String dimType) {
        this.dimType = dimType;
    }

    public String getDimTypeDesc() {
        return this.dimTypeDesc;
    }

    public void setDimTypeDesc(String dimTypeDesc) {
        this.dimTypeDesc = dimTypeDesc;
    }
}

