/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FieldPermSchemeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermMessage;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.util.StringUtils;

public class LogDimFps
implements Serializable {
    private static final long serialVersionUID = -6259981182005987805L;
    private static final Log log = LogFactory.getLog(LogDimFps.class);

    public static Map<String, Object> logCompare(Set<UserFieldPermScheme> preSet, Set<UserFieldPermScheme> afterSet) {
        preSet = null == preSet ? new HashSet(1) : preSet;
        afterSet = null == afterSet ? new HashSet(1) : afterSet;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        ArrayList pre = new ArrayList(preSet);
        ArrayList after = new ArrayList(afterSet);
        List delList = ListUtil.removeAll(pre, after);
        List addList = ListUtil.removeAll(after, pre);
        map.put("del", delList);
        map.put("add", addList);
        Long elementBytes = PermMessage.getListEleOccupyBytes(CollectionUtils.isEmpty((Collection)delList) ? null : delList.get(0), CollectionUtils.isEmpty((Collection)addList) ? null : addList.get(0), null);
        map.put("ELEMENTBYTES", elementBytes);
        map.put("ELEMENTCOUNT", delList.size() + addList.size());
        return map;
    }

    public static boolean saveDimFpsDiff(Long fid, Map<String, Object> diffDimFpsMap, String langStr, Map<String, Object> paraMap) throws Exception {
        try {
            String opDescSuffix;
            String sensitive;
            if (CollectionUtils.isEmpty(diffDimFpsMap)) {
                return false;
            }
            ObjectMapper useDelDimFpsObjMapper = new ObjectMapper();
            List delUserDimFpsList = (List)useDelDimFpsObjMapper.readValue(useDelDimFpsObjMapper.writeValueAsString(diffDimFpsMap.get("del")), useDelDimFpsObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UserFieldPermScheme.class}));
            delUserDimFpsList = null == delUserDimFpsList ? new ArrayList(0) : delUserDimFpsList;
            ObjectMapper addUserDimFpsObjMapper = new ObjectMapper();
            List addUserDimFpsList = (List)addUserDimFpsObjMapper.readValue(addUserDimFpsObjMapper.writeValueAsString(diffDimFpsMap.get("add")), addUserDimFpsObjMapper.getTypeFactory().constructParametricType(List.class, new Class[]{UserFieldPermScheme.class}));
            List list = addUserDimFpsList = null == addUserDimFpsList ? new ArrayList(0) : addUserDimFpsList;
            if (CollectionUtils.isEmpty((Collection)delUserDimFpsList) && CollectionUtils.isEmpty((Collection)addUserDimFpsList)) {
                return false;
            }
            String delDescConst = ConstantsHelper.getDel();
            String addDescConst = ConstantsHelper.getAdd();
            EnumsDataChangeType delDCTEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addDCTEnum = EnumsDataChangeType.ADD;
            String opDesc_ = ConstantsHelper.getFps();
            String opSeneitiveDesc_ = ConstantsHelper.getFpsSensitive();
            HashMap<String, Set> dimTypeUserFpsSetMap = new HashMap<String, Set>(8);
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            HashSet<Long> fpsIdSet = new HashSet<Long>(8);
            HashSet<String> appIdSet = new HashSet<String>(8);
            HashSet<String> entNumSet = new HashSet<String>(8);
            for (UserFieldPermScheme one : delUserDimFpsList) {
                dimTypeUserFpsSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one);
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
                fpsIdSet.add(one.getId());
                one.setDataChangeType(delDCTEnum);
                one.setDataChangeTypeDesc(delDescConst);
                sensitive = one.getSensitive();
                opDescSuffix = StringUtils.isNotEmpty((String)sensitive) && Objects.equals("1", sensitive) ? opSeneitiveDesc_ : opDesc_;
                one.setOpDesc(delDescConst + opDescSuffix);
                appIdSet.add(one.getAppId());
                entNumSet.add(one.getEntityNumber());
            }
            for (UserFieldPermScheme one : addUserDimFpsList) {
                dimTypeUserFpsSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one);
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
                fpsIdSet.add(one.getId());
                one.setDataChangeType(addDCTEnum);
                one.setDataChangeTypeDesc(addDescConst);
                sensitive = one.getSensitive();
                opDescSuffix = StringUtils.isNotEmpty((String)sensitive) && Objects.equals("1", sensitive) ? opSeneitiveDesc_ : opDesc_;
                one.setOpDesc(addDescConst + opDescSuffix);
                appIdSet.add(one.getAppId());
                entNumSet.add(one.getEntityNumber());
            }
            if (null == dimTypeUserFpsSetMap || dimTypeUserFpsSetMap.isEmpty() || null == fpsIdSet || fpsIdSet.isEmpty()) {
                return false;
            }
            Map fpsMap = FieldPermSchemeHelper.getFpsMap(fpsIdSet);
            Map appIdCloudMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
            Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(appIdSet);
            HashMap<String, HashSet<String>> ent_paraMap = new HashMap<String, HashSet<String>>(8);
            ent_paraMap.put("paramEntNumSet", entNumSet);
            Map entNumEntMap = FormHelper.getEntNumEntMap(ent_paraMap);
            Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
            String includeDesc = (String)paraMap.get("includeDesc");
            String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
            int size = delUserDimFpsList.size() + addUserDimFpsList.size();
            long[] ids = ID.genLongIds((int)size);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
            LocalDateTime curTime = LocalDateTime.now();
            Object[] obj = null;
            String cloudId = "";
            String cloudName = "";
            String appName = "";
            String entityName = "";
            String fpsName = "";
            String includeSubDesc = "";
            String dimTypeDesc = "";
            String dimName = "";
            String dimNumber = "";
            int i = 0;
            for (Map.Entry dimTypeUserFpsSet : dimTypeUserFpsSetMap.entrySet()) {
                String dimType = (String)dimTypeUserFpsSet.getKey();
                Set value = (Set)dimTypeUserFpsSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || null == value || value.isEmpty()) continue;
                Map dimMap = IsoDimHelper.getDimMap(new ArrayList((Collection)dimTypeDimIdSetMap.get(dimType)), (String)dimType);
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                for (UserFieldPermScheme x : value) {
                    Long dimId = x.getDimId();
                    Dim dim = (Dim)dimMap.get(dimId);
                    if (null != dim) {
                        dimName = dim.getDimName();
                        dimNumber = dim.getDimNumber();
                    }
                    String appId = x.getAppId();
                    String entityNumber = x.getEntityNumber();
                    cloudId = x.getCloudId();
                    DynamicObject cloud = (DynamicObject)appIdCloudMap.get(appId);
                    if (null != cloud) {
                        cloudId = cloud.getString("bizcloud.id");
                        cloudName = cloud.getString("bizcloud.name");
                    }
                    appName = StrUtil.nullAbleStr((String)((String)allAppIdNameMap.get(appId)));
                    Entity entity = (Entity)entNumEntMap.get(entityNumber);
                    entityName = null == entity ? "" : entity.getEntityName();
                    Long fpsId = x.getId();
                    FieldPermScheme fieldPermScheme = (FieldPermScheme)fpsMap.get(fpsId);
                    fpsName = null == fieldPermScheme ? "" : fieldPermScheme.getName();
                    String includeSub = StrUtil.nullAbleStr((String)x.getIncludeSub());
                    includeSubDesc = StringUtils.isEmpty((String)includeSub) ? "" : ("1".equals(includeSub) ? includeDesc : notIncludeDesc);
                    obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityNumber, entityName, fpsId, fpsName, StrUtil.nullAbleStr((String)x.getSensitive()), dimId, dimNumber, dimName, includeSub, includeSubDesc, dimType, dimTypeDesc, x.getOpDesc(), curTime, x.getDataChangeType().getType(), x.getDataChangeTypeDesc()};
                    paramList.add(obj);
                    ++i;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ").append("t_perm_log_diff_dimfps");
            sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_num, fentity_name, ffpschemeid, ffpschemename, fsensitive, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
            sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            SqlUtil.syncInsert(paramList, (String)sb.toString(), null, (DBRoute)DBRoute.log, (boolean)true);
            return true;
        }
        catch (Exception e) {
            log.error("LogDimFps.saveDimFpsDiff error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }
}

