/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.model.common.Dim;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class LogDimRange
extends Dim
implements Serializable {
    private static final long serialVersionUID = -7040775850282392236L;
    private static final Log log = LogFactory.getLog(LogDimRange.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_LogDimRange_Pool", (int)2);

    public LogDimRange() {
    }

    public LogDimRange(Long dimId, String dimNumber, String dimName, String includesuborg, String includesuborgDesc, String dimType) {
        super(dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType);
    }

    public static void logCompareMutiThread(Long fid, List<LogDimRange> ldrpreList, List<LogDimRange> ldrafterList) {
        LogDimRange.logCompareMutiThreadReturn(fid, ldrpreList, ldrafterList);
    }

    public static boolean logCompareMutiThreadReturn(Long fid, List<LogDimRange> ldrpreList, List<LogDimRange> ldrafterList) {
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (LogDimRange logDimRange : ldrpreList) {
                dimTypeDimIdSetMap.computeIfAbsent(logDimRange.getDimType(), k -> new HashSet(8)).add(logDimRange.getDimId());
            }
            for (LogDimRange logDimRange : ldrafterList) {
                dimTypeDimIdSetMap.computeIfAbsent(logDimRange.getDimType(), k -> new HashSet(8)).add(logDimRange.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return false;
            }
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)RequestContext.get().getLang().name());
            EnumsDataChangeType delEnum = EnumsDataChangeType.DEL;
            EnumsDataChangeType addEnum = EnumsDataChangeType.ADD;
            EnumsDataChangeType updateEnum = EnumsDataChangeType.UPDATE;
            String delDesc = ConstantsHelper.getDel();
            String addDesc = ConstantsHelper.getAdd();
            String updateDesc = ConstantsHelper.getUpdate();
            boolean existsDiff = false;
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                List<LogDimRange> oneThreadAfterList;
                List<LogDimRange> oneThreadPreList;
                ArrayList oneThreadList;
                String key = (String)dimTypeDimIdSet.getKey();
                Set ldrdimIdSet = (Set)dimTypeDimIdSet.getValue();
                Map dimMap = IsoDimHelper.getDimMap(new ArrayList(ldrdimIdSet), (String)key);
                Map dimTypeMap = (Map)permCtrlTypeMap.get(key);
                String dimTypeName = (String)dimTypeMap.get("fname");
                Iterator ldriterator = ldrdimIdSet.iterator();
                int i = 0;
                int oneThreadDeal = 2;
                ArrayList list = new ArrayList(oneThreadDeal);
                ArrayList<Future> ldrfutureList = new ArrayList<Future>(ldrdimIdSet.size() / oneThreadDeal + 1);
                while (ldriterator.hasNext()) {
                    list.add(ldriterator.next());
                    if (i % oneThreadDeal != 0) {
                        oneThreadList = list;
                        oneThreadPreList = ldrpreList.stream().filter(x -> Objects.equals(x.getDimType(), key) && oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                        oneThreadAfterList = ldrafterList.stream().filter(x -> Objects.equals(x.getDimType(), key) && oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                        ldrfutureList.add(pool.submit(LogDimRange.diffAndSave(fid, oneThreadPreList, oneThreadAfterList, dimMap, delEnum, delDesc, addEnum, addDesc, updateEnum, updateDesc, dimTypeName)));
                        list.clear();
                    }
                    ++i;
                }
                if (!CollectionUtils.isEmpty(list)) {
                    oneThreadList = list;
                    oneThreadPreList = ldrpreList.stream().filter(x -> Objects.equals(x.getDimType(), key) && oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                    oneThreadAfterList = ldrafterList.stream().filter(x -> Objects.equals(x.getDimType(), key) && oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                    ldrfutureList.add(pool.submit(LogDimRange.diffAndSave(fid, oneThreadPreList, oneThreadAfterList, dimMap, delEnum, delDesc, addEnum, addDesc, updateEnum, updateDesc, dimTypeName)));
                }
                for (Future future : ldrfutureList) {
                    try {
                        Boolean aBoolean = (Boolean)future.get();
                        if (!aBoolean.booleanValue()) continue;
                        existsDiff = true;
                    }
                    catch (Exception e) {
                        log.error("LogDimRange.logCompareMutiThreadReturn --> error, fid:{}, ldrpreList:{}, ldrafterList:{}", new Object[]{fid, ldrpreList, ldrafterList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            return existsDiff;
        }
        catch (Exception e) {
            log.error("LogDimRange.logCompareMutiThreadReturn --> error, fid:{}, ldrpreList:{}, ldrafterList:{}", new Object[]{fid, ldrpreList, ldrafterList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Boolean> diffAndSave(final Long fid, final List<LogDimRange> ldrpreList, final List<LogDimRange> ldrafterList, final Map<Long, kd.bos.permission.cache.model.Dim> dimMap, final EnumsDataChangeType delEnum, final String delDesc, final EnumsDataChangeType addEnum, final String addDesc, final EnumsDataChangeType updateEnum, final String updateDesc, final String dimTypeName) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    List diffList = LogDimRange.logCompare(ldrpreList, ldrafterList, delEnum, delDesc, addEnum, addDesc, updateEnum, updateDesc, dimTypeName);
                    if (CollectionUtils.isEmpty((Collection)diffList)) {
                        return Boolean.FALSE;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("insert into ").append("t_perm_log_diff_dimrange");
                    sb.append("(fid, fperm_logid, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc, fdimtypedesc)");
                    sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    int size = diffList.size();
                    long[] ids = ID.genLongIds((int)size);
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
                    LocalDateTime curTime = LocalDateTime.now();
                    Object[] obj = null;
                    for (int i = 0; i < size; ++i) {
                        LogDimRange one = (LogDimRange)diffList.get(i);
                        Long dimId = one.getDimId();
                        kd.bos.permission.cache.model.Dim dim = (kd.bos.permission.cache.model.Dim)dimMap.get(dimId);
                        String dimNumber = StrUtil.nullAbleStr((String)dim.getDimNumber());
                        String dimName = StrUtil.nullAbleStr((String)dim.getDimName());
                        String includesuborg = StrUtil.nullAbleStr((String)one.getIncludesuborg());
                        String includesuborgDesc = StrUtil.nullAbleStr((String)one.getIncludesuborgDesc());
                        String dimType = StrUtil.nullAbleStr((String)one.getDimType());
                        String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
                        String dimTypeDesc = StrUtil.nullAbleStr((String)one.getDimTypeDesc());
                        obj = new Object[]{ids[i], fid, dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc(), dimTypeDesc};
                        paramList.add(obj);
                    }
                    SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
                    return Boolean.TRUE;
                }
                catch (Exception ex) {
                    log.error("LogDimRange.diffAndSave --> error, ldrpreList:{}, ldrafterList:{}", new Object[]{ldrpreList, ldrafterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    private static List<LogDimRange> logCompare(List<LogDimRange> ldrpreList, List<LogDimRange> ldrafterList, EnumsDataChangeType delEnum, String delDesc, EnumsDataChangeType addEnum, String addDesc, EnumsDataChangeType updateEnum, String updateDesc, String dimTypeName) {
        List delList = ListUtil.removeAll(ldrpreList, ldrafterList);
        List addList = ListUtil.removeAll(ldrafterList, ldrpreList);
        ArrayList<LogDimRange> finalList = new ArrayList<LogDimRange>(8);
        delList.stream().forEach(ldr -> {
            ldr.setDimTypeDesc(dimTypeName);
            ldr.setOpDesc(delDesc + dimTypeName);
            ldr.setDataChangeType(delEnum);
            ldr.setDataChangeTypeDesc(delDesc);
        });
        addList.stream().forEach(ldr -> {
            ldr.setDimTypeDesc(dimTypeName);
            ldr.setOpDesc(addDesc + dimTypeName);
            ldr.setDataChangeType(addEnum);
            ldr.setDataChangeTypeDesc(addDesc);
        });
        finalList.addAll(delList);
        finalList.addAll(addList);
        return finalList;
    }

    public static List<LogDimRange> logCompare(List<LogDimRange> ldrpreList, List<LogDimRange> ldrafterList) {
        List delList = ListUtil.removeAll(ldrpreList, ldrafterList);
        List addList = ListUtil.removeAll(ldrafterList, ldrpreList);
        ArrayList<LogDimRange> finalList = new ArrayList<LogDimRange>(8);
        delList.stream().forEach(ldr -> {
            ldr.setOpDesc(ConstantsHelper.getDel() + ConstantsHelper.getOrgRange());
            ldr.setDataChangeType(EnumsDataChangeType.DEL);
            ldr.setDataChangeTypeDesc(ConstantsHelper.getDel());
        });
        addList.stream().forEach(ldr -> {
            ldr.setOpDesc(ConstantsHelper.getAdd() + ConstantsHelper.getOrgRange());
            ldr.setDataChangeType(EnumsDataChangeType.ADD);
            ldr.setDataChangeTypeDesc(ConstantsHelper.getAdd());
        });
        finalList.addAll(delList);
        finalList.addAll(addList);
        return finalList;
    }
}

