/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.model.common.Dim;

public class LogDimRole
extends Dim
implements Serializable {
    private static final long serialVersionUID = -7040775850282392236L;
    private String roleId;
    private String roleNumber;
    private String roleName;
    private Date fstarttime;
    private Date fendtime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogDimRole that = (LogDimRole)o;
        return Objects.equals(this.roleNumber, that.roleNumber) && Objects.equals(this.fstarttime, that.fstarttime) && Objects.equals(this.fendtime, that.fendtime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleNumber, this.fstarttime, this.fendtime);
    }

    public static void save2DB(List<LogDimRole> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimrole");
        sb.append("(fid, fperm_logid, frole_number, frole_name, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            LogDimRole one = diffList.get(i);
            String roleNumber = StrUtil.nullAbleStr((String)one.getRoleNumber());
            String roleName = StrUtil.nullAbleStr((String)one.getRoleName());
            Long dimId = one.getDimId();
            String dimNumber = StrUtil.nullAbleStr((String)one.getDimNumber());
            String dimName = StrUtil.nullAbleStr((String)one.getDimName());
            String includesuborg = StrUtil.nullAbleStr((String)one.getIncludesuborg());
            String includesuborgDesc = StrUtil.nullAbleStr((String)one.getIncludesuborgDesc());
            String dimType = StrUtil.nullAbleStr((String)one.getDimType());
            String dimTypeDesc = StrUtil.nullAbleStr((String)one.getDimTypeDesc());
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, roleNumber, roleName, dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType, dimTypeDesc, one.getFstarttime(), one.getFendtime(), opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleNumber() {
        return this.roleNumber;
    }

    public void setRoleNumber(String roleNumber) {
        this.roleNumber = roleNumber;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Date getFstarttime() {
        return this.fstarttime;
    }

    public void setFstarttime(Date fstarttime) {
        this.fstarttime = fstarttime;
    }

    public Date getFendtime() {
        return this.fendtime;
    }

    public void setFendtime(Date fendtime) {
        this.fendtime = fendtime;
    }
}

