/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.model.common.DimUser;

public class LogDimUser
extends DimUser
implements Serializable {
    private static final long serialVersionUID = -5924920080790916053L;
    private Date starTime;
    private Date endTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogDimUser that = (LogDimUser)o;
        return Objects.equals(this.starTime, that.starTime) && Objects.equals(this.endTime, that.endTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.starTime, this.endTime);
    }

    public static void save2DB(List<LogDimUser> diffList, Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimuser");
        sb.append("(fid, fperm_logid, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fuser_id, fuser_name, fuser_number, fuser_username, fphone, femail, fstarttime, fendtime, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        for (int i = 0; i < size; ++i) {
            LogDimUser one = diffList.get(i);
            String dimNumber = StrUtil.nullAbleStr((String)one.getDimNumber());
            String dimName = StrUtil.nullAbleStr((String)one.getDimName());
            String includesuborg = StrUtil.nullAbleStr((String)one.getIncludesuborg());
            String includesuborgDesc = StrUtil.nullAbleStr((String)one.getIncludesuborgDesc());
            String dimType = StrUtil.nullAbleStr((String)one.getDimType());
            String dimTypeDesc = StrUtil.nullAbleStr((String)one.getDimTypeDesc());
            String trueName = StrUtil.nullAbleStr((String)one.getTrueName());
            String userNumber = StrUtil.nullAbleStr((String)one.getUserNumber());
            String userName = StrUtil.nullAbleStr((String)one.getUserName());
            String phone = StrUtil.nullAbleStr((String)one.getPhone());
            String email = StrUtil.nullAbleStr((String)one.getEmail());
            String opDesc = StrUtil.nullAbleStr((String)one.getOpDesc());
            obj = new Object[]{ids[i], fid, one.getDimId(), dimNumber, dimName, includesuborg, includesuborgDesc, dimType, dimTypeDesc, one.getUserId(), trueName, userNumber, userName, phone, email, one.getStarTime(), one.getEndTime(), opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
            paramList.add(obj);
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    public Date getStarTime() {
        return this.starTime;
    }

    public void setStarTime(Date starTime) {
        this.starTime = starTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}

