/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.model.ExtHandleMsg;
import kd.bos.bd.log.util.EsUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.log.factory.PermLogServiceFactory;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.util.StringUtils;

public class GenDiffService {
    private static Log log = LogFactory.getLog(GenDiffService.class);

    public static void genDiff2Es(ExtHandleMsg extHandleMsg, String index) {
        String logType = extHandleMsg.getLogType();
        Integer num = extHandleMsg.getNum();
        if (StringUtils.isEmpty((String)logType) || null == num || num.equals(0)) {
            log.debug("GenDiffService.genDiff2Es, param invalid, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            return;
        }
        JSONObject properties = EsUtils.getTenantEsProperties((String)logType);
        if (properties == null || properties.size() <= 0) {
            log.warn("[{}], \u65e5\u5fd7\u5dee\u5f02\u5199\u5165Elasticsearch\uff0c\u914d\u7f6e\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a", (Object)EnumBDLogType.getDescriByType((String)logType));
            throw new RuntimeException("log diff write to es, es config is empty.");
        }
    }

    private static List<Map<String, Object>> getTopNRecordDB(Integer num) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top ").append(num).append(" fid, fbusi_type, fpre_data, fafter_data, fdiff_content");
        sb.append(" from t_perm_log");
        sb.append(" where fhas_gendiff = '0' order by fid desc");
        return (List)DB.query((DBRoute)DBRoute.log, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
                HashMap<String, Object> map = null;
                while (rs.next()) {
                    map = new HashMap<String, Object>();
                    map.put("id", rs.getLong("fid"));
                    map.put("busi_type", rs.getString("fbusi_type"));
                    map.put("pre_data", rs.getString("fpre_data"));
                    map.put("after_data", rs.getString("fafter_data"));
                    map.put("diff_content", rs.getString("fdiff_content"));
                    list.add(map);
                }
                return list;
            }
        });
    }

    public static void genDiffContent(Long fid, String diffContent) {
        StringBuilder sql = new StringBuilder("update t_perm_log set fdiff_content = ?, fhas_gendiff = '1' where fid = ? ");
        Object[] params = new Object[]{diffContent, fid};
        DB.execute((DBRoute)DBRoute.log, (String)sql.toString(), (Object[])params);
    }

    public static void updateHasGenDiff(Long fid, String genDiffResult) {
        StringBuilder sql = new StringBuilder("update t_perm_log set fhas_gendiff = '1', fmodify_time = ?");
        if (!StringUtils.isEmpty((String)genDiffResult)) {
            if (genDiffResult.length() > 300) {
                genDiffResult = genDiffResult.substring(0, 300);
            }
            sql.append(", fgendiff_result = '").append(genDiffResult).append('\'');
        }
        sql.append(" where fid = ? ");
        Object[] params = new Object[]{LocalDateTime.now(), fid};
        DB.execute((DBRoute)DBRoute.log, (String)sql.toString(), (Object[])params);
    }

    public static boolean genDiff2DB(ExtHandleMsg extHandleMsg) {
        String logType = extHandleMsg.getLogType();
        Integer num = extHandleMsg.getNum();
        if (StringUtils.isEmpty((String)logType) || null == num || num.equals(0)) {
            log.debug("GenDiffService.genDiff2DB, param invalid, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            return false;
        }
        EnumBDLogType enumLogType = EnumBDLogType.getEnum((String)logType);
        if (EnumBDLogType.PERM != enumLogType) {
            log.debug("GenDiffService.genDiff2DB, EnumBDLogType invalid, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            return false;
        }
        List<Map<String, Object>> list = GenDiffService.getTopNRecordDB(num);
        if (CollectionUtils.isEmpty(list)) {
            log.debug("GenDiffService.genDiff2DB, getTopNRecordDB is empty, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            return false;
        }
        String logTypeDesc = enumLogType.getDescri();
        try {
            for (Map<String, Object> map : list) {
                String directSaveDiff;
                String diffHandler;
                String busiType = (String)map.get("busi_type");
                PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType(busiType);
                if (null == permLogBusiType || StringUtils.isEmpty((String)(diffHandler = permLogBusiType.getDiffHandler())) || StringUtils.isEmpty((String)(directSaveDiff = permLogBusiType.getDirectSaveDiff()))) continue;
                PermLogDiffHandler handler = (PermLogDiffHandler)PermLogServiceFactory.getServiceByClassName(diffHandler);
                Long fid = (Long)map.get("id");
                if ("1".equals(directSaveDiff)) {
                    String diff_content = (String)map.get("diff_content");
                    handler.saveLogDiff(fid, diff_content);
                    continue;
                }
                String fpre_data = (String)map.get("pre_data");
                String fafter_data = (String)map.get("after_data");
                handler.genLogDiff(fid, fpre_data, fafter_data);
            }
        }
        catch (Exception e) {
            log.warn("GenDiffService.genDiff2DB error, [{}], \u4ea7\u751f\u65e5\u5fd7\u5dee\u5f02\uff0c\u5e76\u5b58\u50a8 DB, \u5f02\u5e38!", (Object)logTypeDesc, (Object)e);
            throw new KDBizException(new ErrorCode("0", "GenDiffService.genDiff2DB error."), new Object[0]);
        }
        return true;
    }
}

