/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.model.PermLog;
import kd.bos.permission.log.model.PermLogArchive;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class PermLogService {
    private static Log log = LogFactory.getLog(PermLogService.class);

    public static Map<String, String> selectSingleFromPermLog(final Map<String, String> copyObjNameAndselectField, Long id) {
        Collection<String> fields = null;
        if (copyObjNameAndselectField != null) {
            fields = copyObjNameAndselectField.values();
        }
        if (CollectionUtils.isEmpty(fields)) {
            return null;
        }
        boolean isFirst = true;
        StringBuilder sql = new StringBuilder().append("select ");
        for (String field : fields) {
            if (isFirst) {
                sql.append(field);
                isFirst = false;
                continue;
            }
            sql.append(',').append(field);
        }
        sql.append(" from ").append("t_perm_log").append(" where fid = '").append(id).append('\'');
        Map results = (Map)DB.query((DBRoute)DBRoute.log, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> result = new HashMap<String, String>(8);
                while (rs.next()) {
                    for (Map.Entry fieldAndName : copyObjNameAndselectField.entrySet()) {
                        String key = (String)fieldAndName.getKey();
                        String value = rs.getString((String)fieldAndName.getValue());
                        if ("operTime".equals(key) && StringUtils.isNotEmpty((String)value)) {
                            String timeStr = value.substring(0, 19);
                            result.put(key, timeStr);
                            continue;
                        }
                        result.put(key, value);
                    }
                }
                return result;
            }
        });
        return results;
    }

    private static Map<Long, PermLog> getPermLogMap() {
        return (Map)DB.query((DBRoute)DBRoute.log, (String)"select fid, fbusi_type, foper_time from t_perm_log", (ResultSetHandler)new ResultSetHandler<Map<Long, PermLog>>(){

            public Map<Long, PermLog> handle(ResultSet rs) throws Exception {
                HashMap<Long, PermLog> result = new HashMap<Long, PermLog>(8);
                PermLog permLog = null;
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    String fbusi_type = rs.getString("fbusi_type");
                    String foper_timeStr = rs.getString("foper_time");
                    Date foper_time = StringUtils.isEmpty((String)foper_timeStr) ? null : DateUtil.toDate((String)foper_timeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                    permLog = new PermLog();
                    permLog.setPermLogId(fid);
                    permLog.setBusiType(fbusi_type);
                    permLog.setOperaTime(foper_time);
                    result.put(fid, permLog);
                }
                return result;
            }
        });
    }

    public static Map<String, PermLogBusiType> loadBusiTypeMapFromDB(List<QFilter> qFilterList) {
        QFilter[] filters = null == qFilterList || qFilterList.isEmpty() ? null : qFilterList.toArray(new QFilter[qFilterList.size()]);
        Map allFields = EntityMetadataCache.getDataEntityType((String)"permlog_busitype").getAllFields();
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"permlog_busitype", (String)String.join((CharSequence)",", allFields.keySet()), (QFilter[])filters, (String)"id asc");
        if (null == objects || 0 == objects.length) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, PermLogBusiType> result = new LinkedHashMap<String, PermLogBusiType>(16);
        PermLogBusiType one = null;
        for (DynamicObject object : objects) {
            one = new PermLogBusiType();
            one.setFid(object.getLong("id"));
            String busitype = object.getString("busitype");
            one.setBusiType(busitype);
            one.setBusiTypeDesc(object.getString("busitype_desc"));
            one.setDiffHandler(object.getString("diff_handler"));
            one.setDetailForm(object.getString("detail_form"));
            Boolean direct_savediff = object.getBoolean("direct_savediff");
            one.setDirectSaveDiff(direct_savediff != false ? "1" : "0");
            one.setArchiveaPeriod(object.getInt("archivea_period"));
            one.setArchiveaRetaindays(object.getInt("archivea_retaindays"));
            one.setModifyTime(object.getString("modify_time"));
            result.put(busitype, one);
        }
        return result;
    }

    public static PermLogBusiType getPermLogBusiType(String busiType) {
        return PermLogService.getPermLogBusiType(busiType, true);
    }

    public static PermLogBusiType getPermLogBusiType(String busiType, boolean careEnablePermLog) {
        if (careEnablePermLog && !PermCommonUtil.isEnablePermLog()) {
            return null;
        }
        if (StringUtils.isEmpty((String)busiType)) {
            log.warn(ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"PermLogService_0", (String)"bos-permission-log", (Object[])new Object[0]));
            return null;
        }
        Map<String, PermLogBusiType> map = PermLogService.loadBusiTypeMapFromDB(Collections.singletonList(new QFilter("busitype", "=", (Object)busiType)));
        if (null == map || map.isEmpty()) {
            log.warn(ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"PermLogService_0", (String)"bos-permission-log", (Object[])new Object[0]));
            return null;
        }
        return map.get(busiType);
    }

    public static List<Long> getNeedArchievePermLogId() {
        Map<Long, PermLog> permLogMap = PermLogService.getPermLogMap();
        if (null == permLogMap || permLogMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<String, PermLogBusiType> busiTypeArchiveaPeriodMap = PermLogService.loadBusiTypeMapFromDB(null);
        if (null == busiTypeArchiveaPeriodMap || busiTypeArchiveaPeriodMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> list = new ArrayList<Long>(10);
        long curTime = new Date().getTime();
        for (Map.Entry<Long, PermLog> entry : permLogMap.entrySet()) {
            PermLog value = entry.getValue();
            Long permLogId = value.getPermLogId();
            String busiType = value.getBusiType();
            Date operaTime = value.getOperaTime();
            PermLogBusiType permLogBusiType = busiTypeArchiveaPeriodMap.get(busiType);
            if (null == permLogBusiType) {
                log.warn("PermLogService.getNeedArchievePermLogId, permLogBusiType is null, permLogId:{}, busiType:{}", (Object)permLogId, (Object)busiType);
                continue;
            }
            Integer archiveaPeriod = permLogBusiType.getArchiveaPeriod();
            if (null == archiveaPeriod) {
                log.warn("PermLogService.getNeedArchievePermLogId, archiveaPeriod is null, permLogId:{}, busiType:{}", (Object)permLogId, (Object)busiType);
                continue;
            }
            long time = DateUtils.addDays((Date)operaTime, (int)archiveaPeriod).getTime();
            if (curTime < time) continue;
            list.add(permLogId);
        }
        return list;
    }

    private static Map<Long, PermLogArchive> getPermLogArchiveMap() {
        return (Map)DB.query((DBRoute)DBRoute.log, (String)"select fid, fbusi_type, ffiling_time from t_perm_log_archive", (ResultSetHandler)new ResultSetHandler<Map<Long, PermLogArchive>>(){

            public Map<Long, PermLogArchive> handle(ResultSet rs) throws Exception {
                HashMap<Long, PermLogArchive> result = new HashMap<Long, PermLogArchive>(8);
                PermLogArchive one = null;
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    String fbusi_type = rs.getString("fbusi_type");
                    String ffiling_timeStr = rs.getString("ffiling_time");
                    Date ffiling_time = StringUtils.isEmpty((String)ffiling_timeStr) ? null : DateUtil.toDate((String)ffiling_timeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                    one = new PermLogArchive();
                    one.setPermLogId(fid);
                    one.setBusiType(fbusi_type);
                    one.setFilingTime(ffiling_time);
                    result.put(fid, one);
                }
                return result;
            }
        });
    }

    public static List<Long> getNeedArchieveCleanPermLogId() {
        Map<Long, PermLogArchive> permLogArchiveMap = PermLogService.getPermLogArchiveMap();
        if (null == permLogArchiveMap || permLogArchiveMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<String, PermLogBusiType> busiTypeArchiveaPeriodMap = PermLogService.loadBusiTypeMapFromDB(null);
        if (null == busiTypeArchiveaPeriodMap || busiTypeArchiveaPeriodMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> list = new ArrayList<Long>(10);
        long curTime = new Date().getTime();
        for (Map.Entry<Long, PermLogArchive> entry : permLogArchiveMap.entrySet()) {
            PermLogArchive value = entry.getValue();
            Long permLogId = value.getPermLogId();
            String busiType = value.getBusiType();
            Date filingTime = value.getFilingTime();
            PermLogBusiType permLogBusiType = busiTypeArchiveaPeriodMap.get(busiType);
            if (null == permLogBusiType) {
                log.warn("PermLogService.getNeedArchieveCleanPermLogId, permLogBusiType is null, permLogId:{}, busiType:{}", (Object)permLogId, (Object)busiType);
                continue;
            }
            Integer archiveaRetaindays = permLogBusiType.getArchiveaRetaindays();
            if (null == archiveaRetaindays) {
                log.warn("PermLogService.getNeedArchieveCleanPermLogId, archiveaRetaindays is null, permLogId:{}, busiType:{}", (Object)permLogId, (Object)busiType);
                continue;
            }
            long time = DateUtils.addDays((Date)filingTime, (int)archiveaRetaindays).getTime();
            if (curTime < time) continue;
            list.add(permLogId);
        }
        return list;
    }

    public static void del(Set<Long> fidSet) {
        if (null == fidSet || fidSet.isEmpty()) {
            return;
        }
        List fidStrList = fidSet.stream().map(String::valueOf).collect(Collectors.toList());
        String fidStr = String.join((CharSequence)",", fidStrList);
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from ").append("t_perm_log");
        delSql.append(" where fid in (").append(fidStr).append(')');
        DB.execute((DBRoute)DBRoute.log, (String)delSql.toString());
    }

    public static void delChildTab(String tableName, String fidStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(tableName);
        sb.append(" where fperm_logid in (").append(fidStr).append(')');
        DB.execute((DBRoute)DBRoute.log, (String)sb.toString());
    }
}

