/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.timetask;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.factory.PermLogServiceFactory;
import kd.bos.permission.log.handler.PermLogDiffHandler;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.schedule.executor.AbstractTask;
import org.apache.commons.lang3.StringUtils;

public class PermLogArchiveTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(PermLogArchiveTask.class);
    private static final String[] COLUMN = new String[]{"fid", "fnumber", "fbusi_from", "fbusi_type", "fcloud_id", "fcloud_name", "fapp_id", "fapp_name", "fform_identity", "fform_name", "fperm_item_id", "fperm_item_name", "fop", "fopbtn", "finterface_method", "fop_item_id", "fop_item_number", "fop_item_name", "fpre_data", "fafter_data", "fdiff_content", "foper_id", "foper_name", "foper_number", "foper_username", "foper_org_id", "foper_org_name", "foper_time", "fop_desc", "fclient_type", "fclient_ip", "fclient_name", "fcreate_time", "fmodify_time", "fhas_gendiff", "ffiling_time"};
    private static final String[] ARCHIVE_CLEAR_CHILD_TABLE = new String[]{"t_perm_log_user", "t_perm_log_diff_funcperm", "t_perm_log_diff_fieldperm", "t_perm_log_diff_newdr", "t_perm_log_diff_newdrprop", "t_perm_log_diff_dimuser", "t_perm_log_diff_commrole", "t_perm_log_diff_busirole", "t_perm_log_diff_bcperm", "t_perm_log_diff_disperm", "t_perm_log_diff_dimrange", "t_perm_log_diff_user", "t_perm_log_diff_dimrole", "t_perm_log_diff_dimfunc", "t_perm_log_diff_dimfield", "t_perm_log_diff_dimnewdr", "t_perm_log_diff_dimnewdrp", "t_perm_log_diff_dimdis", "t_perm_log_copytaruser", "t_perm_log_diff_busiunit", "t_perm_log_diff_admorg", "t_perm_log_diff_admorgusr", "t_perm_log_diff_app", "t_perm_log_diff_oprinfo", "t_perm_log_diff_oprdirect", "t_perm_log_diff_oprexusr", "t_perm_log_diff_oprexusgr", "t_perm_log_diff_oprexrole", "t_perm_log_diff_drinfo"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!PermCommonUtil.isEnablePermLog()) {
            return;
        }
        log.debug("\u6743\u9650\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u542f\u52a8");
        long startTime = System.currentTimeMillis();
        this.start();
        long spendTime = System.currentTimeMillis() - startTime;
        log.debug("\u6743\u9650\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u5b8c\u6210\u6240\u82b1\u8d39\u65f6\u957f\uff1a" + spendTime);
    }

    private void start() {
        Date curTime = new Date();
        List<Long> idList = PermLogService.getNeedArchievePermLogId();
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        String writeRecordSql = this.calcWriteRecordSql(COLUMN, "t_perm_log_archive");
        log.debug("\u6743\u9650\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u6267\u884c\u7684\u63d2\u5165sql\u8bed\u53e5\u3010" + writeRecordSql + "\u3011");
        int archiveCount = 0;
        String sql = "select " + StringUtils.join((Object[])COLUMN, (String)",") + " from " + "t_perm_log" + " where fid = ?";
        for (Long aLong : idList) {
            archiveCount = this.doArchive(curTime, writeRecordSql, archiveCount, sql, aLong);
        }
    }

    private int doArchive(Date curTime, String writeRecordSql, int archiveCount, String sql, Long aLong) {
        int batchSize = 1;
        LinkedList<Object> fidList = new LinkedList<Object>();
        ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(batchSize);
        try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{aLong});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object[] record = new Object[COLUMN.length];
                for (int j = 0; j < COLUMN.length; ++j) {
                    String str = COLUMN[j];
                    if ("fid".equals(str)) {
                        fidList.add(row.get(j));
                    }
                    record[j] = "ffiling_time".equals(str) ? curTime : row.get(j);
                }
                writeBuffer.add(record);
                if (writeBuffer.size() < batchSize) continue;
                this.batchInsert(writeBuffer, writeRecordSql, fidList);
                archiveCount += writeBuffer.size();
                writeBuffer.clear();
                fidList.clear();
            }
            if (!writeBuffer.isEmpty()) {
                this.batchInsert(writeBuffer, writeRecordSql, fidList);
                archiveCount += writeBuffer.size();
                writeBuffer.clear();
                fidList.clear();
            }
            log.debug("\u6743\u9650\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u5f52\u6863\u6570\u636e\u91cf\u5171\uff1a{}", (Object)archiveCount);
        }
        catch (Exception e) {
            log.warn("\u6743\u9650\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return archiveCount;
    }

    private void batchInsert(List<Object[]> records, String writeRecordSql, List<Object> fidList) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.log, (String)writeRecordSql, records);
                List fidStrList = fidList.stream().map(String::valueOf).collect(Collectors.toList());
                String fidStr = String.join((CharSequence)",", fidStrList);
                StringBuilder delSql = new StringBuilder();
                delSql.append("delete from ").append("t_perm_log");
                delSql.append(" where fid in (").append(fidStr).append(')');
                DB.execute((DBRoute)DBRoute.log, (String)delSql.toString());
                StringBuilder delSb = null;
                for (int i = 0; i < ARCHIVE_CLEAR_CHILD_TABLE.length; ++i) {
                    delSb = new StringBuilder();
                    delSb.append("delete from ").append(ARCHIVE_CLEAR_CHILD_TABLE[i]);
                    delSb.append(" where fperm_logid in (").append(fidStr).append(')');
                    DB.execute((DBRoute)DBRoute.log, (String)delSb.toString());
                }
                this.delOtherChildTab(records, fidStr);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private void delOtherChildTab(List<Object[]> records, String fidStr) {
        String busiType = "";
        try {
            Object[] objects = records.get(0);
            if (null == objects || 0 == objects.length) {
                return;
            }
            busiType = (String)objects[3];
            if (StringUtils.isEmpty((CharSequence)busiType)) {
                return;
            }
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType(busiType);
            if (null == permLogBusiType) {
                return;
            }
            String diffHandler = permLogBusiType.getDiffHandler();
            if (StringUtils.isEmpty((CharSequence)diffHandler)) {
                return;
            }
            PermLogDiffHandler handler = (PermLogDiffHandler)PermLogServiceFactory.getServiceByClassName(diffHandler);
            handler.delChildTab(fidStr);
        }
        catch (Exception e) {
            log.warn("PermLogArchiveTask.delOtherChildTab error, \u5220\u9664\u5176\u4ed6\u65e5\u5fd7\u5b50\u8868\u8bb0\u5f55, \u5f02\u5e38, busiType:{}, fidStr:{}", new Object[]{busiType, fidStr, e});
        }
    }

    public String calcWriteRecordSql(String[] column, String table) {
        ArrayList<String> valueHolders = new ArrayList<String>(column.length);
        for (int i = 0; i < column.length; ++i) {
            valueHolders.add("?");
        }
        String writeSqlTemplate = "insert into %s (" + StringUtils.join((Object[])column, (String)",") + ") values(" + StringUtils.join(valueHolders, (String)",") + ")";
        return String.format(writeSqlTemplate, table);
    }
}

