/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.formplugin.PermLogPlugin;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class PermLogAdminPlugin
extends PermLogPlugin {
    @Override
    public Map<String, String> getFieldAndKey() {
        HashMap<String, String> modelNameAndCustomParam = new HashMap<String, String>(5);
        modelNameAndCustomParam.put("eventid", "number");
        modelNameAndCustomParam.put("eventtype", "type");
        modelNameAndCustomParam.put("adminnumber", "itemNumber");
        modelNameAndCustomParam.put("admingroup", "itemName");
        modelNameAndCustomParam.put("operationtime", "operTime");
        return modelNameAndCustomParam;
    }

    @Override
    public List<BillList> getBillList() {
        ArrayList<BillList> billLists = new ArrayList<BillList>(8);
        String busiType = (String)this.getView().getFormShowParameter().getCustomParam("typeNum");
        if ("admin_add".equals(busiType) || "admin_del".equals(busiType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"diff_baseinfo", "diff_functionction", "diff_busiunit", "diff_admorg", "extra_affect_users", "diff_app"});
        } else {
            billLists.add((BillList)this.getControl("function"));
            billLists.add((BillList)this.getControl("busiunit"));
            billLists.add((BillList)this.getControl("admorg"));
            billLists.add((BillList)this.getControl("extrausers"));
            billLists.add((BillList)this.getControl("app"));
        }
        billLists.add((BillList)this.getControl("users"));
        return billLists;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadBaseInfoDiff();
    }

    private void loadBaseInfoDiff() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)this.getLogId())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PermLogAdminPlugin.loadBaseInfoDiff", (String)"perm_log", (String)"diff_content", (QFilter[])filters, (String)"");){
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_admingroup");
            for (Row row : dataSet) {
                String diffContent = row.getString("diff_content");
                if (StringUtils.isEmpty((String)diffContent)) continue;
                String uncompress = StrUtil.uncompress((String)diffContent);
                ObjectMapper mapper = new ObjectMapper();
                Map diffMap = (Map)mapper.readValue(uncompress, Map.class);
                AdmGroup before = (AdmGroup)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), AdmGroup.class);
                AdmGroup after = (AdmGroup)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_after")), AdmGroup.class);
                this.comparePropertyDiff(dataEntityType.getProperty("number"), before.getNumber(), after.getNumber());
                this.comparePropertyDiff(dataEntityType.getProperty("name"), before.getName(), after.getName());
                if (!Objects.equals(before.getParent(), after.getParent())) {
                    Map admGroupInfoMap = AdminGroupHelper.getAdmGroupInfoMap((Set)Sets.newHashSet((Object[])new Long[]{before.getParent(), after.getParent()}));
                    this.addPropertyDiff(dataEntityType.getProperty("parent"), null == admGroupInfoMap.get(before.getParent()) ? "" : ((AdmGroup)admGroupInfoMap.get(before.getParent())).getName(), null == admGroupInfoMap.get(after.getParent()) ? "" : ((AdmGroup)admGroupInfoMap.get(after.getParent())).getName());
                }
                if (!Objects.equals(before.getLevel(), after.getLevel())) {
                    this.addPropertyDiff(dataEntityType.getProperty("level"), before.getLevel(), after.getLevel());
                }
                if (!Objects.equals(before.getLongNum(), after.getLongNum())) {
                    this.addPropertyDiff(dataEntityType.getProperty("longnumber"), before.getLongNum(), after.getLongNum());
                }
                if (!Objects.equals(before.isLeaf(), after.isLeaf())) {
                    this.addPropertyDiff(dataEntityType.getProperty("isleaf"), before.isLeaf() ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc(), after.isLeaf() ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc());
                }
                if (!Objects.equals(before.getAdminScheme(), after.getAdminScheme())) {
                    this.comparePropertyDiff(dataEntityType.getProperty("adminscheme"), null == before.getAdminScheme() ? "" : this.getAdminSchemeName(before.getAdminScheme()), null == after.getAdminScheme() ? "" : this.getAdminSchemeName(after.getAdminScheme()));
                }
                if (!Objects.equals(before.getAdminType(), after.getAdminType())) {
                    this.comparePropertyDiff(dataEntityType.getProperty("admintype"), null == before.getAdminType() ? "" : this.getAdminTypeName(before.getAdminType()), null == after.getAdminType() ? "" : this.getAdminTypeName(after.getAdminType()));
                }
                if (!Objects.equals(before.domainGroup(), after.domainGroup())) {
                    this.comparePropertyDiff(dataEntityType.getProperty("isdomain"), before.domainGroup() ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc(), after.domainGroup() ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc());
                }
                if (!Objects.equals(before.getDomain(), after.getDomain())) {
                    this.comparePropertyDiff(dataEntityType.getProperty("domain"), null == before.getDomain() ? "" : this.getAdminDomainName(before.getDomain()), null == after.getDomain() ? "" : this.getAdminDomainName(after.getDomain()));
                }
                if (Objects.equals(before.getDescription(), after.getDescription())) continue;
                this.comparePropertyDiff(dataEntityType.getProperty("description"), before.getDescription(), after.getDescription());
            }
        }
        catch (Exception e) {
            log.error("\u7ba1\u7406\u5458\u7ec4\u57fa\u672c\u4fe1\u606f\u5c55\u793a\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
    }

    private String getAdminDomainName(Long domainId) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)domainId, (String)"perm_admindomain");
        return null == dyn ? String.valueOf(domainId) : dyn.getString("name");
    }

    private String getAdminSchemeName(Long adminScheme) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)adminScheme, (String)"perm_adminscheme");
        return null == dyn ? String.valueOf(adminScheme) : dyn.getString("name");
    }

    private String getAdminTypeName(Long adminType) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)adminType, (String)"perm_admintype");
        return null == dyn ? String.valueOf(adminType) : dyn.getString("name");
    }
}

