/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class PermLogBakTimeSetPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PermLogBakTimeSetPlugin.class);
    private static final String CONTROL_MYFID = "myfid";
    private static final String CONTROL_ARCHIVEA_PERIOD = "archivea_period";
    private static final String CONTROL_BUSITYPESELECT = "busitypeselect";
    private static final String FILTER_BUSITYPECUSTOM = "filter_busitypecustom";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"query"});
    }

    private static List<QFilter> getQfilter(IPageCache pageCache, String key) {
        String filterJson = pageCache.get(key);
        ArrayList<QFilter> qFilterList = null;
        if (StringUtils.isNotEmpty((String)filterJson)) {
            List list = (List)SerializationUtils.fromJsonString((String)filterJson, List.class);
            qFilterList = new ArrayList<QFilter>(list.size());
            boolean i = false;
            for (String qfilterStr : list) {
                qFilterList.add(QFilter.fromSerializedString((String)qfilterStr));
            }
        }
        return qFilterList;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<QFilter> qFilterList = PermLogBakTimeSetPlugin.getQfilter(this.getPageCache(), FILTER_BUSITYPECUSTOM);
        Map busiTypeMap = PermLogService.loadBusiTypeMapFromDB(qFilterList);
        if (null == busiTypeMap || busiTypeMap.isEmpty()) {
            return;
        }
        this.loadBUsiTypeMulCombo(busiTypeMap);
        this.loadFL(busiTypeMap);
        Long curUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)curUserId);
        boolean superAdminUser = PermissionServiceHelper.isAdminUser((long)curUserId, (String)"10");
        if (!superUser && !superAdminUser) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{CONTROL_ARCHIVEA_PERIOD});
        }
    }

    private void loadBUsiTypeMulCombo(Map<String, PermLogBusiType> busiTypeMap) {
        if (null == busiTypeMap || busiTypeMap.isEmpty()) {
            return;
        }
        MulComboEdit busitypeselect = (MulComboEdit)this.getControl(CONTROL_BUSITYPESELECT);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(busiTypeMap.size());
        for (Map.Entry<String, PermLogBusiType> entry : busiTypeMap.entrySet()) {
            PermLogBusiType value = entry.getValue();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(value.getBusiType());
            comboItem.setCaption(new LocaleString(value.getBusiTypeDesc()));
            propertyItems.add(comboItem);
        }
        busitypeselect.setComboItems(propertyItems);
    }

    private void loadFL(Map<String, PermLogBusiType> busiTypeMap) {
        if (null == busiTypeMap || busiTypeMap.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(CONTROL_MYFID, new Object[0]);
        vs.addField("busitype", new Object[0]);
        vs.addField("busitypedesc", new Object[0]);
        vs.addField(CONTROL_ARCHIVEA_PERIOD, new Object[0]);
        for (Map.Entry<String, PermLogBusiType> entry : busiTypeMap.entrySet()) {
            PermLogBusiType value = entry.getValue();
            vs.addRow(new Object[]{value.getFid(), value.getBusiType(), value.getBusiTypeDesc(), value.getArchiveaPeriod()});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (null == changeSet || 0 == changeSet.length) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        if (Objects.equals(newValue, oldValue = changeData.getOldValue())) {
            return;
        }
        DynamicObject dataEntity = changeData.getDataEntity();
        String propName = e.getProperty().getName();
        if (CONTROL_ARCHIVEA_PERIOD.equals(propName)) {
            long myfid = dataEntity.getLong(CONTROL_MYFID);
            int archivea_period = dataEntity.getInt(CONTROL_ARCHIVEA_PERIOD);
            StringBuilder sb = new StringBuilder().append("update t_permlog_busitype set farchivea_period = ?, fmodifierid = ?, fmodify_time = ? where fid = ? ");
            DB.execute((DBRoute)DBRoute.log, (String)sb.toString(), (Object[])new Object[]{archivea_period, RequestContext.get().getCurrUserId(), new Date(), myfid});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PermLogBakTimeSetPlugin_0", (String)"bos-permission-log-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void click(EventObject evt) {
        Object source;
        super.click(evt);
        List<QFilter> qFilterList = PermLogBakTimeSetPlugin.getQfilter(this.getPageCache(), FILTER_BUSITYPECUSTOM);
        if (null == qFilterList || qFilterList.isEmpty()) {
            qFilterList = new ArrayList<QFilter>(8);
        }
        if ((source = evt.getSource()) instanceof Button) {
            String key;
            switch (key = ((Button)source).getKey()) {
                case "query": {
                    Object value = this.getModel().getValue(CONTROL_BUSITYPESELECT);
                    if (null == value) {
                        Map busiTypeMap = PermLogService.loadBusiTypeMapFromDB(qFilterList);
                        this.loadFL(busiTypeMap);
                        break;
                    }
                    String[] split = String.valueOf(value).split(",");
                    if (null == split || 0 == split.length) {
                        Map busiTypeMap = PermLogService.loadBusiTypeMapFromDB(qFilterList);
                        this.loadFL(busiTypeMap);
                        break;
                    }
                    Set collect = Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x.trim())).collect(Collectors.toSet());
                    if (null == collect || collect.isEmpty()) {
                        Map busiTypeMap = PermLogService.loadBusiTypeMapFromDB(qFilterList);
                        this.loadFL(busiTypeMap);
                        break;
                    }
                    qFilterList.add(new QFilter("busitype", "in", collect));
                    Map busiTypeMap = PermLogService.loadBusiTypeMapFromDB(qFilterList);
                    this.loadFL(busiTypeMap);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }
}

