/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.formplugin.PermLogPlugin;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class PermLogBizRolePlugin
extends PermLogPlugin {
    @Override
    public List<BillList> getBillList() {
        ArrayList<BillList> billLists = new ArrayList<BillList>(8);
        billLists.add((BillList)this.getControl("role"));
        billLists.add((BillList)this.getControl("bcperm"));
        billLists.add((BillList)this.getControl("disperm"));
        billLists.add((BillList)this.getControl("dimrange"));
        billLists.add((BillList)this.getControl("users"));
        return billLists;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadBaseInfoDiff();
    }

    private void loadBaseInfoDiff() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)this.getLogId())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PermLogBizRolePlugin.loadBaseInfoDiff", (String)"perm_log", (String)"diff_content", (QFilter[])filters, (String)"");){
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_busirole");
            for (Row row : dataSet) {
                Set<String> afterTypeIds;
                Set<String> beforeTypeIds;
                String diffContent = row.getString("diff_content");
                if (StringUtils.isEmpty((String)diffContent)) continue;
                String uncompress = StrUtil.uncompress((String)diffContent);
                ObjectMapper mapper = new ObjectMapper();
                Map diffMap = (Map)mapper.readValue(uncompress, Map.class);
                BusiRole beforeRole = (BusiRole)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), BusiRole.class);
                BusiRole afterRole = (BusiRole)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_after")), BusiRole.class);
                this.comparePropertyDiff(dataEntityType.getProperty("number"), beforeRole.getNumber(), afterRole.getNumber());
                this.comparePropertyDiff(dataEntityType.getProperty("name"), beforeRole.getName(), afterRole.getName());
                if (!Objects.equals(beforeRole.getType(), afterRole.getType()) && !this.compareCollection(beforeTypeIds = this.splitIds(beforeRole.getType()), afterTypeIds = this.splitIds(afterRole.getType()))) {
                    Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", null);
                    this.addPropertyDiff(dataEntityType.getProperty("usertype"), this.getNames(objMap, beforeTypeIds), this.getNames(objMap, afterTypeIds));
                }
                if (!Objects.equals(beforeRole.getGroupId(), afterRole.getGroupId())) {
                    long beforeId = StringUtils.isEmpty((String)beforeRole.getGroupId()) ? 0L : Long.parseLong(beforeRole.getGroupId());
                    long afterId = StringUtils.isEmpty((String)afterRole.getGroupId()) ? 0L : Long.parseLong(afterRole.getGroupId());
                    Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_busirolegroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)new Object[]{beforeId, afterId})});
                    this.addPropertyDiff(dataEntityType.getProperty("group"), this.getName(objMap, beforeId), this.getName(objMap, afterId));
                }
                this.comparePropertyDiff(dataEntityType.getProperty("description"), beforeRole.getRemark(), afterRole.getRemark());
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u5c55\u793a\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
    }
}

