/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.formplugin.PermLogPlugin;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class PermLogCommonRolePlugin
extends PermLogPlugin {
    @Override
    public List<BillList> getBillList() {
        ArrayList<BillList> billList = new ArrayList<BillList>(8);
        billList.add((BillList)this.getControl("function"));
        billList.add((BillList)this.getControl("fps_sensitive"));
        billList.add((BillList)this.getControl("fps"));
        billList.add((BillList)this.getControl("fieldperm"));
        billList.add((BillList)this.getControl("datarules"));
        billList.add((BillList)this.getControl("datarange"));
        billList.add((BillList)this.getControl("usescope"));
        billList.add((BillList)this.getControl("users"));
        return billList;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addSetFilterListeners();
    }

    private void addSetFilterListeners() {
        List<BillList> billList = this.getBillList();
        if (CollectionUtils.isEmpty(billList)) {
            return;
        }
        for (BillList billlist : billList) {
            billlist.addSetFilterListener(setFilterEvent -> {
                List qFilters = setFilterEvent.getQFilters();
                String key = ((BillList)setFilterEvent.getSource()).getKey();
                if (Objects.equals("fps_sensitive", key)) {
                    qFilters.add(new QFilter("sensitive", "=", (Object)"1"));
                } else if (Objects.equals("fps", key)) {
                    qFilters.add(new QFilter("sensitive", "=", (Object)"0"));
                }
            });
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadBaseInfoDiff();
    }

    private void loadBaseInfoDiff() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)this.getLogId())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PermLogCommonRolePlugin.loadBaseInfoDiff", (String)"perm_log", (String)"diff_content", (QFilter[])filters, (String)"");){
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_role");
            for (Row row : dataSet) {
                DynamicProperty useScopeProp;
                Set<String> afterTypeIds;
                Set<String> beforeTypeIds;
                String diffContent = row.getString("diff_content");
                if (StringUtils.isEmpty((String)diffContent)) continue;
                String uncompress = StrUtil.uncompress((String)diffContent);
                ObjectMapper mapper = new ObjectMapper();
                Map diffMap = (Map)mapper.readValue(uncompress, Map.class);
                ComRole beforeRole = (ComRole)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_pre")), ComRole.class);
                ComRole afterRole = (ComRole)mapper.readValue(mapper.writeValueAsString(diffMap.get("baseInfoDB_after")), ComRole.class);
                this.comparePropertyDiff(dataEntityType.getProperty("number"), beforeRole.getNumber(), afterRole.getNumber());
                this.comparePropertyDiff(dataEntityType.getProperty("name"), beforeRole.getName(), afterRole.getName());
                if (!Objects.equals(beforeRole.getBizDomainId(), afterRole.getBizDomainId())) {
                    this.addPropertyDiff(dataEntityType.getProperty("bizdomain"), this.getAppName(beforeRole.getBizDomainId()), this.getAppName(afterRole.getBizDomainId()));
                }
                if (!Objects.equals(beforeRole.getType(), afterRole.getType()) && !this.compareCollection(beforeTypeIds = this.splitIds(beforeRole.getType()), afterTypeIds = this.splitIds(afterRole.getType()))) {
                    Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", null);
                    this.addPropertyDiff(dataEntityType.getProperty("roletype"), this.getNames(objMap, beforeTypeIds), this.getNames(objMap, afterTypeIds));
                }
                if (!Objects.equals(beforeRole.getGroupId(), afterRole.getGroupId())) {
                    Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_rolegroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)new String[]{beforeRole.getGroupId(), afterRole.getGroupId()})});
                    this.addPropertyDiff(dataEntityType.getProperty("group"), this.getName(objMap, beforeRole.getGroupId()), this.getName(objMap, afterRole.getGroupId()));
                }
                this.comparePropertyDiff(dataEntityType.getProperty("issystem"), beforeRole.isSystem() != false ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc(), afterRole.isSystem() != false ? ConstantsHelper.getYesDesc() : ConstantsHelper.getNoDesc());
                if (!Objects.equals(beforeRole.getCreateAdminGrp(), afterRole.getCreateAdminGrp())) {
                    long beforeId = StringUtils.isEmpty((String)beforeRole.getCreateAdminGrp()) ? 0L : Long.parseLong(beforeRole.getCreateAdminGrp());
                    long afterId = StringUtils.isEmpty((String)afterRole.getCreateAdminGrp()) ? 0L : Long.parseLong(afterRole.getCreateAdminGrp());
                    QFilter[] grpFilters = new QFilter[]{new QFilter("id", "in", (Object)new Object[]{beforeId, afterId})};
                    Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_admingroup", (QFilter[])grpFilters);
                    this.addPropertyDiff(dataEntityType.getProperty("createadmingrp"), this.getName(objMap, beforeId), this.getName(objMap, afterId));
                }
                if (!Objects.equals(beforeRole.getUseScope(), afterRole.getUseScope()) && (useScopeProp = dataEntityType.getProperty("usescope")) instanceof ComboProp) {
                    List comboItems = ((ComboProp)useScopeProp).getComboItems();
                    HashMap<String, String> comboItemNameMap = new HashMap<String, String>(comboItems.size());
                    for (ValueMapItem comboItem : comboItems) {
                        LocaleString name = comboItem.getName();
                        comboItemNameMap.put(comboItem.getValue(), name == null ? "" : name.getLocaleValue());
                    }
                    this.addPropertyDiff(dataEntityType.getProperty("usescope"), comboItemNameMap.get(beforeRole.getUseScope()), comboItemNameMap.get(afterRole.getUseScope()));
                }
                this.comparePropertyDiff(dataEntityType.getProperty("remark"), beforeRole.getRemark(), afterRole.getRemark());
            }
        }
        catch (Exception e) {
            log.error("\u901a\u7528\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u5c55\u793a\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
    }

    private String getAppName(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        try {
            AppInfo appInfo = AppHelper.getMetaAppInfo((String)id);
            return appInfo.getName().getLocaleValue();
        }
        catch (Exception e) {
            return id;
        }
    }
}

