/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.formplugin.utils.PermLogCommUtil;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.util.StringUtils;

public class PermLogDataRulePlugin
extends AbstractFormPlugin {
    private static final String USERS = "users";
    private static final String PERM_LOGID = "perm_logid";
    private static final String ENTITY_ID = "fentity_id";
    private static final String BASIC_INFO = "basic_info";
    private static final String EVENT_ID = "eventid";
    private static final String OPERATION_TYPE = "operation_type";
    private static final String ITEM_NAME = "item_name";
    private static final String ITEM_NUMBER = "item_number";
    private static final String OPERATION_TIME = "operation_time";
    private static final String RULE_NUM = "rule_num";
    private static final String RULE_NAME = "rule_name";
    private static final String OLD_RULE = "old_rule";
    private static final String NEW_RULE = "new_rule";

    public void initialize() {
        super.initialize();
        this.addSetFilterListeners();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String eventId = (String)this.getView().getFormShowParameter().getCustomParam("eventId");
        Long logId = 0L;
        if (StringUtils.isNotEmpty((String)eventId)) {
            logId = Long.valueOf(eventId);
        }
        HashMap<String, String> selectField = new HashMap<String, String>(8);
        selectField.put(OLD_RULE, "frule");
        selectField.put(NEW_RULE, "frule_after");
        selectField.put(ENTITY_ID, ENTITY_ID);
        Map results = PermLogUtil.selectSingleFromInfo(selectField, (Long)logId, (String)"t_perm_log_diff_drinfo");
        if (results != null) {
            this.fillFilterGrid(results, (String)results.remove(ENTITY_ID));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillBasicInformation();
    }

    private void addSetFilterListeners() {
        String eventId = (String)this.getView().getFormShowParameter().getCustomParam("eventId");
        Long logId = 0L;
        if (StringUtils.isNotEmpty((String)eventId)) {
            logId = Long.valueOf(eventId);
        }
        QFilter qFilter = new QFilter(PERM_LOGID, "=", (Object)logId);
        ArrayList<BillList> billLists = new ArrayList<BillList>(1);
        billLists.add((BillList)this.getControl(USERS));
        PermLogCommUtil.setFilter(billLists, qFilter);
    }

    private void fillBasicInformation() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String eventId = (String)formShowParameter.getCustomParam("eventId");
        Long logId = 0L;
        if (StringUtils.isNotEmpty((String)eventId)) {
            logId = Long.valueOf(eventId);
        }
        this.getModel().setValue(EVENT_ID, formShowParameter.getCustomParam("number"));
        this.getModel().setValue(OPERATION_TYPE, formShowParameter.getCustomParam("type"));
        this.getModel().setValue(OPERATION_TIME, formShowParameter.getCustomParam("operTime"));
        this.getModel().setValue(RULE_NUM, formShowParameter.getCustomParam("itemNumber"));
        this.getModel().setValue(RULE_NAME, formShowParameter.getCustomParam("itemName"));
        HashMap<String, String> selectField = new HashMap<String, String>(8);
        selectField.put(ITEM_NAME, "fentity_name");
        selectField.put(ITEM_NUMBER, ENTITY_ID);
        Map results = PermLogUtil.selectSingleFromInfo(selectField, (Long)logId, (String)"t_perm_log_diff_drinfo");
        if (results != null && results.size() > 0) {
            for (Map.Entry result : results.entrySet()) {
                String key = (String)result.getKey();
                String value = (String)result.getValue();
                this.getModel().setValue(key, (Object)value);
            }
        }
    }

    private void fillFilterGrid(Map<String, String> jsonMap, String entityId) {
        if (jsonMap == null) {
            return;
        }
        if (StringUtils.isEmpty((String)entityId)) {
            entityId = "bos_billorgtpl";
        }
        for (Map.Entry<String, String> map : jsonMap.entrySet()) {
            String value = map.getValue();
            String key = map.getKey();
            if (StringUtils.isNotEmpty((String)value)) {
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(key);
                filterGrid.setEntityNumber(entityId);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
                GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
                HashMap filterGridObjectMap = new HashMap(8);
                DrHelper.addCustomCompareType(filterGridObjectMap, (GetFilterFieldsParameter)getFilterFieldsParameter);
                List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
                PermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
                filterGrid.setFilterColumns(filterColumns);
                for (Map.Entry filterGridObject : filterGridObjectMap.entrySet()) {
                    filterGrid.addCustomCompareTypes((String)filterGridObject.getKey(), new ArrayList((Collection)filterGridObject.getValue()));
                }
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)value, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
            }
            this.getView().updateView(key);
        }
    }
}

