/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.ComboEdit;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.FieldPermSchemeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.log.formplugin.PermLogPlugin;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.util.StringUtils;

public class PermLogFpsPlugin
extends PermLogPlugin {
    private static Log log = LogFactory.getLog(PermLogFpsPlugin.class);

    @Override
    public List<BillList> getBillList() {
        ArrayList<BillList> billList = new ArrayList<BillList>(8);
        billList.add((BillList)this.getControl("fieldperm"));
        billList.add((BillList)this.getControl("users"));
        return billList;
    }

    @Override
    public Map<String, String> getFieldAndKey() {
        HashMap<String, String> modelNameAndCustomParam = new HashMap<String, String>(5);
        modelNameAndCustomParam.put("eventid", "number");
        modelNameAndCustomParam.put("eventtype", "type");
        modelNameAndCustomParam.put("operationtime", "operTime");
        try {
            String eventId = (String)this.getView().getFormShowParameter().getCustomParam("eventId");
            if (StringUtils.isEmpty((String)eventId)) {
                return modelNameAndCustomParam;
            }
            Long logId = Long.valueOf(eventId);
            HashMap<String, String> selectField = new HashMap<String, String>(8);
            selectField.put("pre_data", "fpre_data");
            selectField.put("after_data", "fafter_data");
            Map results = PermLogService.selectSingleFromPermLog(selectField, (Long)logId);
            if (null == results || results.isEmpty()) {
                return modelNameAndCustomParam;
            }
            String fpre_data = (String)results.get("pre_data");
            String fafter_data = (String)results.get("after_data");
            FieldPermScheme pre = StringUtils.isEmpty((String)fpre_data) ? new FieldPermScheme() : (FieldPermScheme)new ObjectMapper().readValue(fpre_data, FieldPermScheme.class);
            FieldPermScheme after = StringUtils.isEmpty((String)fafter_data) ? new FieldPermScheme() : (FieldPermScheme)new ObjectMapper().readValue(fafter_data, FieldPermScheme.class);
            String entnum = StringUtils.isEmpty((String)pre.getEntityNumber()) ? after.getEntityNumber() : pre.getEntityNumber();
            String formName = FormHelper.getFormName((String)entnum);
            IDataModel dataModel = this.getModel();
            dataModel.setValue("entname", (Object)formName);
            dataModel.setValue("entnumber", (Object)entnum);
            this.buildControlFieldTypeComboEditInPlugin();
            String op_item_name = StringUtils.isEmpty((String)after.getName()) ? pre.getName() : after.getName();
            dataModel.setValue("op_item_name", (Object)op_item_name);
            String op_item_number = StringUtils.isEmpty((String)after.getNumber()) ? pre.getNumber() : after.getNumber();
            dataModel.setValue("op_item_number", (Object)op_item_number);
            String fieldfrom = StringUtils.isEmpty((String)after.getFieldFrom()) ? pre.getFieldFrom() : after.getFieldFrom();
            dataModel.setValue("fieldfrom", (Object)fieldfrom);
            String controlfieldtype = StringUtils.isEmpty((String)after.getControlFieldType()) ? pre.getControlFieldType() : after.getControlFieldType();
            dataModel.setValue("controlfieldtype", (Object)controlfieldtype);
            String controlmode = StringUtils.isEmpty((String)after.getControlMode()) ? pre.getControlMode() : after.getControlMode();
            dataModel.setValue("controlmode", (Object)controlmode);
            String desc = StringUtils.isEmpty((String)after.getDesc()) ? pre.getDesc() : after.getDesc();
            dataModel.setValue("desc", (Object)desc);
        }
        catch (Exception e) {
            log.warn("PermLogFpsPlugin.getFieldAndKey error", (Throwable)e);
        }
        return modelNameAndCustomParam;
    }

    private void buildControlFieldTypeComboEditInPlugin() {
        Object entNumObj = this.getModel().getValue("entnumber");
        if (Objects.isNull(entNumObj)) {
            return;
        }
        String entNum = (String)entNumObj;
        ComboEdit selectControlFieldTypeComboEdit = (ComboEdit)this.getControl("controlfieldtype");
        FieldPermSchemeHelper.buildControlFieldTypeComboEdit((String)entNum, (ComboEdit)selectControlFieldTypeComboEdit);
    }
}

