/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.log.formplugin.utils.PermLogCommUtil;
import kd.bos.util.StringUtils;

public abstract class PermLogPlugin
extends AbstractFormPlugin {
    protected static final Log log = LogFactory.getLog(PermLogPlugin.class);
    protected static final String NAME_SPLIT = "; ";

    public abstract List<BillList> getBillList();

    public void initialize() {
        super.initialize();
        this.addSetFilterListeners();
    }

    public void afterCreateNewData(EventObject e) {
        Long logId = this.getLogId();
        if (logId != 0L) {
            this.fillBasicInformation();
        }
    }

    private void addSetFilterListeners() {
        List<BillList> billList = this.getBillList();
        if (CollectionUtils.isEmpty(billList)) {
            return;
        }
        Long logId = this.getLogId();
        QFilter qFilter = new QFilter("perm_logid", "=", (Object)logId);
        PermLogCommUtil.setFilter(billList, qFilter);
    }

    protected Long getLogId() {
        String eventId = (String)this.getView().getFormShowParameter().getCustomParam("eventId");
        Long logId = 0L;
        if (StringUtils.isNotEmpty((String)eventId)) {
            logId = Long.valueOf(eventId);
        }
        return logId;
    }

    private void fillBasicInformation() {
        PermLogCommUtil.fillField(this.getModel(), this.getView(), this.getFieldAndKey());
    }

    public Map<String, String> getFieldAndKey() {
        HashMap<String, String> modelNameAndCustomParam = new HashMap<String, String>(5);
        modelNameAndCustomParam.put("eventid", "number");
        modelNameAndCustomParam.put("eventtype", "type");
        modelNameAndCustomParam.put("roleid", "itemNumber");
        modelNameAndCustomParam.put("rolename", "itemName");
        modelNameAndCustomParam.put("operationtime", "operTime");
        return modelNameAndCustomParam;
    }

    protected Set<String> splitIds(String idStr) {
        if (StringUtils.isEmpty((String)idStr)) {
            return new HashSet<String>();
        }
        String[] splitArr = idStr.split(",");
        HashSet<String> ids = new HashSet<String>(splitArr.length);
        for (String id : splitArr) {
            if (!StringUtils.isNotEmpty((String)id)) continue;
            ids.add(id.trim());
        }
        return ids;
    }

    protected boolean compareCollection(Set set1, Set set2) {
        HashSet difference;
        if (set1.size() > set2.size()) {
            difference = new HashSet(set1);
            difference.removeAll(set2);
        } else {
            difference = new HashSet(set2);
            difference.removeAll(set1);
        }
        return difference.isEmpty();
    }

    protected String getNames(Map<Object, DynamicObject> objMap, Set<String> ids) {
        StringJoiner names = new StringJoiner(NAME_SPLIT);
        for (String id : ids) {
            String name = this.getName(objMap, Long.valueOf(id));
            if (!StringUtils.isNotEmpty((String)name)) continue;
            names.add(name);
        }
        return names.toString();
    }

    protected String getName(Map<Object, DynamicObject> objMap, Object id) {
        DynamicObject obj = objMap.get(id);
        return obj == null ? "" : obj.getString("name");
    }

    protected void comparePropertyDiff(DynamicProperty property, String beforeValue, String afterValue) {
        if (!Objects.equals(beforeValue, afterValue)) {
            this.addPropertyDiff(property, beforeValue, afterValue);
        }
    }

    protected void addPropertyDiff(DynamicProperty property, Object beforeValue, Object afterValue) {
        if (property == null) {
            return;
        }
        int index = this.getModel().createNewEntryRow("diff_baseinfo_entry");
        this.getModel().setValue("propertyname", (Object)property.getDisplayName().getLocaleValue(), index);
        this.getModel().setValue("beforevalue", beforeValue, index);
        this.getModel().setValue("aftervalue", afterValue, index);
    }
}

