/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.LogQueryHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.util.StringUtils;

public class PermLogQueryListPlugin
extends AbstractListPlugin
implements PagerClickListener {
    private static Log logger = LogFactory.getLog(PermLogQueryListPlugin.class);
    public static final String BUTTON_OPERSET = "bar_set";
    private static final String SEARCHKW = "searchkw";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void addClickListeners(String ... arg0) {
        super.addClickListeners(arg0);
    }

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long focusRowPkId = (Long)billList.getFocusRowPkId();
        HashMap<String, String> selectField = new HashMap<String, String>(8);
        selectField.put("typeNum", "fbusi_type");
        selectField.put("type", "fbusi_from");
        selectField.put("eventId", "fid");
        selectField.put("number", "fnumber");
        selectField.put("itemNumber", "fop_item_number");
        selectField.put("itemName", "fop_item_name");
        selectField.put("operTime", "foper_time");
        selectField.put("op_desc", "fop_desc");
        Map results = PermLogService.selectSingleFromPermLog(selectField, (Long)focusRowPkId);
        if (results == null) {
            return;
        }
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)((String)results.get("typeNum")));
        String formId = "";
        if (permLogBusiType != null) {
            formId = permLogBusiType.getDetailForm();
        }
        String newPageId = this.getView().getParentView().getPageId() + "|" + (String)results.get("eventId") + "|" + formId;
        IFormView view = this.getView().getView(newPageId);
        if (StringUtils.isNotEmpty((String)formId)) {
            if (view != null) {
                PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
            } else {
                FormShowParameter lsp = new FormShowParameter();
                lsp.setFormId(formId);
                lsp.setPageId(newPageId);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                for (Map.Entry result : results.entrySet()) {
                    lsp.setCustomParam((String)result.getKey(), result.getValue());
                }
                this.getView().showForm(lsp);
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                String operationKey = operationColItem.getOperationKey();
                if ("perm_diff".equalsIgnoreCase(operationKey)) {
                    operationColItem.setVisible(false);
                    continue;
                }
                if (!"influence_user".equals(operationKey)) continue;
            }
        }
        super.packageData(e);
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("oper_time desc");
        super.initialize();
        this.addListener();
    }

    private void addListener() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(new SearchClickListener(){

            public void click(SearchClickEvent searchClickEvent) {
                List fastFilterValues = searchClickEvent.getFastFilterValues();
                if (CollectionUtils.isEmpty((Collection)fastFilterValues)) {
                    PermLogQueryListPlugin.this.getPageCache().put(PermLogQueryListPlugin.SEARCHKW, "");
                    return;
                }
                ArrayList<String> searchkwList = new ArrayList<String>(8);
                for (Map fastFilterValue : fastFilterValues) {
                    List fieldNameList = (List)fastFilterValue.get("FieldName");
                    List valueList = (List)fastFilterValue.get("Value");
                    if (CollectionUtils.isEmpty((Collection)fieldNameList) || CollectionUtils.isEmpty((Collection)valueList)) continue;
                    int index = 0;
                    for (Object o : fieldNameList) {
                        if (PermLogQueryListPlugin.SEARCHKW.equals(o)) break;
                        ++index;
                    }
                    searchkwList.add(String.valueOf(valueList.get(index)));
                }
                PermLogQueryListPlugin.this.getPageCache().put(PermLogQueryListPlugin.SEARCHKW, SerializationUtils.toJsonString(searchkwList));
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u5e74", (String)"PermLogQueryListPlugin_0", (String)"bos-permission-log-formplugin", (Object[])new Object[0]));
            return;
        }
        String searchkw = this.getPageCache().get(SEARCHKW);
        if (StringUtils.isEmpty((String)searchkw)) {
            return;
        }
        List searchkwList = (List)SerializationUtils.fromJsonString((String)searchkw, List.class);
        Set logIdSet = LogQueryHelper.getLogIdSet((List)searchkwList);
        if (CollectionUtils.isEmpty((Collection)logIdSet)) {
            QFilter logIdFilter = new QFilter("1", "!=", (Object)1);
            qfilters.add(logIdFilter);
        } else {
            QFilter logIdFilter = new QFilter("id", "in", (Object)logIdSet);
            qfilters.add(logIdFilter);
        }
    }

    private boolean check(List<QFilter> qfilters) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        qfilters.removeIf(x -> String.valueOf(x.getValue()).contains(SEARCHKW));
        for (QFilter filter : qfilters) {
            if (!"oper_time".equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (!CollectionUtils.isEmpty((Collection)qfilterNests)) continue;
        }
        return checkResult;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void showLogSetting() {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("permlog_baktime_set");
        this.getView().showForm(para);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = null;
        if (e.getSource() instanceof FormOperate) {
            opKey = ((FormOperate)e.getSource()).getOperateKey();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "donothing_archiveset": {
                OperationResult operationResult = e.getOperationResult();
                if (null == operationResult || !operationResult.isSuccess()) break;
                this.showLogSetting();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    public void pagerClick(PagerClickEvent arg0) {
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }
}

